/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.testing.junit;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.external.org.objectweb.asm.ClassReader;
import org.glassfish.hk2.external.org.objectweb.asm.ClassVisitor;
import org.glassfish.hk2.utilities.DescriptorImpl;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.junit.Before;
import org.jvnet.hk2.testing.junit.annotations.Classes;
import org.jvnet.hk2.testing.junit.annotations.Excludes;
import org.jvnet.hk2.testing.junit.annotations.InhabitantFiles;
import org.jvnet.hk2.testing.junit.annotations.Packages;
import org.jvnet.hk2.testing.junit.internal.ClassVisitorImpl;
import org.jvnet.hk2.testing.junit.internal.ErrorServiceImpl;
import org.jvnet.hk2.testing.junit.internal.JustInTimeInjectionResolverImpl;

public class HK2Runner {
    private static final String CLASS_PATH_PROP = "java.class.path";
    private static final String DOT_CLASS = ".class";
    protected ServiceLocator testLocator;
    private boolean verbose = false;

    @Before
    public void before() {
        Packages packages = this.getClass().getAnnotation(Packages.class);
        if (packages == null) {
            this.initialize(this.getClass().getName(), Collections.singletonList(this.getClass().getPackage().getName()), null, null, null);
        } else {
            this.initialize(null, null, null, null, null);
        }
    }

    public void initialize() {
        this.initialize(null, null, null, null, null);
    }

    protected void initialize(String name, List<String> packages, List<Class<?>> clazzes) {
        this.initialize(name, packages, clazzes, null, null);
    }

    protected void initialize(String name, List<String> packages, List<Class<?>> clazzes, Set<String> excludes) {
        this.initialize(name, packages, clazzes, excludes, null);
    }

    private List<String> getDefaultPackages() {
        Packages packages = this.getClass().getAnnotation(Packages.class);
        if (packages == null) {
            return Collections.emptyList();
        }
        ArrayList<String> retVal = new ArrayList<String>(packages.value().length);
        for (String pack : packages.value()) {
            if ("${THIS}".equals(pack)) {
                retVal.add(this.getClass().getPackage().getName());
                continue;
            }
            retVal.add(pack);
        }
        return retVal;
    }

    private List<Class<?>> getDefaultClazzes() {
        Classes clazzes = this.getClass().getAnnotation(Classes.class);
        if (clazzes == null) {
            return Collections.emptyList();
        }
        ArrayList retVal = new ArrayList(clazzes.value().length);
        for (Class<?> clazz : clazzes.value()) {
            retVal.add(clazz);
        }
        return retVal;
    }

    private Set<String> getDefaultExcludes() {
        Excludes excludes = this.getClass().getAnnotation(Excludes.class);
        if (excludes == null) {
            return Collections.emptySet();
        }
        HashSet<String> retVal = new HashSet<String>();
        for (String exclude : excludes.value()) {
            retVal.add(exclude);
        }
        return retVal;
    }

    private Set<String> getDefaultLocatorFiles() {
        HashSet<String> retVal = new HashSet<String>();
        InhabitantFiles iFiles = this.getClass().getAnnotation(InhabitantFiles.class);
        if (iFiles == null) {
            retVal.add("META-INF/hk2-locator/default");
            return retVal;
        }
        for (String iFile : iFiles.value()) {
            retVal.add(iFile);
        }
        return retVal;
    }

    protected void initialize(String name, List<String> packages, List<Class<?>> clazzes, Set<String> excludes, Set<String> locatorFiles) {
        ServiceLocator found;
        if (name == null) {
            name = this.getClass().getName();
        }
        if (packages == null) {
            packages = this.getDefaultPackages();
        }
        if (clazzes == null) {
            clazzes = this.getDefaultClazzes();
        }
        if (excludes == null) {
            excludes = this.getDefaultExcludes();
        }
        if (locatorFiles == null) {
            locatorFiles = this.getDefaultLocatorFiles();
        }
        if ((found = ServiceLocatorFactory.getInstance().find(name)) != null) {
            this.testLocator = found;
            this.testLocator.inject((Object)this);
            return;
        }
        this.testLocator = ServiceLocatorFactory.getInstance().create(name);
        ServiceLocatorUtilities.addClasses((ServiceLocator)this.testLocator, (Class[])new Class[]{ErrorServiceImpl.class, JustInTimeInjectionResolverImpl.class});
        DynamicConfigurationService dcs = (DynamicConfigurationService)this.testLocator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        this.addServicesFromDefault(config, excludes, locatorFiles);
        this.addServicesFromPackage(config, packages, excludes);
        for (Class<?> clazz : clazzes) {
            config.addActiveDescriptor(clazz);
        }
        config.commit();
        this.testLocator.inject((Object)this);
    }

    protected void setVerbosity(boolean verbose) {
        this.verbose = verbose;
    }

    private void addServicesFromDefault(final DynamicConfiguration config, final Set<String> excludes, final Set<String> locatorFiles) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                HK2Runner.this.internalAddServicesFromDefault(config, excludes, locatorFiles);
                return null;
            }
        });
    }

    private void readResources(Enumeration<URL> resources, Set<String> excludes, DynamicConfiguration config) {
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            try {
                InputStream urlStream = url.openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(urlStream));
                boolean goOn = true;
                while (goOn) {
                    DescriptorImpl bindMe = new DescriptorImpl();
                    goOn = bindMe.readObject(reader);
                    if (!goOn || excludes.contains(bindMe.getImplementation())) continue;
                    config.bind((Descriptor)bindMe);
                }
                reader.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private void internalAddServicesFromDefault(DynamicConfiguration config, Set<String> excludes, Set<String> locatorFiles) {
        ClassLoader loader = this.getClass().getClassLoader();
        for (String locatorFile : locatorFiles) {
            Enumeration<URL> resources;
            try {
                resources = loader.getResources(locatorFile);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return;
            }
            this.readResources(resources, excludes, config);
        }
    }

    private void addServicesFromPackage(final DynamicConfiguration config, final List<String> packages, final Set<String> excludes) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                HK2Runner.this.internalAddServicesFromPackage(config, packages, excludes);
                return null;
            }
        });
    }

    private void internalAddServicesFromPackage(DynamicConfiguration config, List<String> packages, Set<String> excludes) {
        if (packages.isEmpty()) {
            return;
        }
        String classPath = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(HK2Runner.CLASS_PATH_PROP);
            }
        });
        StringTokenizer st = new StringTokenizer(classPath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String pathElement = st.nextToken();
            this.addServicesFromPathElement(config, packages, pathElement, excludes);
        }
    }

    private void addServicesFromPathElement(DynamicConfiguration config, List<String> packages, String element, Set<String> excludes) {
        File fileElement = new File(element);
        if (!fileElement.exists()) {
            return;
        }
        if (fileElement.isDirectory()) {
            this.addServicesFromPathDirectory(config, packages, fileElement, excludes);
        } else {
            this.addServicesFromPathJar(config, packages, fileElement, excludes);
        }
    }

    private void addServicesFromPathDirectory(DynamicConfiguration config, List<String> packages, File directory, Set<String> excludes) {
        for (String pack : packages) {
            File[] candidates;
            File searchDir = new File(directory, HK2Runner.convertToFileFormat(pack));
            if (!searchDir.exists() || !searchDir.isDirectory() || (candidates = searchDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    if (name == null) {
                        return false;
                    }
                    return name.endsWith(HK2Runner.DOT_CLASS);
                }
            })) == null) continue;
            for (File candidate : candidates) {
                try {
                    FileInputStream fis = new FileInputStream(candidate);
                    this.addClassIfService(fis, excludes);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServicesFromPathJar(DynamicConfiguration config, List<String> packages, File jar, Set<String> excludes) {
        JarFile jarFile;
        try {
            jarFile = new JarFile(jar);
        }
        catch (IOException ioe) {
            return;
        }
        try {
            for (String pack : packages) {
                String packAsFile = HK2Runner.convertToFileFormat(pack);
                int packAsFileLen = packAsFile.length() + 1;
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (!entryName.startsWith(packAsFile) || entryName.substring(packAsFileLen).contains("/") || !entryName.endsWith(DOT_CLASS)) continue;
                    try {
                        this.addClassIfService(jarFile.getInputStream(entry), excludes);
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        finally {
            try {
                jarFile.close();
            }
            catch (IOException e) {}
        }
    }

    private void addClassIfService(InputStream is, Set<String> excludes) throws IOException {
        ClassReader reader = new ClassReader(is);
        ClassVisitorImpl cvi = new ClassVisitorImpl(this.testLocator, this.verbose, excludes);
        reader.accept((ClassVisitor)cvi, 7);
    }

    private static String convertToFileFormat(String clazzFormat) {
        return clazzFormat.replaceAll("\\.", "/");
    }
}

