/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.json.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.LinkedList;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.json.Json;
import javax.json.stream.JsonParser;
import javax.xml.bind.Unmarshaller;
import org.glassfish.hk2.api.Rank;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.internal.ChildDataModel;
import org.glassfish.hk2.xml.internal.ChildDescriptor;
import org.glassfish.hk2.xml.internal.ChildType;
import org.glassfish.hk2.xml.internal.ModelImpl;
import org.glassfish.hk2.xml.internal.ParentedModel;
import org.glassfish.hk2.xml.internal.Utilities;
import org.glassfish.hk2.xml.jaxb.internal.BaseHK2JAXBBean;
import org.glassfish.hk2.xml.spi.Model;
import org.glassfish.hk2.xml.spi.PreGenerationRequirement;
import org.glassfish.hk2.xml.spi.XmlServiceParser;

@Singleton
@Named(value="JsonService")
@Rank(value=-1)
public class JsonParser
implements XmlServiceParser {
    @Inject
    @Named(value="JsonService")
    private Provider<XmlService> xmlService;

    private void skipper(javax.json.stream.JsonParser parser) {
        if (!parser.hasNext()) {
            return;
        }
        while (true) {
            JsonParser.Event event = parser.next();
            switch (event) {
                case KEY_NAME: 
                case VALUE_FALSE: 
                case VALUE_TRUE: 
                case VALUE_NULL: 
                case VALUE_STRING: 
                case VALUE_NUMBER: {
                    break;
                }
                case START_OBJECT: 
                case START_ARRAY: {
                    this.skipper(parser);
                    break;
                }
                case END_OBJECT: 
                case END_ARRAY: {
                    return;
                }
            }
        }
    }

    private void parseObject(ModelImpl currentModel, BaseHK2JAXBBean target, BaseHK2JAXBBean parent, Unmarshaller.Listener listener, javax.json.stream.JsonParser parser) {
        try {
            listener.beforeUnmarshal((Object)target, (Object)parent);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
        if (!parser.hasNext()) {
            throw new IllegalStateException("Expectin an end token from Json parser");
        }
        boolean getNextEvent = true;
        do {
            JsonParser.Event event = parser.next();
            block2 : switch (event) {
                case END_OBJECT: {
                    try {
                        listener.afterUnmarshal((Object)target, (Object)parent);
                    }
                    catch (RuntimeException re) {
                        throw re;
                    }
                    catch (Throwable th) {
                        throw new RuntimeException(th);
                    }
                    getNextEvent = false;
                    break;
                }
                case KEY_NAME: {
                    String keyName = parser.getString();
                    ChildDescriptor descriptor = currentModel.getChildDescriptor(keyName);
                    if (descriptor == null) {
                        this.skipper(parser);
                        break;
                    }
                    ParentedModel parentedModel = descriptor.getParentedModel();
                    if (parentedModel == null) {
                        ChildDataModel childDataModel = descriptor.getChildDataModel();
                        JsonParser.Event attributeEvent = parser.next();
                        switch (attributeEvent) {
                            case VALUE_STRING: {
                                target._setProperty(keyName, (Object)parser.getString());
                                break block2;
                            }
                            case VALUE_NUMBER: {
                                if (parser.isIntegralNumber()) {
                                    target._setProperty(keyName, (Object)new Integer(parser.getInt()));
                                    break block2;
                                }
                                target._setProperty(keyName, (Object)new Long(parser.getLong()));
                                break block2;
                            }
                            case VALUE_NULL: {
                                target._setProperty(keyName, null);
                                break block2;
                            }
                            case VALUE_TRUE: {
                                target._setProperty(keyName, (Object)Boolean.TRUE);
                                break block2;
                            }
                            case VALUE_FALSE: {
                                target._setProperty(keyName, (Object)Boolean.FALSE);
                                break block2;
                            }
                        }
                        throw new IllegalStateException("Uknown value type: " + attributeEvent + " for " + childDataModel + " for " + currentModel);
                    }
                    ModelImpl childModel = parentedModel.getChildModel();
                    JsonParser.Event childTypeEvent = parser.next();
                    if (JsonParser.Event.START_ARRAY.equals((Object)childTypeEvent)) {
                        JsonParser.Event arrayEvent;
                        LinkedList<BaseHK2JAXBBean> myList = new LinkedList<BaseHK2JAXBBean>();
                        while (!JsonParser.Event.END_ARRAY.equals((Object)(arrayEvent = parser.next()))) {
                            if (!JsonParser.Event.START_OBJECT.equals((Object)arrayEvent)) {
                                throw new AssertionError((Object)("Do not know how to handle this case inside an array expecting an object" + arrayEvent));
                            }
                            BaseHK2JAXBBean oneChild = Utilities.createBean((Class)childModel.getProxyAsClass());
                            this.parseObject(childModel, oneChild, target, listener, parser);
                            myList.add(oneChild);
                        }
                        if (ChildType.LIST.equals((Object)parentedModel.getChildType())) {
                            target._setProperty(keyName, myList);
                            break;
                        }
                        if (ChildType.ARRAY.equals((Object)parentedModel.getChildType())) {
                            Object array = Array.newInstance(childModel.getOriginalInterfaceAsClass(), myList.size());
                            int lcv = 0;
                            for (BaseHK2JAXBBean bean : myList) {
                                Array.set(array, lcv, bean);
                                ++lcv;
                            }
                            target._setProperty(keyName, array);
                            break;
                        }
                        throw new AssertionError((Object)"The model says DIRECT but I got an ARRAY start so bombing quite badly");
                    }
                    if (JsonParser.Event.START_OBJECT.equals((Object)childTypeEvent)) {
                        if (!ChildType.DIRECT.equals((Object)parentedModel.getChildType())) {
                            throw new AssertionError((Object)("The model says " + parentedModel.getChildType() + " but I got an START_OBJECT start so bombing quite badly"));
                        }
                        BaseHK2JAXBBean oneChild = Utilities.createBean((Class)childModel.getProxyAsClass());
                        this.parseObject(childModel, oneChild, target, listener, parser);
                        target._setProperty(keyName, (Object)oneChild);
                        break;
                    }
                    throw new IllegalStateException("Unknown start of child event: " + event);
                }
                default: {
                    throw new IllegalArgumentException("Unkown event: " + event);
                }
            }
        } while (getNextEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T parseRoot(Model rootModel, URI location, Unmarshaller.Listener listener) throws Exception {
        javax.json.stream.JsonParser parser = Json.createParser((InputStream)location.toURL().openStream());
        try {
            if (!parser.hasNext()) {
                BaseHK2JAXBBean root = Utilities.createBean((Class)rootModel.getProxyAsClass());
                listener.beforeUnmarshal((Object)root, null);
                listener.afterUnmarshal((Object)root, null);
                BaseHK2JAXBBean baseHK2JAXBBean = root;
                return (T)baseHK2JAXBBean;
            }
            JsonParser.Event event = parser.next();
            if (!JsonParser.Event.START_OBJECT.equals((Object)event)) {
                throw new AssertionError((Object)("Unknown start of JSON object: " + event));
            }
            BaseHK2JAXBBean root = Utilities.createBean((Class)rootModel.getProxyAsClass());
            this.parseObject((ModelImpl)rootModel, root, null, listener, parser);
            BaseHK2JAXBBean baseHK2JAXBBean = root;
            return (T)baseHK2JAXBBean;
        }
        finally {
            parser.close();
        }
    }

    public PreGenerationRequirement getPreGenerationRequirement() {
        return PreGenerationRequirement.LAZY_PREGENERATION;
    }

    public <T> void marshal(OutputStream outputStream, XmlRootHandle<T> root) throws IOException {
        throw new AssertionError((Object)"marshal not yet implemented");
    }
}

