/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.generator.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jvnet.hk2.generator.HabitatGenerator;

public abstract class AbstractInhabitantsGeneratorMojo
extends AbstractMojo {
    private static final String WAR_PACKAGING = "war";
    private static final String WEB_INF = "WEB-INF";
    private static final String CLASSES = "classes";
    private File targetDirectory;
    protected MavenProject project;
    private boolean verbose;
    private boolean includeDate;
    private String locator;
    private String supportedProjectTypes;

    protected abstract boolean getNoSwap();

    protected abstract File getOutputDirectory();

    protected boolean isWar() {
        return WAR_PACKAGING.equals(this.project.getPackaging());
    }

    public void execute() throws MojoFailureException {
        String[] argv;
        int result;
        List<String> projectTypes = Arrays.asList(this.supportedProjectTypes.split(","));
        if (!projectTypes.contains(this.project.getPackaging())) {
            if (this.verbose) {
                this.getLog().info((CharSequence)("hk2-inhabitant-generator skipping unknown packaging type " + this.project.getPackaging() + " from known packaging types " + this.supportedProjectTypes));
            }
            return;
        }
        if (!this.getOutputDirectory().exists() && !this.getOutputDirectory().mkdirs()) {
            this.getLog().info((CharSequence)("Could not create output directory " + this.getOutputDirectory().getAbsolutePath()));
            return;
        }
        if (!this.getOutputDirectory().exists()) {
            this.getLog().info((CharSequence)("Exiting hk2-inhabitant-generator because could not find output directory " + this.getOutputDirectory().getAbsolutePath()));
            return;
        }
        if (this.verbose) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("hk2-inhabitant-generator generating into location " + this.getOutputDirectory().getAbsolutePath()));
            this.getLog().info((CharSequence)"");
        }
        LinkedList<String> arguments = new LinkedList<String>();
        arguments.add("--file");
        arguments.add(this.getOutputDirectory().getAbsolutePath());
        if (this.verbose) {
            arguments.add("--verbose");
        }
        if (this.locator != null) {
            arguments.add("--locator");
            arguments.add(this.locator);
        }
        arguments.add("--searchPath");
        arguments.add(this.getBuildClasspath());
        if (this.getNoSwap()) {
            arguments.add("--noswap");
        }
        if (!this.includeDate) {
            arguments.add("--noDate");
        }
        if (this.isWar()) {
            File outDir = new File(this.targetDirectory, this.project.getBuild().getFinalName());
            outDir = new File(outDir, WEB_INF);
            outDir = new File(outDir, CLASSES);
            outDir = new File(outDir, "hk2-locator");
            arguments.add("--directory");
            arguments.add(outDir.getAbsolutePath());
        }
        if ((result = HabitatGenerator.embeddedMain(argv = arguments.toArray(new String[arguments.size()]))) != 0) {
            throw new MojoFailureException("Could not generate inhabitants file for " + this.getOutputDirectory());
        }
    }

    private String getBuildClasspath() {
        ArrayList artList;
        Iterator i;
        StringBuilder sb = new StringBuilder();
        sb.append(this.project.getBuild().getOutputDirectory());
        sb.append(File.pathSeparator);
        if (!this.getOutputDirectory().getAbsolutePath().equals(this.project.getBuild().getOutputDirectory())) {
            sb.append(this.getOutputDirectory().getAbsolutePath());
            sb.append(File.pathSeparator);
        }
        if ((i = (artList = new ArrayList(this.project.getArtifacts())).iterator()).hasNext()) {
            sb.append(((Artifact)i.next()).getFile().getPath());
            while (i.hasNext()) {
                sb.append(File.pathSeparator);
                sb.append(((Artifact)i.next()).getFile().getPath());
            }
        }
        String classpath = sb.toString();
        if (this.verbose) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"-- Classpath --");
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)classpath);
            this.getLog().info((CharSequence)"");
        }
        return classpath;
    }
}

