/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.generator.internal;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.TreeSet;
import org.glassfish.hk2.utilities.DescriptorImpl;
import org.jvnet.hk2.generator.InFlightGenerator;
import org.jvnet.hk2.generator.internal.DescriptorComparitor;
import org.jvnet.hk2.generator.internal.Utilities;

public class InFlightGeneratorImpl
implements InFlightGenerator {
    @Override
    public void generateFromMultipleDirectories(List<File> directories, List<File> searchPath, boolean verbose, OutputStream inhabitantFile) throws IOException {
        Utilities utilities = new Utilities(verbose, searchPath);
        TreeSet<DescriptorImpl> retVal = new TreeSet<DescriptorImpl>(new DescriptorComparitor());
        for (File directory : directories) {
            if (!directory.exists()) continue;
            if (!directory.isDirectory()) {
                throw new IllegalArgumentException(directory.getAbsolutePath() + " is not a directory");
            }
            List<DescriptorImpl> newOnes = utilities.findAllServicesFromDirectory(directory, directories);
            if (newOnes == null) continue;
            retVal.addAll(newOnes);
        }
        utilities.close();
        if (retVal.isEmpty()) {
            return;
        }
        PrintWriter writer = new PrintWriter(inhabitantFile);
        for (DescriptorImpl di : retVal) {
            di.writeObject(writer);
        }
        writer.flush();
    }
}

