/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.generator.internal;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.glassfish.hk2.utilities.DescriptorImpl;

public class DescriptorComparitor
implements Comparator<DescriptorImpl> {
    private static <T> int safeCompare(Comparable<T> a, T b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    private static int compareStringMaps(Set<String> s1, Set<String> s2) {
        int size2;
        int size1 = s1.size();
        if (size1 != (size2 = s2.size())) {
            return size1 - size2;
        }
        TreeSet<String> s1sorted = new TreeSet<String>(s1);
        TreeSet<String> s2sorted = new TreeSet<String>(s2);
        StringBuffer s1b = new StringBuffer();
        for (String s1sv : s1sorted) {
            s1b.append(s1sv);
        }
        StringBuffer s2b = new StringBuffer();
        for (String s2sv : s2sorted) {
            s2b.append(s2sv);
        }
        return DescriptorComparitor.safeCompare(s1b.toString(), s2b.toString());
    }

    @Override
    public int compare(DescriptorImpl o1, DescriptorImpl o2) {
        int retVal = o2.getRanking() - o1.getRanking();
        if (retVal != 0) {
            return retVal;
        }
        retVal = DescriptorComparitor.safeCompare(o1.getImplementation(), o2.getImplementation());
        if (retVal != 0) {
            return retVal;
        }
        retVal = DescriptorComparitor.safeCompare(o1.getName(), o2.getName());
        if (retVal != 0) {
            return retVal;
        }
        retVal = DescriptorComparitor.safeCompare(o1.getScope(), o2.getScope());
        if (retVal != 0) {
            return retVal;
        }
        retVal = DescriptorComparitor.compareStringMaps(o1.getAdvertisedContracts(), o2.getAdvertisedContracts());
        if (retVal != 0) {
            return retVal;
        }
        retVal = DescriptorComparitor.compareStringMaps(o1.getQualifiers(), o2.getQualifiers());
        if (retVal != 0) {
            return retVal;
        }
        retVal = o1.getDescriptorType().compareTo((Enum)o2.getDescriptorType());
        if (retVal != 0) {
            return retVal;
        }
        retVal = o1.getDescriptorVisibility().compareTo((Enum)o2.getDescriptorVisibility());
        if (retVal != 0) {
            return retVal;
        }
        return 0;
    }
}

