/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.generator.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.glassfish.hk2.utilities.DescriptorImpl;
import org.jvnet.hk2.generator.internal.DescriptorComparitor;
import org.jvnet.hk2.generator.internal.Utilities;

public class GeneratorRunner {
    private static final String DOT_CLASS = ".class";
    private static final String META_INF = "META-INF";
    private static final String INHABITANTS = "hk2-locator";
    private static final String TARGET_HABITATS = "target-habitats";
    private final Utilities utilities;
    private final String fileOrDirectory;
    private final String outjarName;
    private final String locatorName;
    private final boolean verbose;
    private final boolean noSwap;
    private final String outputDirectory;
    private final boolean includeDate;
    private final boolean outJarIsInJar;

    public GeneratorRunner(String fileOrDirectory, String outjarName, String locatorName, boolean verbose, String searchPath, boolean noSwap, String outputDirectory, boolean includeDate) {
        this.fileOrDirectory = fileOrDirectory;
        this.outjarName = outjarName;
        this.locatorName = locatorName;
        this.verbose = verbose;
        this.noSwap = noSwap;
        this.outputDirectory = outputDirectory;
        this.utilities = new Utilities(verbose, searchPath);
        this.includeDate = includeDate;
        this.outJarIsInJar = fileOrDirectory.equals(outjarName);
        if (verbose) {
            System.out.println("HabitatGenerator: inputFile=" + fileOrDirectory + " outjarName=" + outjarName + " locatorName=" + locatorName + " noSwap=" + noSwap + " outputDirectory=" + outputDirectory);
        }
    }

    public void go() throws AssertionError, IOException {
        File toInspect = new File(this.fileOrDirectory);
        if (!toInspect.exists()) {
            throw new AssertionError((Object)("Could not find file: " + toInspect.getAbsolutePath()));
        }
        if (toInspect.isDirectory()) {
            List<DescriptorImpl> allDescriptors = this.utilities.findAllServicesFromDirectory(toInspect, Collections.singletonList(toInspect));
            if (allDescriptors.isEmpty()) {
                return;
            }
            this.writeToDirectory(allDescriptors);
        } else {
            List<DescriptorImpl> allDescriptors = this.findAllServicesFromJar(toInspect);
            this.utilities.close();
            if (this.noSwap && this.outJarIsInJar) {
                this.writeToJarNoSwap(toInspect, allDescriptors);
            } else {
                this.writeToJar(toInspect, allDescriptors);
            }
        }
        this.utilities.close();
    }

    private void writeToDirectory(List<DescriptorImpl> allDescriptors) throws IOException {
        HashMap targetHabitatMap = new HashMap();
        targetHabitatMap.put(this.locatorName, new ArrayList());
        for (DescriptorImpl descriptorImpl : allDescriptors) {
            List habitats = (List)descriptorImpl.getMetadata().get(TARGET_HABITATS);
            if (habitats != null) {
                StringTokenizer tokenizer = new StringTokenizer((String)habitats.get(0), ";");
                while (tokenizer.hasMoreTokens()) {
                    String habitatName = tokenizer.nextToken();
                    ArrayList<DescriptorImpl> descriptorsForHabitat = (ArrayList<DescriptorImpl>)targetHabitatMap.get(habitatName);
                    if (descriptorsForHabitat == null) {
                        descriptorsForHabitat = new ArrayList<DescriptorImpl>();
                        targetHabitatMap.put(habitatName, descriptorsForHabitat);
                    }
                    descriptorsForHabitat.add(descriptorImpl);
                    System.out.println(descriptorImpl.getName() + " Will be an inhabitant of ==> " + habitatName);
                }
                continue;
            }
            List descriptorsForHabitat = (List)targetHabitatMap.get(this.locatorName);
            descriptorsForHabitat.add(descriptorImpl);
        }
        for (Map.Entry entry : targetHabitatMap.entrySet()) {
            String targetHabitatName = (String)entry.getKey();
            List descriptors = (List)entry.getValue();
            if (descriptors.size() == 0) continue;
            File inhabitantsDir = new File(this.outputDirectory);
            File outputFile = new File(inhabitantsDir, targetHabitatName);
            if (!inhabitantsDir.exists() && !inhabitantsDir.mkdirs()) {
                throw new IOException("Could not create directory " + inhabitantsDir.getAbsolutePath());
            }
            File noSwapFile = null;
            boolean directWrite = false;
            if (this.noSwap || !outputFile.exists()) {
                directWrite = true;
                if (outputFile.exists() && !outputFile.delete()) {
                    throw new IOException("Could not delete existing inhabitant file " + outputFile.getAbsolutePath() + " in the noSwap case");
                }
                noSwapFile = outputFile;
            }
            File writeMeFile = this.writeInhabitantsFile(descriptors, noSwapFile, inhabitantsDir);
            if (directWrite) continue;
            if (outputFile.exists() && !outputFile.delete()) {
                throw new IOException("Could not delete existing inhabitant file " + outputFile.getAbsolutePath());
            }
            String tmpFileAbsolutePath = writeMeFile.getAbsolutePath();
            if (this.verbose) {
                System.out.println("Swapping " + tmpFileAbsolutePath + " to " + outputFile.getAbsolutePath());
            }
            if (writeMeFile.renameTo(outputFile)) continue;
            throw new IOException("Could not move generated inhabitant file " + tmpFileAbsolutePath + " to " + outputFile.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToJar(File jarFile, List<DescriptorImpl> descriptors) throws IOException {
        File tmpJarFile;
        File outjar;
        block13: {
            outjar = new File(this.outjarName);
            File writeMeFile = this.writeInhabitantsFile(descriptors, null, outjar.getParentFile());
            writeMeFile.deleteOnExit();
            byte[] buffer = new byte[1024];
            tmpJarFile = File.createTempFile(jarFile.getName(), ".tmp", outjar.getParentFile());
            FileInputStream fis = new FileInputStream(jarFile);
            ZipInputStream zis = new ZipInputStream(fis);
            FileOutputStream fos = null;
            ZipOutputStream zos = null;
            try {
                int len;
                fos = new FileOutputStream(tmpJarFile);
                zos = new ZipOutputStream(fos);
                ZipEntry zentry = zis.getNextEntry();
                while (zentry != null) {
                    String entryName = zentry.getName();
                    if (entryName.equals("META-INF/hk2-locator/" + this.locatorName)) {
                        zentry = zis.getNextEntry();
                        continue;
                    }
                    zos.putNextEntry(new ZipEntry(entryName));
                    while ((len = zis.read(buffer)) > 0) {
                        zos.write(buffer, 0, len);
                    }
                    zentry = zis.getNextEntry();
                }
                if (descriptors.isEmpty()) break block13;
                zos.putNextEntry(new ZipEntry("META-INF/hk2-locator/" + this.locatorName));
                FileInputStream desc_os = new FileInputStream(writeMeFile);
                try {
                    while ((len = desc_os.read(buffer)) > 0) {
                        zos.write(buffer, 0, len);
                    }
                }
                finally {
                    desc_os.close();
                }
            }
            finally {
                zis.close();
                if (zos != null) {
                    zos.close();
                }
            }
        }
        String tmpFileName = tmpJarFile.getAbsolutePath();
        if (this.verbose) {
            System.out.println("Swapping jar file " + tmpFileName + " to " + outjar.getAbsolutePath());
        }
        if (!tmpJarFile.renameTo(outjar)) {
            throw new IOException("Unable to swap generated JAR file " + tmpFileName + " to " + outjar.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToJarNoSwap(File jarFile, List<DescriptorImpl> descriptors) throws IOException {
        if (descriptors.isEmpty()) {
            return;
        }
        URI jarURI = URI.create("jar:" + jarFile.toURI());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter bWriter = new PrintWriter(baos);
        this.writeHeader(bWriter);
        for (DescriptorImpl desc : descriptors) {
            desc.writeObject(bWriter);
        }
        bWriter.close();
        baos.close();
        byte[] data = baos.toByteArray();
        OutputStream os = null;
        PrintWriter writer = null;
        ByteArrayInputStream bais = null;
        FileSystem fileSystem = FileSystems.newFileSystem(jarURI, new HashMap());
        try {
            Path locatorDirectory = fileSystem.getPath("/META-INF", INHABITANTS);
            Files.createDirectories(locatorDirectory, new FileAttribute[0]);
            Path locatorPath = fileSystem.getPath("/META-INF", INHABITANTS, this.locatorName);
            bais = new ByteArrayInputStream(data);
            Files.copy(bais, locatorPath, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            if (bais != null) {
                bais.close();
            }
            if (writer != null) {
                writer.close();
            }
            if (os != null) {
                os.close();
            }
            fileSystem.close();
        }
    }

    private File writeInhabitantsFile(List<DescriptorImpl> descriptors, File noSwapFile, File outDir) throws IOException {
        File outFile = noSwapFile != null ? noSwapFile : File.createTempFile(this.locatorName, ".tmp", outDir);
        if (this.verbose) {
            System.out.println("Writing " + descriptors.size() + " entries to file " + outFile.getAbsolutePath());
        }
        FileOutputStream fos = new FileOutputStream(outFile);
        PrintWriter pw = new PrintWriter(fos);
        this.writeHeader(pw);
        for (DescriptorImpl di : descriptors) {
            di.writeObject(pw);
        }
        pw.close();
        fos.close();
        if (this.verbose) {
            System.out.println("Wrote " + descriptors.size() + " entries to inhabitant file " + outFile.getAbsolutePath());
        }
        return outFile;
    }

    private void writeHeader(PrintWriter writer) {
        writer.println("#");
        if (this.includeDate) {
            writer.println("# Generated on " + new Date() + " by hk2-inhabitant-generator");
        } else {
            writer.println("# Generated by hk2-inhabitant-generator");
        }
        writer.println("#");
        writer.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DescriptorImpl> findAllServicesFromJar(File jar) throws IOException {
        TreeSet<DescriptorImpl> retVal = new TreeSet<DescriptorImpl>(new DescriptorComparitor());
        JarFile jarFile = new JarFile(jar);
        try {
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith(DOT_CLASS)) continue;
                InputStream is = null;
                try {
                    is = jarFile.getInputStream(entry);
                    List<DescriptorImpl> dis = this.utilities.createDescriptorIfService(is, Collections.singletonList(jar));
                    retVal.addAll(dis);
                }
                finally {
                    if (is == null) continue;
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        finally {
            jarFile.close();
        }
        return new ArrayList<DescriptorImpl>(retVal);
    }
}

