/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.generator.internal;

import java.io.File;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.glassfish.hk2.api.DescriptorType;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.external.org.objectweb.asm.AnnotationVisitor;
import org.glassfish.hk2.external.org.objectweb.asm.MethodVisitor;
import org.glassfish.hk2.external.org.objectweb.asm.Type;
import org.glassfish.hk2.utilities.DescriptorImpl;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.jvnet.hk2.generator.internal.AbstractAnnotationVisitorImpl;
import org.jvnet.hk2.generator.internal.AbstractClassVisitorImpl;
import org.jvnet.hk2.generator.internal.AbstractMethodVisitorImpl;
import org.jvnet.hk2.generator.internal.GenerateMethodAnnotationData;
import org.jvnet.hk2.generator.internal.Utilities;

public class ClassVisitorImpl
extends AbstractClassVisitorImpl {
    private static final String SERVICE_CLASS_FORM = "Lorg/jvnet/hk2/annotations/Service;";
    private static final String CONTRACTS_PROVIDED_CLASS_FORM = "Lorg/jvnet/hk2/annotations/ContractsProvided;";
    private static final String RANK_CLASS_FORM = "Lorg/glassfish/hk2/api/Rank;";
    private static final String CONFIGURED_CLASS_FORM = "Lorg/jvnet/hk2/config/Configured;";
    private static final String DECORATE_CLASS_FORM = "Lorg/jvnet/hk2/annotations/Decorate;";
    private static final String USE_PROXY_CLASS_FORM = "Lorg/glassfish/hk2/api/UseProxy;";
    private static final String VISIBILITY_CLASS_FORM = "Lorg/glassfish/hk2/api/Visibility;";
    private static final String NAME = "name";
    private static final String METADATA = "metadata";
    private static final String VALUE = "value";
    private static final String PROVIDE = "provide";
    private static final String LOCAL = "LOCAL";
    private static final String ANALYZER = "analyzer";
    private static final String METHOD_ACTUAL = "MethodListActual";
    public static final String METHOD_NAME = "MethodName";
    public static final String PARENT_CONFIGURED = "ParentConfigured";
    private final boolean verbose;
    private final File searchHere;
    private final Utilities utilities;
    private String implName;
    private final LinkedHashSet<String> iFaces = new LinkedHashSet();
    private LinkedHashSet<String> providedContracts;
    private String scopeClass;
    private final LinkedList<String> qualifiers = new LinkedList();
    private boolean isAService = false;
    private boolean isConfigured = false;
    private NamedAnnotationVisitor baseName;
    private String metadataString = null;
    private Integer rank = null;
    private Boolean useProxy = null;
    private DescriptorVisibility visibility = DescriptorVisibility.NORMAL;
    private final Map<String, List<String>> metadata = new HashMap<String, List<String>>();
    private String classAnalyzer = "default";
    private final LinkedList<DescriptorImpl> generatedDescriptors = new LinkedList();
    private boolean isFactory = false;
    private boolean factoryMethodFound = false;
    private DecorateData decorateData;
    private final Map<String, GenerateMethodAnnotationData> classLevelGenerators = new HashMap<String, GenerateMethodAnnotationData>();
    private static final String DECORATE_TARGET_TYPE = "targetType";
    private static final String DECORATE_METHOD_NAME = "methodName";
    private static final String DECORATE_WITH = "with";

    public ClassVisitorImpl(Utilities utilities, boolean verbose, File searchHere) {
        this.utilities = utilities;
        this.verbose = verbose;
        this.searchHere = searchHere;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.implName = name.replace("/", ".");
        this.iFaces.addAll(this.utilities.getAssociatedContracts(this.searchHere, this.implName));
        if (this.iFaces.contains(Factory.class.getName())) {
            this.isFactory = true;
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (!visible) {
            return null;
        }
        if (SERVICE_CLASS_FORM.equals(desc)) {
            this.isAService = true;
            return new ServiceAnnotationVisitor();
        }
        if (CONTRACTS_PROVIDED_CLASS_FORM.equals(desc)) {
            this.providedContracts = new LinkedHashSet();
            return new ContractsProvidedAnnotationVisitor();
        }
        if (RANK_CLASS_FORM.equals(desc)) {
            return new RankAnnotationVisitor();
        }
        if (CONFIGURED_CLASS_FORM.equals(desc)) {
            this.isConfigured = true;
        }
        if (DECORATE_CLASS_FORM.equals(desc)) {
            return new DecorateAnnotationVisitor();
        }
        if (USE_PROXY_CLASS_FORM.equals(desc)) {
            return new UseProxyAnnotationVisitor();
        }
        if (VISIBILITY_CLASS_FORM.equals(desc)) {
            return new VisibilityAnnotationVisitor();
        }
        if (!desc.startsWith("L")) {
            return null;
        }
        String loadQualifierName = desc.substring(1, desc.length() - 1).replace("/", ".");
        if (this.utilities.isClassAScope(this.searchHere, loadQualifierName)) {
            if (this.scopeClass != null) {
                throw new AssertionError((Object)("A service with implementation " + this.implName + " has at least two scopes: " + this.scopeClass + " and " + loadQualifierName));
            }
            this.scopeClass = loadQualifierName;
            return new MetadataAnnotationVisitor(loadQualifierName);
        }
        if (this.utilities.isClassAQualifier(this.searchHere, loadQualifierName)) {
            this.qualifiers.add(loadQualifierName);
            if (Named.class.getName().equals(loadQualifierName)) {
                this.baseName = new NamedAnnotationVisitor(this.getDefaultName(), null);
                return this.baseName;
            }
            return new MetadataAnnotationVisitor(loadQualifierName);
        }
        GenerateMethodAnnotationData gmad = this.utilities.isClassAGenerator(this.searchHere, loadQualifierName);
        if (gmad != null) {
            gmad = new GenerateMethodAnnotationData(gmad);
            this.classLevelGenerators.put(loadQualifierName, gmad);
            if (gmad.getNameMethodName() != null) {
                GeneratedNameMethodFinderVisitor retVal = new GeneratedNameMethodFinderVisitor(gmad);
                return retVal;
            }
        }
        return null;
    }

    private String getDefaultName() {
        if (this.implName == null) {
            return "";
        }
        int index = this.implName.lastIndexOf(46);
        if (index <= 0) {
            return this.implName;
        }
        return this.implName.substring(index + 1);
    }

    @Override
    public void visitEnd() {
        if (!this.isAService) {
            String with;
            GenerateMethodAnnotationData gbad;
            if (this.decorateData != null && (gbad = this.classLevelGenerators.get(with = this.decorateData.getWith())) != null) {
                DescriptorImpl descriptorImpl = new DescriptorImpl();
                descriptorImpl.setImplementation(gbad.getImplementation());
                for (String contract : gbad.getContracts()) {
                    descriptorImpl.addAdvertisedContract(contract);
                }
                if (gbad.getName() != null) {
                    descriptorImpl.setName(gbad.getName());
                }
                descriptorImpl.addMetadata(METHOD_ACTUAL, this.implName);
                descriptorImpl.addMetadata(METHOD_NAME, this.decorateData.getMethodName());
                descriptorImpl.addMetadata(PARENT_CONFIGURED, this.decorateData.getTargetType());
                if (this.verbose) {
                    System.out.println("Generated Descriptor for class-level GenerateServiceFromMethod annotation: " + descriptorImpl);
                }
                this.generatedDescriptors.add(descriptorImpl);
                return;
            }
            if (this.verbose) {
                System.out.println("Class " + this.implName + " is not annotated with @Service");
            }
            return;
        }
        DescriptorImpl generatedDescriptor = new DescriptorImpl();
        generatedDescriptor.setImplementation(this.implName);
        if (this.scopeClass == null) {
            generatedDescriptor.setScope(Singleton.class.getName());
        } else {
            generatedDescriptor.setScope(this.scopeClass);
        }
        if (this.providedContracts != null) {
            for (String string : this.providedContracts) {
                generatedDescriptor.addAdvertisedContract(string);
            }
        } else {
            generatedDescriptor.addAdvertisedContract(this.implName);
            for (String string : this.iFaces) {
                generatedDescriptor.addAdvertisedContract(string);
            }
        }
        for (String string : this.qualifiers) {
            generatedDescriptor.addQualifier(string);
        }
        if (this.baseName != null) {
            generatedDescriptor.setName(this.baseName.getName());
        }
        generatedDescriptor.setClassAnalysisName(this.classAnalyzer);
        if (this.metadataString != null) {
            HashMap serviceMetadata = new HashMap();
            ReflectionHelper.parseServiceMetadataString((String)this.metadataString, serviceMetadata);
            generatedDescriptor.addMetadata(serviceMetadata);
        }
        if (this.rank != null) {
            generatedDescriptor.setRanking(this.rank.intValue());
        }
        if (this.useProxy != null) {
            generatedDescriptor.setProxiable(this.useProxy);
        }
        generatedDescriptor.setDescriptorVisibility(this.visibility);
        if (!this.metadata.isEmpty()) {
            for (Map.Entry entry : this.metadata.entrySet()) {
                String key = (String)entry.getKey();
                List values = (List)entry.getValue();
                for (String value : values) {
                    generatedDescriptor.addMetadata(key, value);
                }
            }
        }
        if (this.verbose) {
            System.out.println("Generated Descriptor: " + generatedDescriptor);
        }
        this.generatedDescriptors.add(generatedDescriptor);
    }

    private MethodVisitor visitConfiguredMethod(int access, String name, String desc, String signature, String[] exceptions) {
        String methodListActual = Utilities.getListActualType(signature);
        if (methodListActual == null) {
            if (signature != null) {
                return null;
            }
            methodListActual = Utilities.getFirstParameterType(desc);
            if (methodListActual == null) {
                return null;
            }
        }
        return new ConfiguredMethodVisitor(name, methodListActual, this.implName);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.isConfigured) {
            return this.visitConfiguredMethod(access, name, desc, signature, exceptions);
        }
        if (!this.isAService) {
            return null;
        }
        if (!this.isFactory) {
            return null;
        }
        if (!PROVIDE.equals(name)) {
            return null;
        }
        if (!desc.startsWith("()")) {
            return null;
        }
        if (this.factoryMethodFound) {
            return null;
        }
        this.factoryMethodFound = true;
        DescriptorImpl asAFactory = new DescriptorImpl();
        this.generatedDescriptors.add(asAFactory);
        asAFactory.setImplementation(this.implName);
        asAFactory.setDescriptorType(DescriptorType.PROVIDE_METHOD);
        String factoryType = desc.substring(2);
        if (factoryType.charAt(0) == '[') {
            asAFactory.addAdvertisedContract(factoryType);
        } else {
            if (factoryType.charAt(0) != 'L') {
                throw new AssertionError((Object)("Unable to handle provide descriptor " + desc));
            }
            int endIndex = factoryType.indexOf(59);
            if (endIndex < 0) {
                throw new AssertionError((Object)("Unable to find end of class return type in descriptor " + desc));
            }
            String trueFactoryClass = factoryType.substring(1, endIndex);
            trueFactoryClass = trueFactoryClass.replace('/', '.');
            Set<String> associatedContracts = this.utilities.getAssociatedContracts(this.searchHere, trueFactoryClass);
            for (String contract : associatedContracts) {
                asAFactory.addAdvertisedContract(contract);
            }
        }
        return new MethodVisitorImpl(asAFactory);
    }

    public List<DescriptorImpl> getGeneratedDescriptor() {
        return this.generatedDescriptors;
    }

    private static class DecorateData {
        private final String targetType;
        private final String methodName;
        private final String with;

        private DecorateData(String targetType, String methodName, String with) {
            this.targetType = targetType;
            this.methodName = methodName;
            this.with = with;
        }

        private String getTargetType() {
            return this.targetType;
        }

        private String getMethodName() {
            return this.methodName;
        }

        private String getWith() {
            return this.with;
        }

        public String toString() {
            return "DecorateData(" + this.targetType + "," + this.methodName + "," + this.with + "," + System.identityHashCode(this) + ")";
        }
    }

    private static class MethodVisibilityAnnotationVisitor
    extends AbstractAnnotationVisitorImpl {
        private final DescriptorImpl desc;

        private MethodVisibilityAnnotationVisitor(DescriptorImpl desc) {
            this.desc = desc;
        }

        @Override
        public void visitEnum(String name, String v0, String v1) {
            if (v1 != null && ClassVisitorImpl.LOCAL.equals(v1)) {
                this.desc.setDescriptorVisibility(DescriptorVisibility.LOCAL);
            }
        }
    }

    private static class MethodUseProxyAnnotationVisitor
    extends AbstractAnnotationVisitorImpl {
        private final DescriptorImpl desc;

        private MethodUseProxyAnnotationVisitor(DescriptorImpl desc) {
            this.desc = desc;
        }

        @Override
        public void visit(String name, Object value) {
            this.desc.setProxiable((Boolean)value);
        }

        @Override
        public void visitEnd() {
            if (this.desc.isProxiable() == null) {
                this.desc.setProxiable(Boolean.TRUE);
            }
        }
    }

    private class VisibilityAnnotationVisitor
    extends AbstractAnnotationVisitorImpl {
        private VisibilityAnnotationVisitor() {
        }

        @Override
        public void visitEnum(String name, String v0, String v1) {
            if (v1 != null && ClassVisitorImpl.LOCAL.equals(v1)) {
                ClassVisitorImpl.this.visibility = DescriptorVisibility.LOCAL;
            }
        }
    }

    private class UseProxyAnnotationVisitor
    extends AbstractAnnotationVisitorImpl {
        private UseProxyAnnotationVisitor() {
        }

        @Override
        public void visit(String name, Object value) {
            ClassVisitorImpl.this.useProxy = (Boolean)value;
        }

        @Override
        public void visitEnd() {
            if (ClassVisitorImpl.this.useProxy == null) {
                ClassVisitorImpl.this.useProxy = Boolean.TRUE;
            }
        }
    }

    private class DecorateAnnotationVisitor
    extends AbstractAnnotationVisitorImpl {
        private String targetType;
        private String methodName;
        private String with;

        private DecorateAnnotationVisitor() {
        }

        @Override
        public void visit(String name, Object value) {
            if (ClassVisitorImpl.DECORATE_TARGET_TYPE.equals(name)) {
                Type t = (Type)value;
                this.targetType = t.getClassName();
            } else if (ClassVisitorImpl.DECORATE_METHOD_NAME.equals(name)) {
                this.methodName = (String)value;
            } else if (ClassVisitorImpl.DECORATE_WITH.equals(name)) {
                Type t = (Type)value;
                this.with = t.getClassName();
            }
        }

        @Override
        public void visitEnd() {
            ClassVisitorImpl.this.decorateData = new DecorateData(this.targetType, this.methodName, this.with);
        }
    }

    private static class GeneratedNameMethodFinderVisitor
    extends AbstractAnnotationVisitorImpl {
        private final GenerateMethodAnnotationData annoData;

        private GeneratedNameMethodFinderVisitor(GenerateMethodAnnotationData annoData) {
            this.annoData = annoData;
        }

        @Override
        public void visit(String name, Object value) {
            if (name == null || value == null) {
                return;
            }
            if (this.annoData.getNameMethodName().equals(name)) {
                if (!(value instanceof String)) {
                    return;
                }
                this.annoData.setName((String)value);
            }
        }
    }

    private class ConfiguredMethodVisitor
    extends AbstractMethodVisitorImpl {
        private final String methodName;
        private final String actualType;
        private final String parentConfigured;
        private final List<GenerateMethodAnnotationData> allAnnotationDataToAdd = new LinkedList<GenerateMethodAnnotationData>();

        private ConfiguredMethodVisitor(String methodName, String actualType, String parentConfigured) {
            this.methodName = methodName;
            this.actualType = actualType;
            this.parentConfigured = parentConfigured;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            String loadAnnotationName = desc.substring(1, desc.length() - 1).replace("/", ".");
            GenerateMethodAnnotationData generateData = ClassVisitorImpl.this.utilities.isClassAGenerator(ClassVisitorImpl.this.searchHere, loadAnnotationName);
            if (generateData == null) {
                return null;
            }
            this.allAnnotationDataToAdd.add(generateData);
            if (generateData.getNameMethodName() == null) {
                return null;
            }
            return new GeneratedNameMethodFinderVisitor(generateData);
        }

        @Override
        public void visitEnd() {
            for (GenerateMethodAnnotationData methodGenerated : this.allAnnotationDataToAdd) {
                DescriptorImpl di = new DescriptorImpl();
                di.setImplementation(methodGenerated.getImplementation());
                for (String contract : methodGenerated.getContracts()) {
                    di.addAdvertisedContract(contract);
                }
                di.setScope(methodGenerated.getScope());
                if (methodGenerated.getName() != null) {
                    di.setName(methodGenerated.getName());
                }
                di.addMetadata(ClassVisitorImpl.METHOD_ACTUAL, this.actualType);
                di.addMetadata(ClassVisitorImpl.METHOD_NAME, this.methodName);
                di.addMetadata(ClassVisitorImpl.PARENT_CONFIGURED, this.parentConfigured);
                if (ClassVisitorImpl.this.verbose) {
                    System.out.println("Generated Descriptor for GenerateServiceFromMethod annotation: " + di);
                }
                ClassVisitorImpl.this.generatedDescriptors.add(di);
            }
        }
    }

    private class MetadataAnnotationVisitor
    extends AbstractAnnotationVisitorImpl {
        private final String scopeOrQualifierName;
        private final String arrayName;

        private MetadataAnnotationVisitor(String scopeOrQualifierName) {
            this(scopeOrQualifierName, (String)null);
        }

        private MetadataAnnotationVisitor(String scopeOrQualifierName, String arrayName) {
            this.scopeOrQualifierName = scopeOrQualifierName;
            this.arrayName = arrayName;
        }

        @Override
        public void visit(String name, Object value) {
            String metadataKey;
            if (name == null) {
                name = this.arrayName;
            }
            if ((metadataKey = ClassVisitorImpl.this.utilities.getMetadataKey(this.scopeOrQualifierName, name)) != null) {
                String valueString;
                if (value instanceof Type) {
                    Type type = (Type)value;
                    valueString = type.getClassName();
                } else {
                    String valueClassName = value.getClass().getName();
                    if (valueClassName.startsWith("[")) {
                        int length = Array.getLength(value);
                        for (int lcv = 0; lcv < length; ++lcv) {
                            Object member = Array.get(value, lcv);
                            ReflectionHelper.addMetadata((Map)ClassVisitorImpl.this.metadata, (String)metadataKey, (String)member.toString());
                        }
                        return;
                    }
                    valueString = value.toString();
                }
                ReflectionHelper.addMetadata((Map)ClassVisitorImpl.this.metadata, (String)metadataKey, (String)valueString);
            }
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            return new MetadataAnnotationVisitor(this.scopeOrQualifierName, name);
        }
    }

    private static class MethodRankAnnotationVisitor
    extends AbstractAnnotationVisitorImpl {
        private final DescriptorImpl di;

        private MethodRankAnnotationVisitor(DescriptorImpl di) {
            this.di = di;
        }

        @Override
        public void visit(String name, Object value) {
            this.di.setRanking(((Integer)value).intValue());
        }
    }

    private class RankAnnotationVisitor
    extends AbstractAnnotationVisitorImpl {
        private RankAnnotationVisitor() {
        }

        @Override
        public void visit(String name, Object value) {
            ClassVisitorImpl.this.rank = (Integer)value;
        }
    }

    private class ContractsProvidedAnnotationVisitor
    extends AbstractAnnotationVisitorImpl {
        private ContractsProvidedAnnotationVisitor() {
        }

        @Override
        public void visit(String name, Object value) {
            if (value == null) {
                return;
            }
            if (!(value instanceof Type)) {
                return;
            }
            ClassVisitorImpl.this.providedContracts.add(((Type)value).getClassName());
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            if (!ClassVisitorImpl.VALUE.equals(name)) {
                return null;
            }
            return this;
        }
    }

    private class MethodVisitorImpl
    extends AbstractMethodVisitorImpl {
        private final DescriptorImpl asAFactoryDI;
        private NamedAnnotationVisitor factoryName;

        private MethodVisitorImpl(DescriptorImpl asAFactoryDI) {
            this.asAFactoryDI = asAFactoryDI;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (!desc.startsWith("L")) {
                return null;
            }
            String loadQualifierName = desc.substring(1, desc.length() - 1).replace("/", ".");
            if (ClassVisitorImpl.this.utilities.isClassAScope(ClassVisitorImpl.this.searchHere, loadQualifierName)) {
                this.asAFactoryDI.setScope(loadQualifierName);
            } else if (ClassVisitorImpl.this.utilities.isClassAQualifier(ClassVisitorImpl.this.searchHere, loadQualifierName)) {
                this.asAFactoryDI.addQualifier(loadQualifierName);
                if (Named.class.getName().equals(loadQualifierName)) {
                    this.factoryName = new NamedAnnotationVisitor(ClassVisitorImpl.this.getDefaultName(), null);
                    return this.factoryName;
                }
            } else {
                if (desc.equals(ClassVisitorImpl.RANK_CLASS_FORM)) {
                    return new MethodRankAnnotationVisitor(this.asAFactoryDI);
                }
                if (desc.equals(ClassVisitorImpl.USE_PROXY_CLASS_FORM)) {
                    return new MethodUseProxyAnnotationVisitor(this.asAFactoryDI);
                }
                if (desc.equals(ClassVisitorImpl.VISIBILITY_CLASS_FORM)) {
                    return new MethodVisibilityAnnotationVisitor(this.asAFactoryDI);
                }
            }
            return null;
        }

        @Override
        public void visitEnd() {
            if (this.factoryName != null && this.factoryName.getName() != null) {
                this.asAFactoryDI.setName(this.factoryName.getName());
            }
            if (ClassVisitorImpl.this.verbose) {
                System.out.println("Adding a factory descriptor: " + this.asAFactoryDI);
            }
        }
    }

    private static class NamedAnnotationVisitor
    extends AbstractAnnotationVisitorImpl {
        private final String defaultName;
        private boolean nameSet = false;
        private String name;

        public NamedAnnotationVisitor(String defaultName, String name) {
            this.defaultName = defaultName;
            this.name = name;
        }

        @Override
        public void visit(String annotationName, Object value) {
            if (annotationName.equals(ClassVisitorImpl.VALUE)) {
                this.name = (String)value;
                this.nameSet = true;
            }
        }

        @Override
        public void visitEnd() {
            if (this.nameSet) {
                return;
            }
            this.name = this.defaultName;
        }

        private String getName() {
            return this.name;
        }
    }

    private class ServiceAnnotationVisitor
    extends AbstractAnnotationVisitorImpl {
        private ServiceAnnotationVisitor() {
        }

        @Override
        public void visit(String annotationName, Object value) {
            if (annotationName.equals(ClassVisitorImpl.NAME)) {
                ClassVisitorImpl.this.baseName = new NamedAnnotationVisitor(null, (String)value);
            } else if (annotationName.equals(ClassVisitorImpl.METADATA)) {
                ClassVisitorImpl.this.metadataString = (String)value;
            } else if (annotationName.equals(ClassVisitorImpl.ANALYZER)) {
                ClassVisitorImpl.this.classAnalyzer = (String)value;
            }
        }
    }
}

