/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.generator;

import java.io.File;
import java.io.IOException;
import org.jvnet.hk2.generator.internal.GeneratorRunner;

public class HabitatGenerator {
    private static final String CLASS_PATH_PROP = "java.class.path";
    private static final String CLASSPATH = System.getProperty("java.class.path");
    public static final String FILE_ARG = "--file";
    public static final String LOCATOR_ARG = "--locator";
    public static final String VERBOSE_ARG = "--verbose";
    public static final String OUTJAR_ARG = "--outjar";
    public static final String SEARCHPATH_ARG = "--searchPath";
    public static final String NOSWAP_ARG = "--noswap";
    public static final String DIRECTORY_ARG = "--directory";
    private final String directoryOrFileToGenerateFor;
    private final String outjarName;
    private final String locatorName;
    private final boolean verbose;
    private final String searchPath;
    private final boolean noSwap;
    private final String outputDirectory;
    private static final String LOCATOR_DEFAULT = "default";
    private static final String META_INF = "META-INF";
    public static final String HK2_LOCATOR = "hk2-locator";

    private HabitatGenerator(String directoryOrFileToGenerateFor, String outjarName, String locatorName, boolean verbose, String searchPath, boolean noSwap, String outputDirectory) {
        this.directoryOrFileToGenerateFor = directoryOrFileToGenerateFor;
        this.outjarName = outjarName;
        this.locatorName = locatorName;
        this.verbose = verbose;
        this.searchPath = searchPath;
        this.noSwap = noSwap;
        this.outputDirectory = outputDirectory;
    }

    private void printThrowable(Throwable th) {
        int lcv = 0;
        while (th != null) {
            System.out.println("Exception level " + lcv++ + " message is \"" + th.getMessage() + "\"");
            th.printStackTrace();
            th = th.getCause();
        }
    }

    private int go() {
        GeneratorRunner runner = new GeneratorRunner(this.directoryOrFileToGenerateFor, this.outjarName, this.locatorName, this.verbose, this.searchPath, this.noSwap, this.outputDirectory);
        try {
            runner.go();
        }
        catch (AssertionError ae) {
            if (this.verbose) {
                this.printThrowable((Throwable)((Object)ae));
            } else {
                System.out.println(((Throwable)((Object)ae)).getMessage());
            }
            return 1;
        }
        catch (IOException io) {
            if (this.verbose) {
                this.printThrowable(io);
            } else {
                System.out.println(io.getMessage());
            }
            return 2;
        }
        return 0;
    }

    private static void usage() {
        System.out.println("java org.jvnet.hk2.generator.HabitatGenerator\n\t[--file jarFileOrDirectory]\n\t[--searchPath path-separator-delimited-classpath]\n\t[--outjar jarFile]\n\t[--locator locatorName]\n\t[--verbose]");
    }

    public static int embeddedMain(String[] argv) {
        File defaultFileAsFile;
        String defaultFileToHandle = null;
        String defaultLocatorName = LOCATOR_DEFAULT;
        boolean defaultVerbose = false;
        String outjarFile = null;
        String searchPath = CLASSPATH;
        boolean userNoSwap = false;
        String outputDirectory = null;
        for (int lcv = 0; lcv < argv.length; ++lcv) {
            if (VERBOSE_ARG.equals(argv[lcv])) {
                defaultVerbose = true;
                continue;
            }
            if (FILE_ARG.equals(argv[lcv])) {
                if (++lcv >= argv.length) {
                    HabitatGenerator.usage();
                    return 3;
                }
                defaultFileToHandle = argv[lcv];
                continue;
            }
            if (LOCATOR_ARG.equals(argv[lcv])) {
                if (++lcv >= argv.length) {
                    HabitatGenerator.usage();
                    return 4;
                }
                defaultLocatorName = argv[lcv];
                continue;
            }
            if (OUTJAR_ARG.equals(argv[lcv])) {
                if (++lcv >= argv.length) {
                    HabitatGenerator.usage();
                    return 5;
                }
                outjarFile = argv[lcv];
                continue;
            }
            if (SEARCHPATH_ARG.equals(argv[lcv])) {
                if (++lcv >= argv.length) {
                    HabitatGenerator.usage();
                    return 5;
                }
                searchPath = argv[lcv];
                continue;
            }
            if (NOSWAP_ARG.equals(argv[lcv])) {
                userNoSwap = true;
                continue;
            }
            if (DIRECTORY_ARG.equals(argv[lcv])) {
                if (++lcv >= argv.length) {
                    HabitatGenerator.usage();
                    return 5;
                }
                outputDirectory = argv[lcv];
                continue;
            }
            System.err.println("Uknown argument: " + argv[lcv]);
        }
        if (defaultFileToHandle == null) {
            String cp = CLASSPATH;
            int pathSep = cp.indexOf(File.pathSeparator);
            String firstInLine = pathSep < 0 ? cp : cp.substring(0, pathSep);
            defaultFileToHandle = firstInLine;
        }
        if (outjarFile == null) {
            outjarFile = defaultFileToHandle;
        }
        if (outputDirectory == null && (!(defaultFileAsFile = new File(defaultFileToHandle)).exists() || defaultFileAsFile.isDirectory())) {
            File defaultDirectoryAsFile = new File(defaultFileAsFile, META_INF);
            defaultDirectoryAsFile = new File(defaultDirectoryAsFile, HK2_LOCATOR);
            outputDirectory = defaultDirectoryAsFile.getAbsolutePath();
        }
        HabitatGenerator hg = new HabitatGenerator(defaultFileToHandle, outjarFile, defaultLocatorName, defaultVerbose, searchPath, userNoSwap, outputDirectory);
        return hg.go();
    }

    public static void main(String[] argv) {
        try {
            System.exit(HabitatGenerator.embeddedMain(argv));
        }
        catch (Throwable th) {
            System.exit(-1);
        }
    }
}

