/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.generator.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.jvnet.hk2.generator.HabitatGenerator;

public class MavenInhabitantsGenerator
extends AbstractMojo {
    private String outputDirectory;
    private String testOutputDirectory;
    private boolean verbose;
    private String locator;
    private boolean test = false;
    private String classpath;
    private boolean noswap;

    public void execute() throws MojoFailureException {
        String[] argv;
        int result;
        File output = !this.test ? new File(this.outputDirectory) : new File(this.testOutputDirectory);
        if (!output.exists()) {
            if (this.verbose) {
                System.out.println("Exiting hk2-inhabitant-generator because could not find output directory " + output.getAbsolutePath());
            }
            return;
        }
        if (this.verbose) {
            System.out.println("hk2-inhabitant-generator generating into location " + output.getAbsolutePath());
        }
        LinkedList<String> arguments = new LinkedList<String>();
        arguments.add("--file");
        arguments.add(output.getAbsolutePath());
        if (this.verbose) {
            arguments.add("--verbose");
        }
        if (this.locator != null) {
            arguments.add("--locator");
            arguments.add(this.locator);
        }
        if (this.classpath != null) {
            String classpathValue = this.getClasspathFromFile();
            if (classpathValue == null) {
                throw new MojoFailureException("Found the file, but it did not contain a line with the classpath");
            }
            arguments.add("--searchPath");
            arguments.add(classpathValue);
        }
        if (this.noswap) {
            arguments.add("--noswap");
        }
        if ((result = HabitatGenerator.embeddedMain(argv = arguments.toArray(new String[arguments.size()]))) != 0) {
            throw new MojoFailureException("Could not generate inhabitants file for " + (this.test ? this.testOutputDirectory : this.outputDirectory));
        }
    }

    private String getClasspathFromFile() throws MojoFailureException {
        File classpathFile = new File(this.classpath);
        if (!classpathFile.exists() || classpathFile.isDirectory() || !classpathFile.canRead()) {
            throw new MojoFailureException("Could not find or read file " + classpathFile.getAbsolutePath());
        }
        try {
            FileInputStream is = new FileInputStream(classpathFile);
            InputStreamReader reader = new InputStreamReader(is);
            BufferedReader bis = new BufferedReader(reader);
            String line = bis.readLine();
            bis.close();
            ((Reader)reader).close();
            ((InputStream)is).close();
            if (this.test) {
                File buildDirectoryFile = new File(this.outputDirectory);
                return buildDirectoryFile.getAbsolutePath() + File.pathSeparator + line;
            }
            return line;
        }
        catch (IOException ioe) {
            throw new MojoFailureException(ioe.getMessage());
        }
    }
}

