/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.generator.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.inject.Singleton;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.ErrorService;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.Proxiable;
import org.glassfish.hk2.api.Rank;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.generator.internal.AbstractClassVisitorImpl;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class Utilities {
    private static final String DOT_CLASS = ".class";
    private static final String CONTRACT_WITH_SLASHES = "L" + Contract.class.getName().replace('.', '/') + ";";
    private static final String SCOPE_WITH_SLASHES = "L" + Scope.class.getName().replace('.', '/') + ";";
    private static final String QUALIFIER_WITH_SLASHES = "L" + Qualifier.class.getName().replace('.', '/') + ";";
    private final Map<String, Boolean> ISA_CONTRACT = new HashMap<String, Boolean>();
    private final Map<String, Boolean> ISA_SCOPE = new HashMap<String, Boolean>();
    private final Map<String, Boolean> ISA_QUALIFIER = new HashMap<String, Boolean>();
    private final Map<String, String> FOUND_SUPERCLASS = new HashMap<String, String>();
    private final Map<String, Set<String>> FOUND_INTERFACES = new HashMap<String, Set<String>>();
    private final boolean verbose;
    private final String searchPath;
    private static final String CONFIGURED_CONTRACT = "org.jvnet.hk2.config.Configured";
    private static final List<KnownClassData> KNOWN_DATA = new LinkedList<KnownClassData>();

    Utilities(boolean verbose, String searchPath) {
        this.verbose = verbose;
        this.searchPath = searchPath;
        for (KnownClassData kcd : KNOWN_DATA) {
            this.ISA_CONTRACT.put(kcd.getClazz(), kcd.isIsa_contract());
            this.ISA_SCOPE.put(kcd.getClazz(), kcd.isIsa_scope());
            this.ISA_QUALIFIER.put(kcd.getClazz(), kcd.isIsa_qualifier());
            this.FOUND_SUPERCLASS.put(kcd.getClazz(), kcd.getSuperclass());
            this.FOUND_INTERFACES.put(kcd.getClazz(), kcd.getiFaces());
        }
    }

    private InputStream findClass(File searchHere, String dotDelimitedName, boolean searchClassPath, String calledFrom) throws IOException {
        if (this.verbose && searchClassPath) {
            System.out.println("Looking for " + dotDelimitedName + " for discovery of " + calledFrom);
        }
        if (searchHere.isDirectory()) {
            String properPathName = dotDelimitedName.replace('.', File.separatorChar) + DOT_CLASS;
            File fullFile = new File(searchHere, properPathName);
            if (fullFile.exists()) {
                return new FileInputStream(fullFile);
            }
        } else {
            JarFile jar = new JarFile(searchHere);
            String entryName = dotDelimitedName.replace('.', '/') + DOT_CLASS;
            ZipEntry entry = jar.getEntry(entryName);
            if (entry != null) {
                return jar.getInputStream(entry);
            }
        }
        if (!searchClassPath) {
            return null;
        }
        String classpath = this.searchPath;
        if (classpath == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String pathElement = st.nextToken();
            File nextSearchGuy = new File(pathElement);
            InputStream is = this.findClass(nextSearchGuy, dotDelimitedName, false, calledFrom);
            if (is == null) continue;
            return is;
        }
        return null;
    }

    private void nullCaches(String dotDelimitedName) {
        this.ISA_CONTRACT.put(dotDelimitedName, false);
        this.ISA_SCOPE.put(dotDelimitedName, false);
        this.ISA_QUALIFIER.put(dotDelimitedName, false);
        this.FOUND_SUPERCLASS.put(dotDelimitedName, null);
    }

    public boolean isClassAContract(File searchHere, String dotDelimitedName) {
        if (this.ISA_CONTRACT.containsKey(dotDelimitedName)) {
            return this.ISA_CONTRACT.get(dotDelimitedName);
        }
        try {
            InputStream is = this.findClass(searchHere, dotDelimitedName, true, "isaContract");
            if (is == null) {
                this.nullCaches(dotDelimitedName);
                return false;
            }
            ClassReader reader = new ClassReader(is);
            ContractClassVisitor ccv = new ContractClassVisitor(CONTRACT_WITH_SLASHES, dotDelimitedName);
            reader.accept((ClassVisitor)ccv, 7);
            return ccv.isALookedForThing();
        }
        catch (IOException ioe) {
            this.nullCaches(dotDelimitedName);
            return false;
        }
    }

    private String getSuperclass(File searchHere, String dotDelimitedName) {
        if (this.FOUND_SUPERCLASS.containsKey(dotDelimitedName)) {
            return this.FOUND_SUPERCLASS.get(dotDelimitedName);
        }
        try {
            InputStream is = this.findClass(searchHere, dotDelimitedName, true, "superclass");
            if (is == null) {
                this.nullCaches(dotDelimitedName);
                return null;
            }
            ClassReader reader = new ClassReader(is);
            ContractClassVisitor ccv = new ContractClassVisitor(null, dotDelimitedName);
            reader.accept((ClassVisitor)ccv, 7);
            return ccv.getDotDelimitedSuperclass();
        }
        catch (IOException ioe) {
            this.nullCaches(dotDelimitedName);
            return null;
        }
    }

    public boolean isClassAScope(File searchHere, String dotDelimitedName) {
        if (this.ISA_SCOPE.containsKey(dotDelimitedName)) {
            return this.ISA_SCOPE.get(dotDelimitedName);
        }
        try {
            InputStream is = this.findClass(searchHere, dotDelimitedName, true, "isascope");
            if (is == null) {
                this.nullCaches(dotDelimitedName);
                return false;
            }
            ClassReader reader = new ClassReader(is);
            ContractClassVisitor ccv = new ContractClassVisitor(SCOPE_WITH_SLASHES, dotDelimitedName);
            reader.accept((ClassVisitor)ccv, 7);
            return ccv.isALookedForThing();
        }
        catch (IOException ioe) {
            this.nullCaches(dotDelimitedName);
            return false;
        }
    }

    public boolean isClassAQualifier(File searchHere, String dotDelimitedName) {
        if (this.ISA_QUALIFIER.containsKey(dotDelimitedName)) {
            return this.ISA_QUALIFIER.get(dotDelimitedName);
        }
        try {
            InputStream is = this.findClass(searchHere, dotDelimitedName, true, "isaQualifier");
            if (is == null) {
                this.nullCaches(dotDelimitedName);
                return false;
            }
            ClassReader reader = new ClassReader(is);
            ContractClassVisitor ccv = new ContractClassVisitor(QUALIFIER_WITH_SLASHES, dotDelimitedName);
            reader.accept((ClassVisitor)ccv, 7);
            return ccv.isALookedForThing();
        }
        catch (IOException ioe) {
            this.nullCaches(dotDelimitedName);
            return false;
        }
    }

    private void getAssociatedSuperclassContracts(File searchHere, String dotDelimitedName, Set<String> addToMe) {
        String dotDelimitedSuperclass;
        if (!addToMe.contains(dotDelimitedName) && this.isClassAContract(searchHere, dotDelimitedName)) {
            addToMe.add(dotDelimitedName);
        }
        if ((dotDelimitedSuperclass = this.getSuperclass(searchHere, dotDelimitedName)) != null) {
            this.getAssociatedSuperclassContracts(searchHere, dotDelimitedSuperclass, addToMe);
        }
    }

    public Set<String> getAssociatedContracts(File searchHere, String dotDelimitedName) {
        LinkedHashSet<String> retVal = new LinkedHashSet<String>();
        retVal.add(dotDelimitedName);
        this.getAssociatedSuperclassContracts(searchHere, dotDelimitedName, retVal);
        while (dotDelimitedName != null) {
            Set<String> allInterfaces = this.FOUND_INTERFACES.get(dotDelimitedName);
            if (allInterfaces == null) {
                dotDelimitedName = this.getSuperclass(searchHere, dotDelimitedName);
                continue;
            }
            for (String dotDelimitedInterface : allInterfaces) {
                if (!this.isClassAContract(searchHere, dotDelimitedInterface)) continue;
                retVal.add(dotDelimitedInterface);
            }
            dotDelimitedName = this.getSuperclass(searchHere, dotDelimitedName);
        }
        return retVal;
    }

    static {
        Set empty = Collections.emptySet();
        KNOWN_DATA.add(new KnownClassData(Factory.class.getName(), true, false, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(Context.class.getName(), true, false, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(ErrorService.class.getName(), true, false, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(Singleton.class.getName(), false, true, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(PerLookup.class.getName(), false, true, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(Named.class.getName(), false, false, true, null, empty));
        KNOWN_DATA.add(new KnownClassData(Contract.class.getName(), false, false, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(CONFIGURED_CONTRACT, true, false, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(Scope.class.getName(), false, false, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(Target.class.getName(), false, false, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(Retention.class.getName(), false, false, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(Proxiable.class.getName(), false, false, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(Annotation.class.getName(), false, false, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(Qualifier.class.getName(), false, false, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(Documented.class.getName(), false, false, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(Inherited.class.getName(), false, false, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(ContractsProvided.class.getName(), false, false, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(Rank.class.getName(), false, false, false, null, empty));
    }

    private static class KnownClassData {
        private final String clazz;
        private final boolean isa_contract;
        private final boolean isa_scope;
        private final boolean isa_qualifier;
        private final String superclass;
        private final Set<String> iFaces;

        private KnownClassData(String clazz, boolean isa_contract, boolean isa_scope, boolean isa_qualifier, String superclass, Set<String> iFaces) {
            this.clazz = clazz;
            this.isa_contract = isa_contract;
            this.isa_scope = isa_scope;
            this.isa_qualifier = isa_qualifier;
            this.superclass = superclass;
            this.iFaces = iFaces;
        }

        String getClazz() {
            return this.clazz;
        }

        boolean isIsa_contract() {
            return this.isa_contract;
        }

        boolean isIsa_scope() {
            return this.isa_scope;
        }

        boolean isIsa_qualifier() {
            return this.isa_qualifier;
        }

        String getSuperclass() {
            return this.superclass;
        }

        Set<String> getiFaces() {
            return this.iFaces;
        }
    }

    private class ContractClassVisitor
    extends AbstractClassVisitorImpl {
        private final String cacheKey;
        private final String lookForMe;
        private boolean isLookedFor = false;
        private boolean isContract = false;
        private boolean isScope = false;
        private boolean isQualifier = false;
        private String dotDelimitedSuperclass;

        private ContractClassVisitor(String lookForMe, String cacheKey) {
            this.lookForMe = lookForMe;
            this.cacheKey = cacheKey;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (!Utilities.this.FOUND_INTERFACES.containsKey(this.cacheKey)) {
                LinkedHashSet<String> iFaces = new LinkedHashSet<String>();
                for (String iFace : interfaces) {
                    String iWithDots = iFace.replace('/', '.');
                    iFaces.add(iWithDots);
                }
                Utilities.this.FOUND_INTERFACES.put(this.cacheKey, iFaces);
            }
            if (superName == null) {
                Utilities.this.FOUND_SUPERCLASS.put(this.cacheKey, null);
                return;
            }
            this.dotDelimitedSuperclass = superName.replace('/', '.');
            if (Object.class.getName().equals(this.dotDelimitedSuperclass)) {
                this.dotDelimitedSuperclass = null;
            }
            Utilities.this.FOUND_SUPERCLASS.put(this.cacheKey, this.dotDelimitedSuperclass);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean arg1) {
            if (this.lookForMe != null && desc.equals(this.lookForMe)) {
                this.isLookedFor = true;
            }
            if (desc.equals(CONTRACT_WITH_SLASHES)) {
                this.isContract = true;
            }
            if (desc.equals(SCOPE_WITH_SLASHES)) {
                this.isScope = true;
            }
            if (desc.equals(QUALIFIER_WITH_SLASHES)) {
                this.isQualifier = true;
            }
            return null;
        }

        @Override
        public void visitEnd() {
            Utilities.this.ISA_CONTRACT.put(this.cacheKey, this.isContract);
            Utilities.this.ISA_SCOPE.put(this.cacheKey, this.isScope);
            Utilities.this.ISA_QUALIFIER.put(this.cacheKey, this.isQualifier);
        }

        private boolean isALookedForThing() {
            return this.isLookedFor;
        }

        private String getDotDelimitedSuperclass() {
            return this.dotDelimitedSuperclass;
        }
    }
}

