/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.generator.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.glassfish.hk2.utilities.DescriptorImpl;
import org.jvnet.hk2.generator.internal.ClassVisitorImpl;
import org.jvnet.hk2.generator.internal.Utilities;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class GeneratorRunner {
    private static final String DOT_CLASS = ".class";
    private static final String META_INF = "META-INF";
    private static final String INHABITANTS = "hk2-locator";
    private final Utilities utilities;
    private final String fileOrDirectory;
    private final String outjarName;
    private final String locatorName;
    private final boolean verbose;
    private final boolean noSwap;

    public GeneratorRunner(String fileOrDirectory, String outjarName, String locatorName, boolean verbose, String searchPath, boolean noSwap) {
        this.fileOrDirectory = fileOrDirectory;
        this.outjarName = outjarName;
        this.locatorName = locatorName;
        this.verbose = verbose;
        this.noSwap = noSwap;
        this.utilities = new Utilities(verbose, searchPath);
    }

    public void go() throws AssertionError, IOException {
        File toInspect = new File(this.fileOrDirectory);
        if (!toInspect.exists()) {
            throw new AssertionError((Object)("Could not find file: " + toInspect.getAbsolutePath()));
        }
        if (toInspect.isDirectory()) {
            List<DescriptorImpl> allDescriptors = this.findAllServicesFromDirectory(toInspect, toInspect);
            if (allDescriptors.isEmpty()) {
                return;
            }
            this.writeToDirectory(toInspect, allDescriptors);
        } else {
            List<DescriptorImpl> allDescriptors = this.findAllServicesFromJar(toInspect);
            this.writeToJar(toInspect, allDescriptors);
        }
    }

    private List<DescriptorImpl> findAllServicesFromDirectory(File directory, File parent) throws IOException {
        File[] candidates;
        File[] subDirectories;
        LinkedList<DescriptorImpl> retVal = new LinkedList<DescriptorImpl>();
        for (File subDirectory : subDirectories = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) {
            retVal.addAll(this.findAllServicesFromDirectory(subDirectory, parent));
        }
        for (File candidate : candidates = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(GeneratorRunner.DOT_CLASS);
            }
        })) {
            FileInputStream fis = new FileInputStream(candidate);
            LinkedList<DescriptorImpl> dis = this.createDescriptorIfService(fis, parent);
            retVal.addAll(dis);
        }
        return retVal;
    }

    private void writeToDirectory(File parent, List<DescriptorImpl> descriptors) throws IOException {
        File META_INF_dir = new File(parent, META_INF);
        File inhabitantsDir = new File(META_INF_dir, INHABITANTS);
        File outputFile = new File(inhabitantsDir, this.locatorName);
        if (!inhabitantsDir.exists()) {
            inhabitantsDir.mkdirs();
        }
        File noSwapFile = null;
        boolean directWrite = false;
        if (this.noSwap || !outputFile.exists()) {
            directWrite = true;
            if (outputFile.exists() && !outputFile.delete()) {
                throw new IOException("Could not delete existing inhabitant file " + outputFile.getAbsolutePath() + " in the noSwap case");
            }
            noSwapFile = outputFile;
        }
        File writeMeFile = this.writeInhabitantsFile(descriptors, noSwapFile);
        if (!directWrite) {
            if (outputFile.exists() && !outputFile.delete()) {
                throw new IOException("Could not delete existing inhabitant file " + outputFile.getAbsolutePath());
            }
            String tmpFileAbsolutePath = writeMeFile.getAbsolutePath();
            if (this.verbose) {
                System.out.println("Swapping " + tmpFileAbsolutePath + " to " + outputFile.getAbsolutePath());
            }
            if (!writeMeFile.renameTo(outputFile)) {
                throw new IOException("Could not move generated inhabitant file " + tmpFileAbsolutePath + " to " + outputFile.getAbsolutePath());
            }
        }
    }

    private void writeToJar(File jarFile, List<DescriptorImpl> descriptors) throws IOException {
        int len;
        File writeMeFile = this.writeInhabitantsFile(descriptors, null);
        writeMeFile.deleteOnExit();
        byte[] buffer = new byte[1024];
        File tmpJarFile = File.createTempFile(jarFile.getName(), ".tmp");
        FileInputStream fis = new FileInputStream(jarFile);
        ZipInputStream zis = new ZipInputStream(fis);
        FileOutputStream fos = new FileOutputStream(tmpJarFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        ZipEntry zentry = zis.getNextEntry();
        while (zentry != null) {
            String entryName = zentry.getName();
            if (entryName.equals("META-INF/hk2-locator/" + this.locatorName)) {
                zentry = zis.getNextEntry();
                continue;
            }
            zos.putNextEntry(new ZipEntry(entryName));
            while ((len = zis.read(buffer)) > 0) {
                zos.write(buffer, 0, len);
            }
            zentry = zis.getNextEntry();
        }
        zis.close();
        if (!descriptors.isEmpty()) {
            zos.putNextEntry(new ZipEntry("META-INF/hk2-locator/" + this.locatorName));
            FileInputStream desc_os = new FileInputStream(writeMeFile);
            while ((len = desc_os.read(buffer)) > 0) {
                zos.write(buffer, 0, len);
            }
            desc_os.close();
        }
        zos.close();
        String tmpFileName = tmpJarFile.getAbsolutePath();
        File outjar = new File(this.outjarName);
        if (this.verbose) {
            System.out.println("Swapping jar file " + tmpFileName + " to " + outjar.getAbsolutePath());
        }
        if (!tmpJarFile.renameTo(outjar)) {
            throw new IOException("Unable to swap generated JAR file " + tmpFileName + " to " + outjar.getAbsolutePath());
        }
    }

    private File writeInhabitantsFile(List<DescriptorImpl> descriptors, File noSwapFile) throws IOException {
        File outFile = noSwapFile != null ? noSwapFile : File.createTempFile(this.locatorName, ".tmp");
        if (this.verbose) {
            System.out.println("Writing " + descriptors.size() + " entries to file " + outFile.getAbsolutePath());
        }
        FileOutputStream fos = new FileOutputStream(outFile);
        PrintWriter pw = new PrintWriter(fos);
        pw.println("#");
        pw.println("# Generated on " + new Date());
        pw.println("#");
        pw.println();
        for (DescriptorImpl di : descriptors) {
            di.writeObject(pw);
        }
        pw.close();
        fos.close();
        if (this.verbose) {
            System.out.println("Wrote " + descriptors.size() + " entries to inhabitant file " + outFile.getAbsolutePath());
        }
        return outFile;
    }

    private List<DescriptorImpl> findAllServicesFromJar(File jar) throws IOException {
        LinkedList<DescriptorImpl> retVal = new LinkedList<DescriptorImpl>();
        JarFile jarFile = new JarFile(jar);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.endsWith(DOT_CLASS)) continue;
            LinkedList<DescriptorImpl> dis = this.createDescriptorIfService(jarFile.getInputStream(entry), jar);
            retVal.addAll(dis);
        }
        return retVal;
    }

    private LinkedList<DescriptorImpl> createDescriptorIfService(InputStream is, File searchHere) throws IOException {
        ClassReader reader = new ClassReader(is);
        ClassVisitorImpl cvi = new ClassVisitorImpl(this.utilities, this.verbose, searchHere);
        reader.accept((ClassVisitor)cvi, 7);
        return cvi.getGeneratedDescriptor();
    }
}

