/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.generator.internal;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import javax.inject.Named;
import javax.inject.Singleton;
import org.glassfish.hk2.api.DescriptorType;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.utilities.DescriptorImpl;
import org.jvnet.hk2.generator.internal.AbstractAnnotationVisitorImpl;
import org.jvnet.hk2.generator.internal.AbstractClassVisitorImpl;
import org.jvnet.hk2.generator.internal.AbstractMethodVisitorImpl;
import org.jvnet.hk2.generator.internal.Utilities;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ClassVisitorImpl
extends AbstractClassVisitorImpl {
    private static final String SERVICE_CLASS_FORM = "Lorg/jvnet/hk2/annotations/Service;";
    private static final String CONTRACTS_PROVIDED_CLASS_FORM = "Lorg/jvnet/hk2/annotations/ContractsProvided;";
    private static final String RANK_CLASS_FORM = "Lorg/glassfish/hk2/api/Rank;";
    private static final String NAME = "name";
    private static final String METADATA = "metadata";
    private static final String VALUE = "value";
    private static final String PROVIDE = "provide";
    private final boolean verbose;
    private final File searchHere;
    private final Utilities utilities;
    private String implName;
    private final LinkedHashSet<String> iFaces = new LinkedHashSet();
    private LinkedHashSet<String> providedContracts;
    private String scopeClass;
    private final LinkedList<String> qualifiers = new LinkedList();
    private boolean isAService = false;
    private NamedAnnotationVisitor baseName;
    private String metadataString = null;
    private Integer rank = null;
    private final LinkedList<DescriptorImpl> generatedDescriptors = new LinkedList();
    private boolean isFactory = false;
    private boolean factoryMethodFound = false;

    public ClassVisitorImpl(Utilities utilities, boolean verbose, File searchHere) {
        this.utilities = utilities;
        this.verbose = verbose;
        this.searchHere = searchHere;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.implName = name.replace("/", ".");
        this.iFaces.addAll(this.utilities.getAssociatedContracts(this.searchHere, this.implName));
        if (this.iFaces.contains(Factory.class.getName())) {
            this.isFactory = true;
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (!visible) {
            return null;
        }
        if (SERVICE_CLASS_FORM.equals(desc)) {
            this.isAService = true;
            return new ServiceAnnotationVisitor();
        }
        if (CONTRACTS_PROVIDED_CLASS_FORM.equals(desc)) {
            this.providedContracts = new LinkedHashSet();
            return new ContractsProvidedAnnotationVisitor();
        }
        if (RANK_CLASS_FORM.equals(desc)) {
            return new RankAnnotationVisitor();
        }
        if (!desc.startsWith("L")) {
            return null;
        }
        String loadQualifierName = desc.substring(1, desc.length() - 1).replace("/", ".");
        if (this.utilities.isClassAScope(this.searchHere, loadQualifierName)) {
            this.scopeClass = loadQualifierName;
        } else if (this.utilities.isClassAQualifier(this.searchHere, loadQualifierName)) {
            this.qualifiers.add(loadQualifierName);
            if (Named.class.getName().equals(loadQualifierName)) {
                this.baseName = new NamedAnnotationVisitor(this.getDefaultName(), null);
                return this.baseName;
            }
        }
        return null;
    }

    private String getDefaultName() {
        int index = this.implName.lastIndexOf(46);
        if (index <= 0) {
            return this.implName;
        }
        return this.implName.substring(index + 1);
    }

    @Override
    public void visitEnd() {
        if (!this.isAService) {
            if (this.verbose) {
                System.out.println("Class " + this.implName + " is not annotated with @Service");
            }
            return;
        }
        DescriptorImpl generatedDescriptor = new DescriptorImpl();
        generatedDescriptor.setImplementation(this.implName);
        if (this.scopeClass == null) {
            generatedDescriptor.setScope(Singleton.class.getName());
        } else {
            generatedDescriptor.setScope(this.scopeClass);
        }
        if (this.providedContracts != null) {
            for (String providedContract : this.providedContracts) {
                generatedDescriptor.addAdvertisedContract(providedContract);
            }
        } else {
            generatedDescriptor.addAdvertisedContract(this.implName);
            for (String iFace : this.iFaces) {
                generatedDescriptor.addAdvertisedContract(iFace);
            }
        }
        for (String qualifier : this.qualifiers) {
            generatedDescriptor.addQualifier(qualifier);
        }
        if (this.baseName != null) {
            generatedDescriptor.setName(this.baseName.getName());
        }
        if (this.metadataString != null) {
            StringTokenizer commaTokenizer = new StringTokenizer(this.metadataString, ",");
            while (commaTokenizer.hasMoreTokens()) {
                String keyValueString = commaTokenizer.nextToken();
                int equalsIndex = keyValueString.indexOf(61);
                if (equalsIndex < 0) continue;
                String key = keyValueString.substring(0, equalsIndex);
                String value = keyValueString.substring(equalsIndex + 1);
                if (key.length() <= 0 || value.length() <= 0) continue;
                generatedDescriptor.addMetadata(key, value);
            }
        }
        if (this.rank != null) {
            generatedDescriptor.setRanking(this.rank.intValue());
        }
        if (this.verbose) {
            System.out.println("Generated Descriptor: " + generatedDescriptor);
        }
        this.generatedDescriptors.add(generatedDescriptor);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (!this.isFactory) {
            return null;
        }
        if (!PROVIDE.equals(name)) {
            return null;
        }
        if (!desc.startsWith("()")) {
            return null;
        }
        if (this.factoryMethodFound) {
            return null;
        }
        this.factoryMethodFound = true;
        DescriptorImpl asAFactory = new DescriptorImpl();
        this.generatedDescriptors.add(asAFactory);
        asAFactory.setImplementation(this.implName);
        asAFactory.setDescriptorType(DescriptorType.FACTORY);
        String factoryType = desc.substring(2);
        if (factoryType.charAt(0) == '[') {
            asAFactory.addAdvertisedContract(factoryType);
        } else {
            if (factoryType.charAt(0) != 'L') {
                throw new AssertionError((Object)("Unable to handle provide descriptor " + desc));
            }
            int endIndex = factoryType.indexOf(59);
            if (endIndex < 0) {
                throw new AssertionError((Object)("Unable to find end of class return type in descriptor " + desc));
            }
            String trueFactoryClass = factoryType.substring(1, endIndex);
            trueFactoryClass = trueFactoryClass.replace('/', '.');
            Set<String> associatedContracts = this.utilities.getAssociatedContracts(this.searchHere, trueFactoryClass);
            for (String contract : associatedContracts) {
                asAFactory.addAdvertisedContract(contract);
            }
        }
        return new MethodVisitorImpl(asAFactory);
    }

    public LinkedList<DescriptorImpl> getGeneratedDescriptor() {
        return this.generatedDescriptors;
    }

    private class MethodRankAnnotationVisitor
    extends AbstractAnnotationVisitorImpl {
        private final DescriptorImpl di;

        private MethodRankAnnotationVisitor(DescriptorImpl di) {
            this.di = di;
        }

        @Override
        public void visit(String name, Object value) {
            this.di.setRanking(((Integer)value).intValue());
        }
    }

    private class RankAnnotationVisitor
    extends AbstractAnnotationVisitorImpl {
        private RankAnnotationVisitor() {
        }

        @Override
        public void visit(String name, Object value) {
            ClassVisitorImpl.this.rank = (Integer)value;
        }
    }

    private class ContractsProvidedAnnotationVisitor
    extends AbstractAnnotationVisitorImpl {
        private ContractsProvidedAnnotationVisitor() {
        }

        @Override
        public void visit(String name, Object value) {
            if (value == null) {
                return;
            }
            if (!(value instanceof Type)) {
                return;
            }
            ClassVisitorImpl.this.providedContracts.add(((Type)value).getClassName());
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            if (!ClassVisitorImpl.VALUE.equals(name)) {
                return null;
            }
            return this;
        }
    }

    private class MethodVisitorImpl
    extends AbstractMethodVisitorImpl {
        private final DescriptorImpl asAFactoryDI;
        private NamedAnnotationVisitor factoryName;

        private MethodVisitorImpl(DescriptorImpl asAFactoryDI) {
            this.asAFactoryDI = asAFactoryDI;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (!desc.startsWith("L")) {
                return null;
            }
            String loadQualifierName = desc.substring(1, desc.length() - 1).replace("/", ".");
            if (ClassVisitorImpl.this.utilities.isClassAScope(ClassVisitorImpl.this.searchHere, loadQualifierName)) {
                this.asAFactoryDI.setScope(loadQualifierName);
            } else if (ClassVisitorImpl.this.utilities.isClassAQualifier(ClassVisitorImpl.this.searchHere, loadQualifierName)) {
                this.asAFactoryDI.addQualifier(loadQualifierName);
                if (Named.class.getName().equals(loadQualifierName)) {
                    this.factoryName = new NamedAnnotationVisitor(ClassVisitorImpl.this.getDefaultName(), null);
                    return this.factoryName;
                }
            } else if (desc.equals(ClassVisitorImpl.RANK_CLASS_FORM)) {
                return new MethodRankAnnotationVisitor(this.asAFactoryDI);
            }
            return null;
        }

        public void visitEnd() {
            if (this.factoryName != null && this.factoryName.getName() != null) {
                this.asAFactoryDI.setName(this.factoryName.getName());
            }
            if (ClassVisitorImpl.this.verbose) {
                System.out.println("Adding a factory descriptor: " + this.asAFactoryDI);
            }
        }
    }

    private class NamedAnnotationVisitor
    extends AbstractAnnotationVisitorImpl {
        private final String defaultName;
        private boolean nameSet = false;
        private String name;

        public NamedAnnotationVisitor(String defaultName, String name) {
            this.defaultName = defaultName;
            this.name = name;
        }

        @Override
        public void visit(String annotationName, Object value) {
            if (annotationName.equals(ClassVisitorImpl.VALUE)) {
                this.name = (String)value;
                this.nameSet = true;
            }
        }

        @Override
        public void visitEnd() {
            if (this.nameSet) {
                return;
            }
            this.name = this.defaultName;
        }

        private String getName() {
            return this.name;
        }
    }

    private class ServiceAnnotationVisitor
    extends AbstractAnnotationVisitorImpl {
        private ServiceAnnotationVisitor() {
        }

        @Override
        public void visit(String annotationName, Object value) {
            if (annotationName.equals(ClassVisitorImpl.NAME)) {
                ClassVisitorImpl.this.baseName = new NamedAnnotationVisitor(null, (String)value);
            } else if (annotationName.equals(ClassVisitorImpl.METADATA)) {
                ClassVisitorImpl.this.metadataString = (String)value;
            }
        }
    }
}

