/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.generator.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jvnet.hk2.generator.HabitatGenerator;

public class MavenInhabitantsGenerator
extends AbstractMojo {
    protected MavenProject project;
    private File outputDirectory;
    private File testOutputDirectory;
    private boolean verbose;
    private String locator;
    private boolean test = false;
    private boolean noswap;
    private String supportedProjectTypes;

    public void execute() throws MojoFailureException {
        String[] argv;
        int result;
        List<String> projectTypes = Arrays.asList(this.supportedProjectTypes.split(","));
        if (!projectTypes.contains(this.project.getPackaging())) {
            return;
        }
        File output = this.test ? this.testOutputDirectory : this.outputDirectory;
        output.mkdirs();
        if (!output.exists()) {
            this.getLog().info((CharSequence)("Exiting hk2-inhabitant-generator because could not find output directory " + output.getAbsolutePath()));
            return;
        }
        if (this.verbose) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("hk2-inhabitant-generator generating into location " + output.getAbsolutePath()));
            this.getLog().info((CharSequence)"");
        }
        LinkedList<String> arguments = new LinkedList<String>();
        arguments.add("--file");
        arguments.add(output.getAbsolutePath());
        if (this.verbose) {
            arguments.add("--verbose");
        }
        if (this.locator != null) {
            arguments.add("--locator");
            arguments.add(this.locator);
        }
        arguments.add("--searchPath");
        arguments.add(this.getBuildClasspath());
        if (this.noswap) {
            arguments.add("--noswap");
        }
        if ((result = HabitatGenerator.embeddedMain(argv = arguments.toArray(new String[arguments.size()]))) != 0) {
            throw new MojoFailureException("Could not generate inhabitants file for " + (this.test ? this.testOutputDirectory : this.outputDirectory));
        }
    }

    private String getBuildClasspath() {
        ArrayList artList;
        Iterator i;
        StringBuilder sb = new StringBuilder();
        if (this.test) {
            sb.append(this.outputDirectory.getAbsolutePath());
            sb.append(File.pathSeparator);
        }
        if ((i = (artList = new ArrayList(this.project.getArtifacts())).iterator()).hasNext()) {
            sb.append(((Artifact)i.next()).getFile().getPath());
            while (i.hasNext()) {
                sb.append(File.pathSeparator);
                sb.append(((Artifact)i.next()).getFile().getPath());
            }
        }
        String classpath = sb.toString();
        if (this.verbose) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"-- Classpath --");
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)classpath);
            this.getLog().info((CharSequence)"");
        }
        return classpath;
    }
}

