/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.generator.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.inject.Singleton;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.ErrorService;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.Metadata;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.Proxiable;
import org.glassfish.hk2.api.Rank;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.generator.internal.AbstractAnnotationVisitorImpl;
import org.jvnet.hk2.generator.internal.AbstractClassVisitorImpl;
import org.jvnet.hk2.generator.internal.AbstractMethodVisitorImpl;
import org.jvnet.hk2.generator.internal.GenerateMethodAnnotationData;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class Utilities {
    private static final String DOT_CLASS = ".class";
    private static final String CONTRACT_WITH_SLASHES = "L" + Contract.class.getName().replace('.', '/') + ";";
    private static final String SCOPE_WITH_SLASHES = "L" + Scope.class.getName().replace('.', '/') + ";";
    private static final String QUALIFIER_WITH_SLASHES = "L" + Qualifier.class.getName().replace('.', '/') + ";";
    private static final String METHOD_GENERATOR_WITH_SLASHES = "Lorg/jvnet/hk2/config/GenerateServiceFromMethod;";
    private static final String GENERATOR_NAME_FIELD_WITH_SLASHES = "Lorg/jvnet/hk2/config/GeneratedServiceName;";
    private static final String METADATA_DESC = "Lorg/glassfish/hk2/api/Metadata;";
    private final Map<String, Boolean> ISA_CONTRACT = new HashMap<String, Boolean>();
    private final Map<String, Boolean> ISA_SCOPE = new HashMap<String, Boolean>();
    private final Map<String, Boolean> ISA_QUALIFIER = new HashMap<String, Boolean>();
    private final Map<String, String> FOUND_SUPERCLASS = new HashMap<String, String>();
    private final Map<String, Set<String>> FOUND_INTERFACES = new HashMap<String, Set<String>>();
    private final Map<String, GenerateMethodAnnotationData> FOUND_GENERATORS = new HashMap<String, GenerateMethodAnnotationData>();
    private final Map<String, Map<String, String>> METADATA = new HashMap<String, Map<String, String>>();
    private final boolean verbose;
    private final String searchPath;
    private static final String CONFIGURED_CONTRACT = "org.jvnet.hk2.config.Configured";
    private static final List<KnownClassData> KNOWN_DATA = new LinkedList<KnownClassData>();
    private static final String GENERATOR_IMPL_NAME = "implementation";
    private static final String GENERATOR_SCOPE_NAME = "scope";
    private static final String LIST_WITH_PTYPE = "Ljava/util/List<";

    Utilities(boolean verbose, String searchPath) {
        this.verbose = verbose;
        this.searchPath = searchPath;
        for (KnownClassData kcd : KNOWN_DATA) {
            this.ISA_CONTRACT.put(kcd.getClazz(), kcd.isIsa_contract());
            this.ISA_SCOPE.put(kcd.getClazz(), kcd.isIsa_scope());
            this.ISA_QUALIFIER.put(kcd.getClazz(), kcd.isIsa_qualifier());
            this.FOUND_SUPERCLASS.put(kcd.getClazz(), kcd.getSuperclass());
            this.FOUND_INTERFACES.put(kcd.getClazz(), kcd.getiFaces());
            this.FOUND_GENERATORS.put(kcd.getClazz(), null);
        }
    }

    private InputStream findClass(File searchHere, String dotDelimitedName, boolean searchClassPath, String calledFrom) throws IOException {
        if (this.verbose && searchClassPath) {
            System.out.println("Looking for " + dotDelimitedName + " for discovery of " + calledFrom);
        }
        if (searchHere.isDirectory()) {
            String properPathName = dotDelimitedName.replace('.', File.separatorChar) + DOT_CLASS;
            File fullFile = new File(searchHere, properPathName);
            if (fullFile.exists()) {
                return new FileInputStream(fullFile);
            }
        } else {
            JarFile jar = new JarFile(searchHere);
            String entryName = dotDelimitedName.replace('.', '/') + DOT_CLASS;
            ZipEntry entry = jar.getEntry(entryName);
            if (entry != null) {
                return jar.getInputStream(entry);
            }
        }
        if (!searchClassPath) {
            return null;
        }
        String classpath = this.searchPath;
        if (classpath == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String pathElement = st.nextToken();
            File nextSearchGuy = new File(pathElement);
            InputStream is = this.findClass(nextSearchGuy, dotDelimitedName, false, calledFrom);
            if (is == null) continue;
            return is;
        }
        return null;
    }

    private void nullCaches(String dotDelimitedName) {
        this.ISA_CONTRACT.put(dotDelimitedName, false);
        this.ISA_SCOPE.put(dotDelimitedName, false);
        this.ISA_QUALIFIER.put(dotDelimitedName, false);
        this.FOUND_SUPERCLASS.put(dotDelimitedName, null);
        this.FOUND_GENERATORS.put(dotDelimitedName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isClassAContract(File searchHere, String dotDelimitedName) {
        boolean bl;
        if (this.ISA_CONTRACT.containsKey(dotDelimitedName)) {
            return this.ISA_CONTRACT.get(dotDelimitedName);
        }
        InputStream is = null;
        try {
            is = this.findClass(searchHere, dotDelimitedName, true, "isaContract");
            if (is == null) {
                this.nullCaches(dotDelimitedName);
                boolean bl2 = false;
                return bl2;
            }
            ClassReader reader = new ClassReader(is);
            ContractClassVisitor ccv = new ContractClassVisitor(searchHere, CONTRACT_WITH_SLASHES, dotDelimitedName);
            reader.accept((ClassVisitor)ccv, 7);
            bl = ccv.isALookedForThing();
        }
        catch (IOException ioe) {
            this.nullCaches(dotDelimitedName);
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSuperclass(File searchHere, String dotDelimitedName) {
        String string;
        if (this.FOUND_SUPERCLASS.containsKey(dotDelimitedName)) {
            return this.FOUND_SUPERCLASS.get(dotDelimitedName);
        }
        InputStream is = null;
        try {
            is = this.findClass(searchHere, dotDelimitedName, true, "superclass");
            if (is == null) {
                this.nullCaches(dotDelimitedName);
                String string2 = null;
                return string2;
            }
            ClassReader reader = new ClassReader(is);
            ContractClassVisitor ccv = new ContractClassVisitor(searchHere, null, dotDelimitedName);
            reader.accept((ClassVisitor)ccv, 7);
            string = ccv.getDotDelimitedSuperclass();
        }
        catch (IOException ioe) {
            this.nullCaches(dotDelimitedName);
            String string3 = null;
            return string3;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClassAScope(File searchHere, String dotDelimitedName) {
        boolean bl;
        if (this.ISA_SCOPE.containsKey(dotDelimitedName)) {
            return this.ISA_SCOPE.get(dotDelimitedName);
        }
        InputStream is = null;
        try {
            is = this.findClass(searchHere, dotDelimitedName, true, "isascope");
            if (is == null) {
                this.nullCaches(dotDelimitedName);
                boolean bl2 = false;
                return bl2;
            }
            ClassReader reader = new ClassReader(is);
            ContractClassVisitor ccv = new ContractClassVisitor(searchHere, SCOPE_WITH_SLASHES, dotDelimitedName);
            reader.accept((ClassVisitor)ccv, 7);
            bl = ccv.isALookedForThing();
        }
        catch (IOException ioe) {
            this.nullCaches(dotDelimitedName);
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClassAQualifier(File searchHere, String dotDelimitedName) {
        boolean bl;
        if (this.ISA_QUALIFIER.containsKey(dotDelimitedName)) {
            return this.ISA_QUALIFIER.get(dotDelimitedName);
        }
        InputStream is = null;
        try {
            is = this.findClass(searchHere, dotDelimitedName, true, "isaQualifier");
            if (is == null) {
                this.nullCaches(dotDelimitedName);
                boolean bl2 = false;
                return bl2;
            }
            ClassReader reader = new ClassReader(is);
            ContractClassVisitor ccv = new ContractClassVisitor(searchHere, QUALIFIER_WITH_SLASHES, dotDelimitedName);
            reader.accept((ClassVisitor)ccv, 7);
            bl = ccv.isALookedForThing();
        }
        catch (IOException ioe) {
            this.nullCaches(dotDelimitedName);
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenerateMethodAnnotationData isClassAGenerator(File searchHere, String dotDelimitedName) {
        GenerateMethodAnnotationData generateMethodAnnotationData;
        if (this.FOUND_GENERATORS.containsKey(dotDelimitedName)) {
            return this.FOUND_GENERATORS.get(dotDelimitedName);
        }
        InputStream is = null;
        try {
            is = this.findClass(searchHere, dotDelimitedName, true, "isaMethodGenerator");
            if (is == null) {
                this.nullCaches(dotDelimitedName);
                GenerateMethodAnnotationData generateMethodAnnotationData2 = null;
                return generateMethodAnnotationData2;
            }
            ClassReader reader = new ClassReader(is);
            GeneratorClassVisitor gcv = new GeneratorClassVisitor(dotDelimitedName);
            reader.accept((ClassVisitor)gcv, 7);
            generateMethodAnnotationData = gcv.getGenerateMethodAnnotationData();
        }
        catch (IOException ioe) {
            this.nullCaches(dotDelimitedName);
            GenerateMethodAnnotationData generateMethodAnnotationData3 = null;
            return generateMethodAnnotationData3;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return generateMethodAnnotationData;
    }

    private void getAssociatedSuperclassContracts(File searchHere, String dotDelimitedName, Set<String> addToMe) {
        String dotDelimitedSuperclass;
        if (!addToMe.contains(dotDelimitedName) && this.isClassAContract(searchHere, dotDelimitedName)) {
            addToMe.add(dotDelimitedName);
        }
        if ((dotDelimitedSuperclass = this.getSuperclass(searchHere, dotDelimitedName)) != null) {
            this.getAssociatedSuperclassContracts(searchHere, dotDelimitedSuperclass, addToMe);
        }
    }

    public Set<String> getAssociatedContracts(File searchHere, String dotDelimitedName) {
        LinkedHashSet<String> retVal = new LinkedHashSet<String>();
        retVal.add(dotDelimitedName);
        this.getAssociatedSuperclassContracts(searchHere, dotDelimitedName, retVal);
        while (dotDelimitedName != null) {
            Set<String> allInterfaces = this.FOUND_INTERFACES.get(dotDelimitedName);
            if (allInterfaces == null) {
                dotDelimitedName = this.getSuperclass(searchHere, dotDelimitedName);
                continue;
            }
            for (String dotDelimitedInterface : allInterfaces) {
                if (this.isClassAContract(searchHere, dotDelimitedInterface)) {
                    retVal.add(dotDelimitedInterface);
                }
                this.addSubInterface(searchHere, dotDelimitedInterface, retVal);
            }
            dotDelimitedName = this.getSuperclass(searchHere, dotDelimitedName);
        }
        return retVal;
    }

    private void addSubInterface(File searchHere, String dotDelimitedInterface, LinkedHashSet<String> retVal) {
        Set<String> subInterfaces = this.FOUND_INTERFACES.get(dotDelimitedInterface);
        if (subInterfaces == null) {
            return;
        }
        for (String dotDelimitedSubInterface : subInterfaces) {
            if (this.isClassAContract(searchHere, dotDelimitedSubInterface)) {
                retVal.add(dotDelimitedSubInterface);
            }
            this.addSubInterface(searchHere, dotDelimitedSubInterface, retVal);
        }
    }

    public String getMetadataKey(String scopeOrQualifier, String methodName) {
        Map<String, String> methodToKey = this.METADATA.get(scopeOrQualifier);
        if (methodToKey == null) {
            return null;
        }
        return methodToKey.get(methodName);
    }

    static String getListActualType(String signature) {
        if (signature == null) {
            return null;
        }
        if (!signature.contains(LIST_WITH_PTYPE)) {
            return null;
        }
        int ltIndex = signature.indexOf(60);
        int gtIndex = signature.indexOf(62);
        if (ltIndex < 0 || gtIndex < 0) {
            return null;
        }
        String pType = signature.substring(ltIndex + 1, gtIndex);
        if (!pType.startsWith("L")) {
            return null;
        }
        pType = pType.substring(1, pType.length() - 1);
        return pType.replace('/', '.');
    }

    static String getFirstParameterType(String desc) {
        if (desc == null) {
            return null;
        }
        if (!desc.startsWith("(L")) {
            return null;
        }
        int semiColonIndex = desc.indexOf(59);
        if (semiColonIndex < 0) {
            return null;
        }
        String postL = desc.substring(2, semiColonIndex);
        return postL.replace('/', '.');
    }

    static {
        Set empty = Collections.emptySet();
        KNOWN_DATA.add(new KnownClassData(Factory.class.getName(), true, false, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(Context.class.getName(), true, false, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(ErrorService.class.getName(), true, false, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(Singleton.class.getName(), false, true, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(PerLookup.class.getName(), false, true, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(Named.class.getName(), false, false, true, null, empty));
        KNOWN_DATA.add(new KnownClassData(Contract.class.getName(), false, false, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(CONFIGURED_CONTRACT, true, false, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(Scope.class.getName(), false, false, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(Target.class.getName(), false, false, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(Retention.class.getName(), false, false, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(Proxiable.class.getName(), false, false, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(Annotation.class.getName(), false, false, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(Qualifier.class.getName(), false, false, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(Documented.class.getName(), false, false, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(Inherited.class.getName(), false, false, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(ContractsProvided.class.getName(), false, false, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(Rank.class.getName(), false, false, false, null, empty));
        KNOWN_DATA.add(new KnownClassData(Metadata.class.getName(), false, false, false, null, empty));
    }

    private static class KnownClassData {
        private final String clazz;
        private final boolean isa_contract;
        private final boolean isa_scope;
        private final boolean isa_qualifier;
        private final String superclass;
        private final Set<String> iFaces;

        private KnownClassData(String clazz, boolean isa_contract, boolean isa_scope, boolean isa_qualifier, String superclass, Set<String> iFaces) {
            this.clazz = clazz;
            this.isa_contract = isa_contract;
            this.isa_scope = isa_scope;
            this.isa_qualifier = isa_qualifier;
            this.superclass = superclass;
            this.iFaces = iFaces;
        }

        String getClazz() {
            return this.clazz;
        }

        boolean isIsa_contract() {
            return this.isa_contract;
        }

        boolean isIsa_scope() {
            return this.isa_scope;
        }

        boolean isIsa_qualifier() {
            return this.isa_qualifier;
        }

        String getSuperclass() {
            return this.superclass;
        }

        Set<String> getiFaces() {
            return this.iFaces;
        }
    }

    private static class GeneratorNameFinderMethodVisitor
    extends AbstractMethodVisitorImpl {
        private final String methodName;
        private final GeneratorClassVisitor parent;

        private GeneratorNameFinderMethodVisitor(GeneratorClassVisitor parent, String methodName) {
            this.parent = parent;
            this.methodName = methodName;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (Utilities.GENERATOR_NAME_FIELD_WITH_SLASHES.equals(desc)) {
                this.parent.setNameMethodName(this.methodName);
            }
            return null;
        }

        @Override
        public void visitEnd() {
        }
    }

    private static class GenerateServiceFromMethodVisitor
    extends AbstractAnnotationVisitorImpl {
        private final GeneratorClassVisitor parent;
        private String implementation;
        private String scope = PerLookup.class.getName();
        private final HashSet<String> contracts = new HashSet();

        private GenerateServiceFromMethodVisitor(GeneratorClassVisitor parent) {
            this.parent = parent;
        }

        @Override
        public void visit(String name, Object value) {
            if (name == null) {
                this.contracts.add((String)value);
            } else if (Utilities.GENERATOR_IMPL_NAME.equals(name)) {
                this.implementation = (String)value;
            } else if (Utilities.GENERATOR_SCOPE_NAME.equals(name)) {
                this.scope = (String)value;
            }
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            return this;
        }

        @Override
        public void visitEnd() {
            this.parent.setGenerateMethodAnnotationData(new GenerateMethodAnnotationData(this.implementation, this.contracts, this.scope));
        }
    }

    private class GeneratorClassVisitor
    extends AbstractClassVisitorImpl {
        private final String cacheKey;
        private GenerateMethodAnnotationData methodGenerateData = null;

        private GeneratorClassVisitor(String cacheKey) {
            this.cacheKey = cacheKey;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean arg1) {
            if (desc.equals(Utilities.METHOD_GENERATOR_WITH_SLASHES)) {
                return new GenerateServiceFromMethodVisitor(this);
            }
            return null;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.methodGenerateData == null) {
                return null;
            }
            return new GeneratorNameFinderMethodVisitor(this, name);
        }

        private void setGenerateMethodAnnotationData(GenerateMethodAnnotationData methodGenerateData) {
            this.methodGenerateData = methodGenerateData;
        }

        private GenerateMethodAnnotationData getGenerateMethodAnnotationData() {
            return this.methodGenerateData;
        }

        private void setNameMethodName(String methodName) {
            this.methodGenerateData.setNameMethodName(methodName);
        }

        @Override
        public void visitEnd() {
            Utilities.this.FOUND_GENERATORS.put(this.cacheKey, this.methodGenerateData);
        }
    }

    private static class MetadataAnnotationVisitor
    extends AbstractAnnotationVisitorImpl {
        private final ContractMethodVisitor parent;

        private MetadataAnnotationVisitor(ContractMethodVisitor parent) {
            this.parent = parent;
        }

        @Override
        public void visit(String name, Object value) {
            this.parent.setMetadataKey((String)value);
        }
    }

    private static class ContractMethodVisitor
    extends AbstractMethodVisitorImpl {
        private final ContractClassVisitor parent;
        private final String methodName;
        private String metadataKey;

        private ContractMethodVisitor(ContractClassVisitor parent, String methodName) {
            this.parent = parent;
            this.methodName = methodName;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (!Utilities.METADATA_DESC.equals(desc)) {
                return null;
            }
            return new MetadataAnnotationVisitor(this);
        }

        @Override
        public void visitEnd() {
            if (this.metadataKey != null) {
                this.parent.associateMethodNameWithMetadataKey(this.methodName, this.metadataKey);
            }
        }

        private void setMetadataKey(String key) {
            this.metadataKey = key;
        }
    }

    private class ContractClassVisitor
    extends AbstractClassVisitorImpl {
        private final String cacheKey;
        private final String lookForMe;
        private final File searchHere;
        private final Map<String, String> methodNameToMetadataKey = new HashMap<String, String>();
        private boolean isLookedFor = false;
        private boolean isContract = false;
        private boolean isScope = false;
        private boolean isQualifier = false;
        private String dotDelimitedSuperclass;

        private ContractClassVisitor(File searchHere, String lookForMe, String cacheKey) {
            this.searchHere = searchHere;
            this.lookForMe = lookForMe;
            this.cacheKey = cacheKey;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (!Utilities.this.FOUND_INTERFACES.containsKey(this.cacheKey)) {
                LinkedHashSet<String> iFaces = new LinkedHashSet<String>();
                for (String iFace : interfaces) {
                    String iWithDots = iFace.replace('/', '.');
                    iFaces.add(iWithDots);
                    Utilities.this.getSuperclass(this.searchHere, iWithDots);
                }
                Utilities.this.FOUND_INTERFACES.put(this.cacheKey, iFaces);
            }
            if (superName == null) {
                Utilities.this.FOUND_SUPERCLASS.put(this.cacheKey, null);
                return;
            }
            this.dotDelimitedSuperclass = superName.replace('/', '.');
            if (Object.class.getName().equals(this.dotDelimitedSuperclass)) {
                this.dotDelimitedSuperclass = null;
            }
            Utilities.this.FOUND_SUPERCLASS.put(this.cacheKey, this.dotDelimitedSuperclass);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean arg1) {
            if (this.lookForMe != null && desc.equals(this.lookForMe)) {
                this.isLookedFor = true;
            }
            if (desc.equals(CONTRACT_WITH_SLASHES)) {
                this.isContract = true;
            }
            if (desc.equals(SCOPE_WITH_SLASHES)) {
                this.isScope = true;
            }
            if (desc.equals(QUALIFIER_WITH_SLASHES)) {
                this.isQualifier = true;
            }
            if (desc.equals(QUALIFIER_WITH_SLASHES)) {
                this.isQualifier = true;
            }
            return null;
        }

        @Override
        public MethodVisitor visitMethod(int arg0, String name, String arg2, String arg3, String[] arg4) {
            return new ContractMethodVisitor(this, name);
        }

        @Override
        public void visitEnd() {
            Utilities.this.ISA_CONTRACT.put(this.cacheKey, this.isContract);
            Utilities.this.ISA_SCOPE.put(this.cacheKey, this.isScope);
            Utilities.this.ISA_QUALIFIER.put(this.cacheKey, this.isQualifier);
            if ((this.isScope || this.isQualifier) && !this.methodNameToMetadataKey.isEmpty()) {
                Utilities.this.METADATA.put(this.cacheKey, this.methodNameToMetadataKey);
            }
        }

        private boolean isALookedForThing() {
            return this.isLookedFor;
        }

        private String getDotDelimitedSuperclass() {
            return this.dotDelimitedSuperclass;
        }

        private void associateMethodNameWithMetadataKey(String methodName, String metadataKey) {
            this.methodNameToMetadataKey.put(methodName, metadataKey);
        }
    }
}

