/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.extras.provides;

import jakarta.inject.Inject;
import jakarta.inject.Scope;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.ContractIndicator;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationListener;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.Self;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.extras.provides.InjectUtils;
import org.glassfish.hk2.extras.provides.Provides;
import org.glassfish.hk2.extras.provides.ProvidesDescriptor;
import org.glassfish.hk2.extras.provides.TypeUtils;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.glassfish.hk2.utilities.reflection.TypeChecker;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Optional;

@Singleton
public class ProvidesListener
implements DynamicConfigurationListener {
    private final ServiceLocator locator;
    private final ProvidersSeen seen = new ProvidersSeen();
    private static final Object UNIQUE = new Object(){};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject
    public ProvidesListener(ServiceLocator locator) {
        this.locator = Objects.requireNonNull(locator);
        Object object = UNIQUE;
        synchronized (object) {
            if (locator.getService(UNIQUE.getClass(), new Annotation[0]) != null) {
                throw new IllegalStateException("There is already a " + this.getClass().getSimpleName() + " registered with this locator");
            }
            ServiceLocatorUtilities.addOneConstant((ServiceLocator)locator, (Object)UNIQUE);
        }
    }

    protected Filter getFilter() {
        return any -> true;
    }

    protected void onInvalidProvidesAnnotation(ActiveDescriptor<?> providerDescriptor, Provides providesAnnotation, AnnotatedElement annotatedElement, String message) {
        Objects.requireNonNull(providerDescriptor);
        Objects.requireNonNull(providesAnnotation);
        Objects.requireNonNull(annotatedElement);
        Objects.requireNonNull(message);
    }

    public void configurationChanged() {
        Filter filter = this.getFilter();
        LinkedHashSet providers = new LinkedHashSet();
        for (ActiveDescriptor provider : this.locator.getDescriptors(filter)) {
            providers.add(this.locator.reifyDescriptor((Descriptor)provider));
        }
        this.seen.retainAll(providers);
        DynamicConfigurationService configurationService = (DynamicConfigurationService)this.locator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration configuration = configurationService.createDynamicConfiguration();
        int added = 0;
        for (ActiveDescriptor activeDescriptor : providers) {
            added += this.addDescriptors(activeDescriptor, Collections.emptySet(), configuration);
        }
        if (added > 0) {
            configuration.commit();
        }
    }

    private int addDescriptors(ActiveDescriptor<?> providerDescriptor, Set<Class<?>> ancestors, DynamicConfiguration configuration) {
        Type providedType;
        Class<?> providedClass;
        Provides providesAnnotation;
        Objects.requireNonNull(providerDescriptor);
        Objects.requireNonNull(ancestors);
        Objects.requireNonNull(configuration);
        if (!this.seen.add(providerDescriptor)) {
            return 0;
        }
        ArrayList<ActiveDescriptor> added = new ArrayList<ActiveDescriptor>();
        Class providerClass = providerDescriptor.getImplementationClass();
        Type providerType = providerDescriptor.getImplementationType();
        block0: for (Method method : providerClass.getMethods()) {
            providesAnnotation = method.getAnnotation(Provides.class);
            if (providesAnnotation == null || !this.seen.add(providerDescriptor, method)) continue;
            providedClass = method.getReturnType();
            if (!Modifier.isStatic(method.getModifiers()) && (providedClass == providerClass || ancestors.contains(providedClass))) {
                this.onInvalidProvidesAnnotation(providerDescriptor, providesAnnotation, method, "@" + Provides.class.getSimpleName() + " method would form an infinite loop of providers.\n\tMethod: " + method + "\n\tClasses in loop: " + Stream.concat(ancestors.stream(), Stream.of(providerClass, providedClass)).map(c -> c.getName()).collect(Collectors.joining(" -> ")) + "\n");
                continue;
            }
            providedType = TypeUtils.resolveType(providerType, method.getGenericReturnType());
            if (TypeUtils.containsTypeVariable(providedType)) {
                this.onInvalidProvidesAnnotation(providerDescriptor, providesAnnotation, method, "@" + Provides.class.getSimpleName() + " method return type contains an unresolvable type variable.\n\tMethod: " + method + "\n\tMethod owner type: " + providerType.getTypeName() + "\n\tDeclared method return type: " + method.getGenericReturnType() + "\n\tResolved method return type: " + providedType.getTypeName() + "\n");
                continue;
            }
            Parameter[] parameters = method.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter = parameters[i];
                Type parameterType = TypeUtils.resolveType(providerType, parameter.getParameterizedType());
                if (!TypeUtils.containsTypeVariable(parameterType)) continue;
                this.onInvalidProvidesAnnotation(providerDescriptor, providesAnnotation, method, "@" + Provides.class.getSimpleName() + " method parameter type contains an unresolvable type variable.\n\tMethod: " + method + "\n\tMethod owner type: " + providerType.getTypeName() + "\n\tParameter index: " + i + "\n\tDeclared parameter type: " + parameter.getParameterizedType() + "\n\tResolved parameter type: " + parameterType + "\n");
                continue block0;
            }
            Set<Type> contracts = ProvidesListener.getContracts(providesAnnotation, providedType);
            Annotation scopeAnnotation = ProvidesListener.getScopeAnnotation(providerDescriptor, method, contracts);
            AtomicReference self = new AtomicReference();
            Function<ServiceHandle<?>, Object> createFunction = Modifier.isStatic(method.getModifiers()) ? ProvidesListener.getCreateFunctionFromStaticMethod(method, providerType, self, this.locator) : ProvidesListener.getCreateFunctionFromInstanceMethod(method, providerType, providerDescriptor, self, this.locator);
            Consumer<Object> disposeFunction = ProvidesListener.getDisposeFunction(providerDescriptor, providesAnnotation, method, providedClass, providedType, providerClass, providerType, self, this.locator);
            if (disposeFunction == null) {
                this.onInvalidProvidesAnnotation(providerDescriptor, providesAnnotation, method, "@" + Provides.class.getSimpleName() + " method specifies an invalid dispose method.\n\tMethod: " + method + "\n\tMethod owner type: " + providerType.getTypeName() + "\n\tDispose method: " + providesAnnotation.disposeMethod() + "\n\tDisposal handled by: " + providesAnnotation.disposalHandledBy() + "\n\tPossible causes:\n\t\tThere is no method with the specified name.\n\t\tThe specified method is not public.\n\t\tDisposal is handled by the provided instance and...\n\t\t\tthe specified method is static.\n\t\t\tthe specified method does not have zero parameters.\n\t\tDisposal is handled by the provider and...\n\t\t\tthe specified method does not have at least one parameter.\n\t\t\tone of the method parameter types contains an unresolved type variable.\n\t\t\tthe type of the first parameter is not a supertype of the provided service.\n\t\t\tmore than one method matches the specifications.\n");
                continue;
            }
            ActiveDescriptor newDescriptor = configuration.addActiveDescriptor(new ProvidesDescriptor<Object>(method, providedClass, providedType, contracts, scopeAnnotation, createFunction, disposeFunction));
            self.set(newDescriptor);
            added.add(newDescriptor);
        }
        for (AccessibleObject accessibleObject : providerClass.getFields()) {
            providesAnnotation = ((Field)accessibleObject).getAnnotation(Provides.class);
            if (providesAnnotation == null || !this.seen.add(providerDescriptor, (Member)((Object)accessibleObject))) continue;
            providedClass = ((Field)accessibleObject).getType();
            if (!Modifier.isStatic(((Field)accessibleObject).getModifiers()) && (providedClass == providerClass || ancestors.contains(providedClass))) {
                this.onInvalidProvidesAnnotation(providerDescriptor, providesAnnotation, accessibleObject, "@" + Provides.class.getSimpleName() + " field would form an infinite loop of providers.\n\tField: " + (Field)accessibleObject + "\n\tClasses in loop: " + Stream.concat(ancestors.stream(), Stream.of(providerClass, providedClass)).map(c -> c.getName()).collect(Collectors.joining(" -> ")) + "\n");
                continue;
            }
            providedType = TypeUtils.resolveType(providerType, ((Field)accessibleObject).getGenericType());
            if (TypeUtils.containsTypeVariable(providedType)) {
                this.onInvalidProvidesAnnotation(providerDescriptor, providesAnnotation, accessibleObject, "@" + Provides.class.getSimpleName() + " field type contains an unresolvable type variable.\n\tField: " + (Field)accessibleObject + "\n\tField owner type: " + providerType.getTypeName() + "\n\tDeclared field type: " + ((Field)accessibleObject).getGenericType().getTypeName() + "\n\tResolved field type: " + providedType.getTypeName() + "\n");
                continue;
            }
            Set<Type> contracts = ProvidesListener.getContracts(providesAnnotation, providedType);
            Annotation scopeAnnotation = ProvidesListener.getScopeAnnotation(providerDescriptor, accessibleObject, contracts);
            Function<ServiceHandle<?>, Object> createFunction = Modifier.isStatic(((Field)accessibleObject).getModifiers()) ? ProvidesListener.getCreateFunctionFromStaticField((Field)accessibleObject, this.locator) : ProvidesListener.getCreateFunctionFromInstanceField(providerDescriptor, (Field)accessibleObject, this.locator);
            Consumer<Object> disposeFunction = instance -> {};
            ActiveDescriptor newDescriptor = configuration.addActiveDescriptor(new ProvidesDescriptor<Object>(accessibleObject, providedClass, providedType, contracts, scopeAnnotation, createFunction, disposeFunction));
            added.add(newDescriptor);
        }
        if (added.isEmpty()) {
            return 0;
        }
        int addedCount = added.size();
        LinkedHashSet newAncestors = new LinkedHashSet(ancestors);
        newAncestors.add(providerClass);
        for (ActiveDescriptor activeDescriptor : added) {
            addedCount += this.addDescriptors(activeDescriptor, newAncestors, configuration);
        }
        return addedCount;
    }

    private static Set<Type> getContracts(Provides providesAnnotation, Type providedType) {
        Objects.requireNonNull(providesAnnotation);
        Objects.requireNonNull(providedType);
        if (providesAnnotation.contracts().length > 0) {
            return Arrays.stream(providesAnnotation.contracts()).collect(Collectors.collectingAndThen(Collectors.toSet(), set -> Collections.unmodifiableSet(set)));
        }
        Class rawClass = ReflectionHelper.getRawClass((Type)providedType);
        if (rawClass == null) {
            return Collections.singleton(providedType);
        }
        ContractsProvided explicit = rawClass.getAnnotation(ContractsProvided.class);
        if (explicit != null) {
            return Arrays.stream(explicit.value()).collect(Collectors.collectingAndThen(Collectors.toSet(), set -> Collections.unmodifiableSet(set)));
        }
        return Stream.concat(Stream.of(providedType), ReflectionHelper.getAllTypes((Type)providedType).stream().filter(t -> ProvidesListener.isContract(t))).collect(Collectors.collectingAndThen(Collectors.toSet(), set -> Collections.unmodifiableSet(set)));
    }

    private static boolean isContract(Type type) {
        Objects.requireNonNull(type);
        Class rawClass = ReflectionHelper.getRawClass((Type)type);
        if (rawClass == null) {
            return false;
        }
        if (rawClass.isAnnotationPresent(Contract.class)) {
            return true;
        }
        for (Annotation annotation : rawClass.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(ContractIndicator.class)) continue;
            return true;
        }
        return false;
    }

    private static <T extends AccessibleObject> Annotation getScopeAnnotation(ActiveDescriptor<?> providerDescriptor, T providerMethodOrField, Set<Type> providedContracts) {
        Annotation providerScopeAnnotation;
        Objects.requireNonNull(providerDescriptor);
        Objects.requireNonNull(providerMethodOrField);
        Objects.requireNonNull(providedContracts);
        for (Annotation annotation : providerMethodOrField.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(Scope.class)) continue;
            return annotation;
        }
        for (Type contract : providedContracts) {
            Class rawClass = ReflectionHelper.getRawClass((Type)contract);
            if (rawClass == null) continue;
            for (Annotation annotation : rawClass.getAnnotations()) {
                if (!annotation.annotationType().isAnnotationPresent(Scope.class)) continue;
                return annotation;
            }
        }
        if (!Modifier.isStatic(((Member)((Object)providerMethodOrField)).getModifiers()) && (providerScopeAnnotation = providerDescriptor.getScopeAsAnnotation()) != null) {
            return providerScopeAnnotation;
        }
        return ServiceLocatorUtilities.getPerLookupAnnotation();
    }

    private static Function<ServiceHandle<?>, Object> getCreateFunctionFromStaticMethod(Method method, Type providerType, AtomicReference<ActiveDescriptor<?>> self, ServiceLocator locator) {
        Objects.requireNonNull(method);
        Objects.requireNonNull(providerType);
        Objects.requireNonNull(self);
        Objects.requireNonNull(locator);
        return root -> {
            Object provided;
            Object[] arguments = Arrays.stream(method.getParameters()).map(parameter -> {
                if (ProvidesListener.isSelf(parameter)) {
                    return self.get();
                }
                return InjectUtils.serviceFromParameter(parameter, providerType, root, locator);
            }).toArray(Object[]::new);
            if (!ProvidesListener.canAccess(method, null)) {
                method.setAccessible(true);
            }
            try {
                provided = method.invoke(null, arguments);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new MultiException((Throwable)e);
            }
            return provided;
        };
    }

    private static Function<ServiceHandle<?>, Object> getCreateFunctionFromInstanceMethod(Method method, Type providerType, ActiveDescriptor<?> providerDescriptor, AtomicReference<ActiveDescriptor<?>> self, ServiceLocator locator) {
        Objects.requireNonNull(providerDescriptor);
        Objects.requireNonNull(providerType);
        Objects.requireNonNull(method);
        Objects.requireNonNull(self);
        Objects.requireNonNull(locator);
        return root -> {
            Object provided;
            Object[] arguments = Arrays.stream(method.getParameters()).map(parameter -> {
                if (ProvidesListener.isSelf(parameter)) {
                    return self.get();
                }
                return InjectUtils.serviceFromParameter(parameter, providerType, root, locator);
            }).toArray(Object[]::new);
            Object provider = locator.getService(providerDescriptor, root, null);
            Objects.requireNonNull(provider);
            if (!ProvidesListener.canAccess(method, provider)) {
                method.setAccessible(true);
            }
            try {
                provided = method.invoke(provider, arguments);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new MultiException((Throwable)e);
            }
            return provided;
        };
    }

    private static Function<ServiceHandle<?>, Object> getCreateFunctionFromStaticField(Field field, ServiceLocator locator) {
        Objects.requireNonNull(field);
        Objects.requireNonNull(locator);
        return root -> {
            Object provided;
            if (!ProvidesListener.canAccess(field, null)) {
                field.setAccessible(true);
            }
            try {
                provided = field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new MultiException((Throwable)e);
            }
            return provided;
        };
    }

    private static Function<ServiceHandle<?>, Object> getCreateFunctionFromInstanceField(ActiveDescriptor<?> providerDescriptor, Field field, ServiceLocator locator) {
        Objects.requireNonNull(providerDescriptor);
        Objects.requireNonNull(field);
        Objects.requireNonNull(locator);
        return root -> {
            Object provided;
            Object provider = locator.getService(providerDescriptor, root, null);
            Objects.requireNonNull(provider);
            if (!ProvidesListener.canAccess(field, provider)) {
                field.setAccessible(true);
            }
            try {
                provided = field.get(provider);
            }
            catch (IllegalAccessException e) {
                throw new MultiException((Throwable)e);
            }
            return provided;
        };
    }

    private static <T extends AccessibleObject> Consumer<Object> getDisposeFunction(ActiveDescriptor<?> providerDescriptor, Provides providesAnnotation, Method providerMethod, Class<?> providedClass, Type providedType, Class<?> providerClass, Type providerType, AtomicReference<ActiveDescriptor<?>> self, ServiceLocator locator) {
        Objects.requireNonNull(providerDescriptor);
        Objects.requireNonNull(providesAnnotation);
        Objects.requireNonNull(providerMethod);
        Objects.requireNonNull(providedClass);
        Objects.requireNonNull(providedType);
        Objects.requireNonNull(providerClass);
        Objects.requireNonNull(providerType);
        Objects.requireNonNull(self);
        Objects.requireNonNull(locator);
        if (providesAnnotation.disposeMethod().isEmpty()) {
            return instance -> {
                if (instance != null) {
                    locator.preDestroy(instance);
                }
            };
        }
        switch (providesAnnotation.disposalHandledBy()) {
            case PROVIDED_INSTANCE: {
                Method disposeMethod = Arrays.stream(providedClass.getMethods()).filter(method -> method.getName().equals(providesAnnotation.disposeMethod())).filter(method -> !Modifier.isStatic(method.getModifiers())).filter(method -> method.getParameterCount() == 0).findAny().orElse(null);
                if (disposeMethod == null) {
                    return null;
                }
                return instance -> {
                    if (instance == null) {
                        return;
                    }
                    if (!ProvidesListener.canAccess(disposeMethod, instance)) {
                        disposeMethod.setAccessible(true);
                    }
                    try {
                        disposeMethod.invoke(instance, new Object[0]);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new MultiException((Throwable)e);
                    }
                };
            }
            case PROVIDER: {
                Set disposeMethods = Arrays.stream(providerClass.getMethods()).filter(method -> method.getName().equals(providesAnnotation.disposeMethod())).filter(method -> method.getParameterCount() >= 1).filter(method -> {
                    int indexOfArgumentToDispose = 0;
                    Parameter[] parameters = method.getParameters();
                    for (int i = 0; i < parameters.length; ++i) {
                        Parameter parameter = parameters[i];
                        Type parameterType = TypeUtils.resolveType(providerType, parameter.getParameterizedType());
                        if (i == indexOfArgumentToDispose && !TypeChecker.isRawTypeSafe((Type)parameterType, (Type)providedType)) {
                            return false;
                        }
                        if (!TypeUtils.containsTypeVariable(parameterType)) continue;
                        return false;
                    }
                    return true;
                }).collect(Collectors.collectingAndThen(Collectors.toSet(), set -> Collections.unmodifiableSet(set)));
                if (disposeMethods.size() != 1) {
                    return null;
                }
                Method disposeMethod = (Method)disposeMethods.iterator().next();
                return instance -> {
                    if (instance == null) {
                        return;
                    }
                    ArrayList<Object> perLookupHandles = new ArrayList<Object>();
                    try {
                        int indexOfArgumentToDispose = 0;
                        Parameter[] parameters = disposeMethod.getParameters();
                        Object[] arguments = new Object[parameters.length];
                        for (int i = 0; i < parameters.length; ++i) {
                            if (i == indexOfArgumentToDispose) {
                                arguments[i] = instance;
                                continue;
                            }
                            if (ProvidesListener.isSelf(parameters[i])) {
                                arguments[i] = self.get();
                                continue;
                            }
                            ServiceHandle<?> serviceHandle = InjectUtils.serviceHandleFromParameter(parameters[i], providerType, locator);
                            if (serviceHandle == null) {
                                arguments[i] = null;
                                continue;
                            }
                            if (ProvidesListener.isPerLookup(serviceHandle)) {
                                perLookupHandles.add(serviceHandle);
                            }
                            arguments[i] = serviceHandle.getService();
                        }
                        if (Modifier.isStatic(disposeMethod.getModifiers())) {
                            if (!ProvidesListener.canAccess(disposeMethod, null)) {
                                disposeMethod.setAccessible(true);
                            }
                            try {
                                disposeMethod.invoke(null, arguments);
                            }
                            catch (IllegalAccessException | InvocationTargetException e) {
                                throw new MultiException((Throwable)e);
                            }
                            return;
                        }
                        ServiceHandle providerHandle = locator.getServiceHandle(providerDescriptor);
                        if (ProvidesListener.isPerLookup(providerHandle)) {
                            perLookupHandles.add(providerHandle);
                        }
                        Object object = providerHandle.getService();
                        Objects.requireNonNull(object);
                        if (!ProvidesListener.canAccess(disposeMethod, object)) {
                            disposeMethod.setAccessible(true);
                        }
                        try {
                            disposeMethod.invoke(object, arguments);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new MultiException((Throwable)e);
                        }
                    }
                    finally {
                        for (ServiceHandle serviceHandle : perLookupHandles) {
                            serviceHandle.close();
                        }
                    }
                };
            }
        }
        throw new AssertionError((Object)("Unknown " + Provides.DisposalHandledBy.class.getSimpleName() + " value: " + providesAnnotation.disposalHandledBy()));
    }

    private static boolean isPerLookup(ServiceHandle<?> handle) {
        Objects.requireNonNull(handle);
        return handle.getActiveDescriptor().getScopeAnnotation() == PerLookup.class;
    }

    private static boolean isSelf(Parameter parameter) {
        Objects.requireNonNull(parameter);
        return parameter.isAnnotationPresent(Self.class) && parameter.getType() == ActiveDescriptor.class && !parameter.isAnnotationPresent(Optional.class) && Arrays.stream(parameter.getAnnotations()).noneMatch(annotation -> ReflectionHelper.isAnnotationAQualifier((Annotation)annotation));
    }

    private static <T extends AccessibleObject> boolean canAccess(T member, Object receiver) {
        Objects.requireNonNull(member);
        if (Modifier.isStatic(((Member)((Object)member)).getModifiers()) ? receiver != null : !((Member)((Object)member)).getDeclaringClass().isInstance(receiver)) {
            throw new IllegalArgumentException();
        }
        boolean result = member.isAccessible();
        return result;
    }

    private static final class ProvidersSeen {
        private final Set<CacheKey> cache = ConcurrentHashMap.newKeySet();

        private ProvidersSeen() {
        }

        void retainAll(Set<ActiveDescriptor<?>> providers) {
            Objects.requireNonNull(providers);
            this.cache.removeIf(key -> key.provider != null && !providers.contains(key.provider));
        }

        boolean add(ActiveDescriptor<?> provider) {
            Objects.requireNonNull(provider);
            CacheKey key = new CacheKey(provider, null);
            return this.cache.add(key);
        }

        boolean add(ActiveDescriptor<?> provider, Member methodOrField) {
            Objects.requireNonNull(provider);
            Objects.requireNonNull(methodOrField);
            CacheKey key = Modifier.isStatic(methodOrField.getModifiers()) ? new CacheKey(null, methodOrField) : new CacheKey(provider, methodOrField);
            return this.cache.add(key);
        }

        private static final class CacheKey {
            private final ActiveDescriptor<?> provider;
            private final Member methodOrField;

            CacheKey(ActiveDescriptor<?> provider, Member methodOrField) {
                this.provider = provider;
                this.methodOrField = methodOrField;
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof CacheKey)) {
                    return false;
                }
                CacheKey that = (CacheKey)object;
                return Objects.equals(this.provider, that.provider) && Objects.equals(this.methodOrField, that.methodOrField);
            }

            public int hashCode() {
                int hash = 1;
                hash = 31 * hash + Objects.hashCode(this.provider);
                hash = 31 * hash + Objects.hashCode(this.methodOrField);
                return hash;
            }
        }
    }
}

