/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.extras.hk2bridge.internal;

import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationListener;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.Visibility;
import org.glassfish.hk2.extras.hk2bridge.internal.CrossOverDescriptor;

@Singleton
@Visibility(value=DescriptorVisibility.LOCAL)
public class Hk2BridgeImpl
implements DynamicConfigurationListener {
    private final ServiceLocator local;
    private ServiceLocator remote;
    private Filter filter;
    private List<ActiveDescriptor<?>> mirroredDescriptors = new ArrayList();
    private static final List<Long> EMPTY_LIST = Collections.emptyList();

    @Inject
    private Hk2BridgeImpl(ServiceLocator local) {
        this.local = local;
    }

    public synchronized void setRemote(ServiceLocator remote) {
        this.remote = remote;
        this.filter = new NoLocalNoRemoteFilter(remote.getLocatorId());
        List newDescriptors = this.local.getDescriptors(this.filter);
        this.handleChange(newDescriptors);
    }

    private synchronized void handleChange(List<ActiveDescriptor<?>> newDescriptors) {
        if (this.remote == null) {
            return;
        }
        HashSet toRemove = new HashSet(this.mirroredDescriptors);
        toRemove.removeAll(newDescriptors);
        HashSet toAdd = new HashSet(newDescriptors);
        toAdd.removeAll(this.mirroredDescriptors);
        DynamicConfigurationService remoteDCS = (DynamicConfigurationService)this.remote.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration config = remoteDCS.createDynamicConfiguration();
        boolean dirty = false;
        for (ActiveDescriptor<?> activeDescriptor : toRemove) {
            RemoveFilter removeFilter = new RemoveFilter(activeDescriptor.getLocatorId(), activeDescriptor.getServiceId());
            config.addUnbindFilter((Filter)removeFilter);
            dirty = true;
        }
        for (ActiveDescriptor<?> activeDescriptor : toAdd) {
            CrossOverDescriptor cod = new CrossOverDescriptor(this.local, activeDescriptor);
            config.addActiveDescriptor(cod);
            dirty = true;
        }
        if (dirty) {
            config.commit();
        }
        this.mirroredDescriptors = newDescriptors;
    }

    public void configurationChanged() {
        List newDescriptors = this.local.getDescriptors(this.filter);
        this.handleChange(newDescriptors);
    }

    @PreDestroy
    private void preDestroy() {
        this.handleChange(Collections.emptyList());
    }

    private static Set<Long> getMetadataLongsSet(Descriptor d, String field) {
        HashSet<Long> retVal = new HashSet<Long>();
        List metadataValues = (List)d.getMetadata().get(field);
        if (metadataValues == null) {
            return retVal;
        }
        for (String metadataValue : metadataValues) {
            try {
                Long val = new Long(metadataValue);
                retVal.add(val);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return retVal;
    }

    private static List<Long> getMetadataLongsList(Descriptor d, String field) {
        List metadataValues = (List)d.getMetadata().get(field);
        if (metadataValues == null) {
            return EMPTY_LIST;
        }
        ArrayList<Long> retVal = new ArrayList<Long>(metadataValues.size());
        for (String metadataValue : metadataValues) {
            try {
                Long val = new Long(metadataValue);
                retVal.add(val);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return retVal;
    }

    private static class NoLocalNoRemoteFilter
    implements Filter {
        private final long remoteLocatorId;

        private NoLocalNoRemoteFilter(long remoteId) {
            this.remoteLocatorId = remoteId;
        }

        public boolean matches(Descriptor d) {
            if (DescriptorVisibility.LOCAL.equals((Object)d.getDescriptorVisibility())) {
                return false;
            }
            Set<Long> previousVisits = Hk2BridgeImpl.getMetadataLongsSet(d, "org.jvnet.hk2.hk2bridge.locator.id");
            return !previousVisits.contains(new Long(this.remoteLocatorId));
        }
    }

    private static class RemoveFilter
    implements Filter {
        private final long localLocatorId;
        private final long localServiceId;

        private RemoveFilter(long localLocatorId, long localServiceId) {
            this.localLocatorId = localLocatorId;
            this.localServiceId = localServiceId;
        }

        public boolean matches(Descriptor d) {
            List<Long> locatorIds = Hk2BridgeImpl.getMetadataLongsList(d, "org.jvnet.hk2.hk2bridge.locator.id");
            int index = -1;
            int lcv = 0;
            for (Long locatorId : locatorIds) {
                if (this.localLocatorId == locatorId) {
                    index = lcv;
                    break;
                }
                ++lcv;
            }
            if (index == -1) {
                return false;
            }
            List<Long> serviceIds = Hk2BridgeImpl.getMetadataLongsList(d, "org.jvnet.hk2.hk2bridge.service.id");
            Long serviceId = serviceIds.get(index);
            return serviceId == this.localServiceId;
        }
    }
}

