/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.extras.provides;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.Self;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.Unqualified;
import org.glassfish.hk2.api.UnsatisfiedDependencyException;
import org.glassfish.hk2.extras.provides.TypeUtils;
import org.glassfish.hk2.utilities.InjecteeImpl;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.jvnet.hk2.annotations.Optional;

final class InjectUtils {
    private InjectUtils() {
        throw new AssertionError((Object)"This class cannot be instantiated");
    }

    static Injectee injecteeFromParameter(Parameter parameter, Type parentType) {
        Objects.requireNonNull(parameter);
        Objects.requireNonNull(parentType);
        Executable parent = parameter.getDeclaringExecutable();
        int index = Arrays.asList(parent.getParameters()).indexOf(parameter);
        if (index == -1) {
            throw new AssertionError((Object)("parameter " + parameter + " not found in parent " + parent));
        }
        Type parameterType = TypeUtils.resolveType(parentType, parameter.getParameterizedType());
        InjecteeImpl injectee = new InjecteeImpl(parameterType);
        injectee.setParent((AnnotatedElement)parent);
        injectee.setPosition(index);
        LinkedHashSet<Annotation> qualifiers = new LinkedHashSet<Annotation>();
        for (Annotation annotation : parameter.getAnnotations()) {
            if (ReflectionHelper.isAnnotationAQualifier((Annotation)annotation)) {
                qualifiers.add(annotation);
                continue;
            }
            if (annotation.annotationType() == Optional.class) {
                injectee.setOptional(true);
                continue;
            }
            if (annotation.annotationType() == Self.class) {
                injectee.setSelf(true);
                continue;
            }
            if (annotation.annotationType() != Unqualified.class) continue;
            injectee.setUnqualified((Unqualified)annotation);
        }
        injectee.setRequiredQualifiers(Collections.unmodifiableSet(qualifiers));
        return injectee;
    }

    static ServiceHandle<?> serviceHandleFromParameter(Parameter parameter, Type parentType, ServiceLocator locator) {
        Objects.requireNonNull(parameter);
        Objects.requireNonNull(parentType);
        Objects.requireNonNull(locator);
        Injectee injectee = InjectUtils.injecteeFromParameter(parameter, parentType);
        ActiveDescriptor activeDescriptor = locator.getInjecteeDescriptor(injectee);
        if (activeDescriptor == null) {
            if (!injectee.isOptional()) {
                throw new UnsatisfiedDependencyException(injectee);
            }
            return null;
        }
        return locator.getServiceHandle(activeDescriptor, injectee);
    }

    static Object serviceFromParameter(Parameter parameter, Type parentType, ServiceHandle<?> root, ServiceLocator locator) {
        Objects.requireNonNull(parameter);
        Objects.requireNonNull(parentType);
        Objects.requireNonNull(locator);
        Injectee injectee = InjectUtils.injecteeFromParameter(parameter, parentType);
        ActiveDescriptor activeDescriptor = locator.getInjecteeDescriptor(injectee);
        if (activeDescriptor == null) {
            if (!injectee.isOptional()) {
                throw new UnsatisfiedDependencyException(injectee);
            }
            return null;
        }
        return locator.getService(activeDescriptor, root, injectee);
    }
}

