/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.extras.operation;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.extras.operation.internal.OperationHandleImpl;
import org.glassfish.hk2.extras.operation.internal.SingleOperationManager;
import org.glassfish.hk2.utilities.reflection.Logger;
import org.jvnet.hk2.annotations.Contract;

@Contract
public abstract class OperationContext<T extends Annotation>
implements Context<T> {
    private SingleOperationManager<T> manager;
    private final HashMap<OperationHandleImpl<T>, LinkedHashMap<ActiveDescriptor<?>, Object>> operationMap = new HashMap();
    private final HashSet<ActiveDescriptor<?>> creating = new HashSet();
    private final HashMap<Long, LinkedList<OperationHandleImpl<T>>> closingOperations = new HashMap();
    private boolean shuttingDown = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <U> U findOrCreate(ActiveDescriptor<U> activeDescriptor, ServiceHandle<?> root) {
        LinkedHashMap<Object, Object> serviceMap;
        boolean closingOperation;
        LinkedList<OperationHandleImpl<T>> closingOperationStack;
        SingleOperationManager<T> localManager;
        OperationContext operationContext = this;
        synchronized (operationContext) {
            localManager = this.manager;
            closingOperationStack = this.closingOperations.get(Thread.currentThread().getId());
            closingOperation = closingOperationStack != null && !closingOperationStack.isEmpty();
        }
        if (localManager == null) {
            throw new IllegalStateException("There is no manager for " + this.getScope().getName() + " on thread " + Thread.currentThread().getId());
        }
        OperationHandleImpl<T> operation = localManager.getCurrentOperationOnThisThread();
        if (operation == null) {
            OperationContext operationContext2 = this;
            synchronized (operationContext2) {
                if (!closingOperation) {
                    throw new IllegalStateException("There is no current operation of type " + this.getScope().getName() + " on thread " + Thread.currentThread().getId());
                }
                operation = closingOperationStack.get(0);
            }
        }
        OperationContext operationContext3 = this;
        synchronized (operationContext3) {
            Object retVal;
            serviceMap = this.operationMap.get(operation);
            if (serviceMap == null) {
                if (closingOperation || this.shuttingDown) {
                    throw new IllegalStateException("The operation " + operation.getIdentifier() + " is closing.  A new instance of " + activeDescriptor + " cannot be created");
                }
                serviceMap = new LinkedHashMap();
                this.operationMap.put(operation, serviceMap);
            }
            if ((retVal = serviceMap.get(activeDescriptor)) != null) {
                return (U)retVal;
            }
            if (this.supportsNullCreation() && serviceMap.containsKey(activeDescriptor)) {
                return null;
            }
            if (closingOperation || this.shuttingDown) {
                throw new IllegalStateException("The operation " + operation.getIdentifier() + " is closing.  A new instance of " + activeDescriptor + " cannot be created after searching existing descriptors");
            }
            while (this.creating.contains(activeDescriptor)) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            retVal = serviceMap.get(activeDescriptor);
            if (retVal != null) {
                return (U)retVal;
            }
            if (this.supportsNullCreation() && serviceMap.containsKey(activeDescriptor)) {
                return null;
            }
            this.creating.add(activeDescriptor);
        }
        Object retVal = null;
        boolean success = false;
        try {
            retVal = activeDescriptor.create(root);
            if (retVal == null && !this.supportsNullCreation()) {
                throw new IllegalArgumentException("The operation for context " + this.getScope().getName() + " does not support null creation, but descriptor " + activeDescriptor + " returned null");
            }
            success = true;
        }
        finally {
            OperationContext operationContext4 = this;
            synchronized (operationContext4) {
                if (success) {
                    serviceMap.put(activeDescriptor, retVal);
                }
                this.creating.remove(activeDescriptor);
                this.notifyAll();
            }
        }
        return (U)retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(ActiveDescriptor<?> descriptor) {
        SingleOperationManager<T> localManager;
        OperationContext operationContext = this;
        synchronized (operationContext) {
            localManager = this.manager;
        }
        if (localManager == null) {
            return false;
        }
        OperationHandleImpl<T> operation = localManager.getCurrentOperationOnThisThread();
        if (operation == null) {
            return false;
        }
        OperationContext operationContext2 = this;
        synchronized (operationContext2) {
            HashMap serviceMap = this.operationMap.get(operation);
            if (serviceMap == null) {
                return false;
            }
            return serviceMap.containsKey(descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyOne(ActiveDescriptor<?> descriptor) {
        OperationContext operationContext = this;
        synchronized (operationContext) {
            for (HashMap hashMap : this.operationMap.values()) {
                Object killMe = hashMap.remove(descriptor);
                if (killMe == null) continue;
                descriptor.dispose(killMe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeOperation(OperationHandleImpl<T> operation) {
        HashMap serviceMap;
        LinkedList<OperationHandleImpl<Object>> stack;
        long tid = Thread.currentThread().getId();
        OperationContext operationContext = this;
        synchronized (operationContext) {
            stack = this.closingOperations.get(tid);
            if (stack == null) {
                stack = new LinkedList();
                this.closingOperations.put(tid, stack);
            }
            stack.addFirst(operation);
            serviceMap = this.operationMap.get(operation);
        }
        try {
            if (serviceMap == null) {
                return;
            }
            LinkedList destructionList = new LinkedList();
            for (Map.Entry entry : serviceMap.entrySet()) {
                destructionList.addFirst(entry);
            }
            for (Map.Entry entry : destructionList) {
                ActiveDescriptor desc = (ActiveDescriptor)entry.getKey();
                Object value = entry.getValue();
                try {
                    desc.dispose(value);
                }
                catch (Throwable th) {
                    Logger.getLogger().debug(this.getClass().getName(), "closeOperation", th);
                }
            }
        }
        finally {
            operationContext = this;
            synchronized (operationContext) {
                this.operationMap.remove(operation);
                stack.removeFirst();
                if (stack.isEmpty()) {
                    this.closingOperations.remove(tid);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Set<OperationHandleImpl<T>> toShutDown;
        OperationContext operationContext = this;
        synchronized (operationContext) {
            this.shuttingDown = true;
            toShutDown = this.operationMap.keySet();
        }
        try {
            for (OperationHandleImpl<T> shutDown : toShutDown) {
                shutDown.closeOperation();
            }
        }
        finally {
            operationContext = this;
            synchronized (operationContext) {
                this.operationMap.clear();
            }
        }
    }

    public boolean supportsNullCreation() {
        return false;
    }

    public boolean isActive() {
        return true;
    }

    public synchronized void setOperationManager(SingleOperationManager<T> manager) {
        this.manager = manager;
    }

    public String toString() {
        return "OperationContext(" + this.getScope().getName() + "," + System.identityHashCode(this) + ")";
    }
}

