/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.extras.operation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.extras.operation.OperationIdentifier;
import org.glassfish.hk2.extras.operation.internal.OperationHandleImpl;
import org.glassfish.hk2.extras.operation.internal.SingleOperationManager;
import org.jvnet.hk2.annotations.Contract;

@Contract
public abstract class OperationContext<T>
implements Context<T> {
    private SingleOperationManager manager;
    private final HashMap<OperationIdentifier, HashMap<ActiveDescriptor<?>, Object>> operationMap = new HashMap();
    private final HashSet<ActiveDescriptor<?>> creating = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <U> U findOrCreate(ActiveDescriptor<U> activeDescriptor, ServiceHandle<?> root) {
        HashMap<Object, Object> serviceMap;
        OperationHandleImpl operation = this.manager.getCurrentOperationOnThisThread();
        if (operation == null) {
            throw new IllegalStateException("There is no current operation of type " + this.getScope().getName() + " on thread " + Thread.currentThread().getId());
        }
        OperationContext operationContext = this;
        synchronized (operationContext) {
            Object retVal;
            serviceMap = this.operationMap.get(operation.getIdentifier());
            if (serviceMap == null) {
                serviceMap = new HashMap();
                this.operationMap.put(operation.getIdentifier(), serviceMap);
            }
            if ((retVal = serviceMap.get(activeDescriptor)) != null) {
                return (U)retVal;
            }
            if (this.supportsNullCreation() && serviceMap.containsKey(activeDescriptor)) {
                return null;
            }
            while (this.creating.contains(activeDescriptor)) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            retVal = serviceMap.get(activeDescriptor);
            if (retVal != null) {
                return (U)retVal;
            }
            if (this.supportsNullCreation() && serviceMap.containsKey(activeDescriptor)) {
                return null;
            }
            this.creating.add(activeDescriptor);
        }
        Object retVal = null;
        boolean success = false;
        try {
            retVal = activeDescriptor.create(root);
            if (retVal == null && !this.supportsNullCreation()) {
                throw new IllegalArgumentException("The operation for context " + this.getScope().getName() + " does not support null creation, but descriptor " + activeDescriptor + " returned null");
            }
            success = true;
        }
        finally {
            OperationContext operationContext2 = this;
            synchronized (operationContext2) {
                if (success) {
                    serviceMap.put(activeDescriptor, retVal);
                }
                this.creating.remove(activeDescriptor);
                this.notifyAll();
            }
        }
        return (U)retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(ActiveDescriptor<?> descriptor) {
        OperationHandleImpl operation = this.manager.getCurrentOperationOnThisThread();
        if (operation == null) {
            return false;
        }
        OperationContext operationContext = this;
        synchronized (operationContext) {
            HashMap<ActiveDescriptor<?>, Object> serviceMap = this.operationMap.get(operation.getIdentifier());
            if (serviceMap == null) {
                return false;
            }
            return serviceMap.containsKey(descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyOne(ActiveDescriptor<?> descriptor) {
        OperationContext operationContext = this;
        synchronized (operationContext) {
            for (HashMap<ActiveDescriptor<?>, Object> serviceMap : this.operationMap.values()) {
                Object killMe = serviceMap.remove(descriptor);
                if (killMe == null) continue;
                descriptor.dispose(killMe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        OperationContext operationContext = this;
        synchronized (operationContext) {
            for (HashMap<ActiveDescriptor<?>, Object> serviceMap : this.operationMap.values()) {
                for (Map.Entry<ActiveDescriptor<?>, Object> entry : serviceMap.entrySet()) {
                    ActiveDescriptor<?> descriptor = entry.getKey();
                    Object killMe = entry.getValue();
                    if (killMe == null) continue;
                    descriptor.dispose(killMe);
                }
            }
            this.operationMap.clear();
        }
    }

    public boolean supportsNullCreation() {
        return false;
    }

    public boolean isActive() {
        return true;
    }

    public void setOperationManager(SingleOperationManager manager) {
        this.manager = manager;
    }

    public String toString() {
        return "OperationContext(" + this.getScope().getName() + "," + System.identityHashCode(this) + ")";
    }
}

