/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.extras;

import java.lang.annotation.Annotation;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.extras.hk2bridge.internal.Hk2BridgeImpl;
import org.glassfish.hk2.extras.interception.internal.DefaultInterceptionService;
import org.glassfish.hk2.extras.operation.internal.OperationManagerImpl;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.DescriptorImpl;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;

public class ExtrasUtilities {
    public static final String HK2BRIDGE_LOCATOR_ID = "org.jvnet.hk2.hk2bridge.locator.id";
    public static final String HK2BRIDGE_SERVICE_ID = "org.jvnet.hk2.hk2bridge.service.id";
    private static final String BRIDGE_NAME_PREFIX = "LocatorBridge(";
    private static final String COMMA = ",";
    private static final String BRIDGE_NAME_POSTFIX = ")";

    public static void enableDefaultInterceptorServiceImplementation(ServiceLocator locator) {
        if (locator.getBestDescriptor((Filter)BuilderHelper.createContractFilter((String)DefaultInterceptionService.class.getName())) == null) {
            ServiceLocatorUtilities.addClasses((ServiceLocator)locator, (Class[])new Class[]{DefaultInterceptionService.class});
        }
    }

    public static void enableOperations(ServiceLocator locator) {
        if (locator.getBestDescriptor((Filter)BuilderHelper.createContractFilter((String)OperationManagerImpl.class.getName())) != null) {
            return;
        }
        ServiceLocatorUtilities.addClasses((ServiceLocator)locator, (Class[])new Class[]{OperationManagerImpl.class});
    }

    private static String getBridgeName(ServiceLocator into, ServiceLocator from) {
        return BRIDGE_NAME_PREFIX + from.getLocatorId() + COMMA + into.getLocatorId() + BRIDGE_NAME_POSTFIX;
    }

    private static void checkParentage(ServiceLocator a, ServiceLocator b) {
        ServiceLocator originalA = a;
        while (a != null) {
            if (a.getLocatorId() == b.getLocatorId()) {
                throw new IllegalStateException("Locator " + originalA + " is a child of or is the same as locator " + b);
            }
            a = a.getParent();
        }
    }

    public static void bridgeServiceLocator(ServiceLocator into, ServiceLocator from) {
        ExtrasUtilities.checkParentage(into, from);
        ExtrasUtilities.checkParentage(from, into);
        String bridgeName = ExtrasUtilities.getBridgeName(into, from);
        if (from.getService(Hk2BridgeImpl.class, bridgeName, new Annotation[0]) != null) {
            throw new IllegalStateException("There is already a bridge from locator " + from.getName() + " to " + into.getName());
        }
        DescriptorImpl di = BuilderHelper.createDescriptorFromClass(Hk2BridgeImpl.class);
        di.setName(bridgeName);
        ServiceLocatorUtilities.addOneDescriptor((ServiceLocator)from, (Descriptor)di);
        Hk2BridgeImpl bridge = (Hk2BridgeImpl)from.getService(Hk2BridgeImpl.class, bridgeName, new Annotation[0]);
        bridge.setRemote(into);
    }

    public static void unbridgeServiceLocator(ServiceLocator into, ServiceLocator from) {
        ExtrasUtilities.checkParentage(into, from);
        ExtrasUtilities.checkParentage(from, into);
        String bridgeName = ExtrasUtilities.getBridgeName(into, from);
        ServiceHandle handle = from.getServiceHandle(Hk2BridgeImpl.class, bridgeName, new Annotation[0]);
        if (handle == null) {
            return;
        }
        handle.destroy();
        ServiceLocatorUtilities.removeFilter((ServiceLocator)from, (Filter)BuilderHelper.createNameAndContractFilter((String)Hk2BridgeImpl.class.getName(), (String)bridgeName));
    }

    public static void enableTopicDistribution(ServiceLocator locator) {
        ServiceLocatorUtilities.enableTopicDistribution((ServiceLocator)locator);
    }
}

