/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.apiscan.classfile;

import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFile;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFileLoader;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClosureCompilerImplBase;
import com.sun.enterprise.tools.verifier.apiscan.classfile.Method;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;

public class BCELClosureCompilerImpl
extends ClosureCompilerImplBase {
    private Stack<ClassFile> callStack = new Stack();
    private HashSet<String> closure = new HashSet();
    private HashSet<String> nativeMethods = new HashSet();
    private Map<String, List<String>> failed = new HashMap<String, List<String>>();
    private static final String myClassName = "BCELClosureCompilerImpl";

    public BCELClosureCompilerImpl(ClassFileLoader loader) {
        super(loader);
    }

    @Override
    public boolean buildClosure(String className) {
        ClassFile cf;
        logger.entering(myClassName, "buildClosure", className);
        if (!this.needToBuildClosure(className)) {
            return true;
        }
        try {
            cf = this.loader.load(className);
        }
        catch (IOException e) {
            this.handleFailure(className);
            return false;
        }
        return this.buildClosure(cf);
    }

    private boolean buildClosure(ClassFile cf) {
        boolean result = true;
        this.callStack.push(cf);
        if (this.needToBuildClosure(cf.getName())) {
            this.visitedClasses.add(cf.getName());
            Collection<String> names = cf.getAllReferencedClassNames();
            this.closure.addAll(names);
            for (Method method : cf.getMethods()) {
                if (!method.isNative()) continue;
                String methodDesc = method.getOwningClass().getName() + "." + method.getName();
                this.nativeMethods.add(methodDesc);
            }
            for (String string : names) {
                ClassFile next;
                if (!this.needToBuildClosure(string)) continue;
                try {
                    next = this.loader.load(string);
                }
                catch (IOException e) {
                    result = false;
                    this.handleFailure(string);
                    continue;
                }
                boolean newresult = this.buildClosure(next);
                result = newresult && result;
            }
        }
        this.callStack.pop();
        return result;
    }

    private void handleFailure(String referencedClass) {
        String referencingPath = "";
        try {
            StringBuilder referencingPathBuffer = new StringBuilder();
            Iterator i = this.callStack.iterator();
            while (i.hasNext()) {
                if (referencingPathBuffer.length() != 0) {
                    referencingPathBuffer.append(File.separator);
                }
                referencingPathBuffer.append(((ClassFile)i.next()).getName());
            }
            referencingPath = referencingPathBuffer.toString();
        }
        catch (EmptyStackException referencingPathBuffer) {
            // empty catch block
        }
        logger.finer("Could not locate " + referencingPath + File.separator + referencedClass);
        List<String> failedList = this.failed.get(referencingPath);
        if (failedList == null) {
            failedList = new ArrayList<String>();
            this.failed.put(referencingPath, failedList);
        }
        failedList.add(referencedClass);
    }

    @Override
    public Collection getClosure() {
        return Collections.unmodifiableCollection(this.closure);
    }

    @Override
    public Map getFailed() {
        return Collections.unmodifiableMap(this.failed);
    }

    @Override
    public void reset() {
        this.closure.clear();
        this.visitedClasses.clear();
        this.failed.clear();
        this.nativeMethods.clear();
    }

    @Override
    public Collection<String> getNativeMethods() {
        return Collections.unmodifiableCollection(this.nativeMethods);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (logger.isLoggable(Level.FINER)) {
            sb.append("\n<Closure>");
            sb.append("\n\t<ExcludedClasses>");
            Iterator<Object> i = this.excludedClasses.iterator();
            while (i.hasNext()) {
                sb.append("\n\t\t");
                sb.append((String)((Object)i.next()));
            }
            sb.append("\n\t</ExcludedClasses>");
            sb.append("\n\t<ExcludedPackages>");
            i = this.excludedPackages.iterator();
            while (i.hasNext()) {
                sb.append("\n\t\t");
                sb.append((String)((Object)i.next()));
            }
            sb.append("\n\t</ExcludedPackages>");
            sb.append("\n\t<ExcludedPatterns>");
            i = this.excludedPatterns.iterator();
            while (i.hasNext()) {
                sb.append("\n\t\t");
                sb.append((String)((Object)i.next()));
            }
            sb.append("\n\t</ExcludedPatterns>");
            sb.append("\n\t<Classes>");
            i = this.closure.iterator();
            while (i.hasNext()) {
                sb.append("\n\t\t");
                sb.append((String)i.next());
            }
            sb.append("\n\t</Classes>");
        }
        sb.append("\n\t<Failed>");
        for (Map.Entry<String, List<String>> referencingPathToFailedList : this.failed.entrySet()) {
            sb.append("\n\t\t");
            sb.append("<ReferencingPath>");
            sb.append("\n\t\t\t");
            sb.append((Object)referencingPathToFailedList.getKey());
            sb.append("\n\t\t");
            sb.append("</ReferencingPath>");
            sb.append("\n\t\t");
            sb.append("<Classes>");
            Iterator<String> iii = referencingPathToFailedList.getValue().iterator();
            while (iii.hasNext()) {
                sb.append("\n\t\t\t");
                sb.append(iii.next());
            }
            sb.append("\n\t\t");
            sb.append("</Classes>");
        }
        sb.append("\n\t</Failed>");
        sb.append("\n\t<NativeMethods>");
        for (String s : this.nativeMethods) {
            sb.append("\n\t\t");
            sb.append(s);
        }
        sb.append("\n\t</NativeMethods>");
        if (logger.isLoggable(Level.FINER)) {
            sb.append("\n</Closure>");
        }
        return sb.toString();
    }
}

