/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.configuration.internal;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.Visibility;
import org.glassfish.hk2.configuration.api.Configured;
import org.glassfish.hk2.configuration.internal.BeanInfo;
import org.glassfish.hk2.configuration.internal.BeanUtilities;
import org.glassfish.hk2.configuration.internal.ConfiguredByContext;

@Singleton
@Visibility(value=DescriptorVisibility.LOCAL)
public class ConfiguredByInjectionResolver
implements InjectionResolver<Configured> {
    @Inject
    @Named(value="SystemInjectResolver")
    private InjectionResolver<Inject> systemResolver;
    @Inject
    private ConfiguredByContext context;
    private final ReentrantLock lock = new ReentrantLock();
    private final ConcurrentHashMap<ActiveDescriptor<?>, BeanInfo> beanMap = new ConcurrentHashMap();

    private static String getParameterNameFromConstructor(Constructor<?> cnst, int position) {
        Annotation[] paramAnnotations = cnst.getParameterAnnotations()[position];
        Configured c = null;
        for (Annotation anno : paramAnnotations) {
            if (!Configured.class.equals(anno.annotationType())) continue;
            c = (Configured)anno;
            break;
        }
        if (c == null) {
            return null;
        }
        String key = c.value();
        if (BeanUtilities.isEmpty(key)) {
            throw new AssertionError((Object)("Not enough in @Configured annotation in constructor " + cnst + " at parameter index " + position));
        }
        return key;
    }

    private static String getParameterNameFromMethod(Method method, int position) {
        Annotation[] paramAnnotations = method.getParameterAnnotations()[position];
        Configured c = null;
        for (Annotation anno : paramAnnotations) {
            if (!Configured.class.equals(anno.annotationType())) continue;
            c = (Configured)anno;
            break;
        }
        if (c == null) {
            return null;
        }
        String key = c.value();
        if (BeanUtilities.isEmpty(key)) {
            throw new AssertionError((Object)("Not enough in @Configured annotation in method " + method + " at parameter index " + position));
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object resolve(Injectee injectee, ServiceHandle<?> root) {
        this.lock.lock();
        try {
            ActiveDescriptor injecteeParent = injectee.getInjecteeDescriptor();
            if (injecteeParent == null) {
                Object object = this.systemResolver.resolve(injectee, root);
                return object;
            }
            AnnotatedElement ae = injectee.getParent();
            if (ae == null) {
                Object object = this.systemResolver.resolve(injectee, root);
                return object;
            }
            String parameterName = null;
            if (ae instanceof Field) {
                parameterName = BeanUtilities.getParameterNameFromField((Field)ae, false);
            } else if (ae instanceof Constructor) {
                parameterName = ConfiguredByInjectionResolver.getParameterNameFromConstructor((Constructor)ae, injectee.getPosition());
            } else if (ae instanceof Method) {
                parameterName = ConfiguredByInjectionResolver.getParameterNameFromMethod((Method)ae, injectee.getPosition());
            } else {
                Object object = this.systemResolver.resolve(injectee, root);
                return object;
            }
            if (parameterName == null) {
                Object object = this.systemResolver.resolve(injectee, root);
                return object;
            }
            ActiveDescriptor<?> workingOn = this.context.getWorkingOn();
            if (workingOn == null) {
                Object object = this.systemResolver.resolve(injectee, root);
                return object;
            }
            BeanInfo beanInfo = this.beanMap.get(workingOn);
            if (beanInfo == null) {
                throw new IllegalStateException("Could not find a configuration bean for " + injectee + " with descriptor " + workingOn);
            }
            Object object = BeanUtilities.getBeanPropertyValue(injectee.getRequiredType(), parameterName, beanInfo);
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isConstructorParameterIndicator() {
        return true;
    }

    public boolean isMethodParameterIndicator() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BeanInfo addBean(ActiveDescriptor<?> descriptor, Object bean, String type, Object metadata) {
        this.lock.lock();
        try {
            BeanInfo retVal = new BeanInfo(type, descriptor.getName(), bean, metadata);
            this.beanMap.put(descriptor, retVal);
            BeanInfo beanInfo = retVal;
            return beanInfo;
        }
        finally {
            this.lock.unlock();
        }
    }

    void removeBean(ActiveDescriptor<?> descriptor) {
        this.lock.lock();
        try {
            this.beanMap.remove(descriptor);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return "ConfiguredByInjectionResolver(" + System.identityHashCode(this) + ")";
    }
}

