/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.configuration.internal;

import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.Visibility;
import org.glassfish.hk2.configuration.api.ConfiguredBy;

@Singleton
@Visibility(value=DescriptorVisibility.LOCAL)
public class ConfiguredByContext
implements Context<ConfiguredBy> {
    private static final ThreadLocal<ActiveDescriptor<?>> workingOn = ThreadLocal.withInitial(() -> null);
    private final ReentrantLock lock = new ReentrantLock();
    private final Map<ActiveDescriptor<?>, Object> db = new HashMap();

    public Class<? extends Annotation> getScope() {
        return ConfiguredBy.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <U> U findOrCreate(ActiveDescriptor<U> activeDescriptor, ServiceHandle<?> root) {
        ActiveDescriptor<?> previousValue = workingOn.get();
        workingOn.set(activeDescriptor);
        try {
            U u = this.internalFindOrCreate(activeDescriptor, root);
            return u;
        }
        finally {
            workingOn.set(previousValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <U> U internalFindOrCreate(ActiveDescriptor<U> activeDescriptor, ServiceHandle<?> root) {
        this.lock.lock();
        try {
            Object retVal = this.db.get(activeDescriptor);
            if (retVal != null) {
                Object object = retVal;
                return (U)object;
            }
            if (activeDescriptor.getName() == null) {
                throw new MultiException((Throwable)new IllegalStateException("ConfiguredBy services without names are templates and cannot be created directly"));
            }
            retVal = activeDescriptor.create(root);
            this.db.put(activeDescriptor, retVal);
            Object object = retVal;
            return (U)object;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean containsKey(ActiveDescriptor<?> descriptor) {
        this.lock.lock();
        try {
            boolean bl = this.db.containsKey(descriptor);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void destroyOne(ActiveDescriptor<?> descriptor) {
        this.lock.lock();
        try {
            Object destroyMe = this.db.remove(descriptor);
            if (destroyMe == null) {
                return;
            }
            descriptor.dispose(destroyMe);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean supportsNullCreation() {
        return false;
    }

    public boolean isActive() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.lock.lock();
        try {
            HashSet activeDescriptors = new HashSet(this.db.keySet());
            for (ActiveDescriptor activeDescriptor : activeDescriptors) {
                this.destroyOne(activeDescriptor);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    ActiveDescriptor<?> getWorkingOn() {
        return workingOn.get();
    }

    Object findOnly(ActiveDescriptor<?> descriptor) {
        this.lock.lock();
        try {
            Object object = this.db.get(descriptor);
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }
}

