/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.configuration.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.Visibility;
import org.glassfish.hk2.configuration.api.Configured;
import org.glassfish.hk2.configuration.internal.BeanInfo;
import org.glassfish.hk2.configuration.internal.BeanUtilities;
import org.glassfish.hk2.configuration.internal.ConfiguredByContext;

@Singleton
@Visibility(value=DescriptorVisibility.LOCAL)
public class ConfiguredByInjectionResolver
implements InjectionResolver<Configured> {
    @Inject
    @Named(value="SystemInjectResolver")
    private InjectionResolver<Inject> systemResolver;
    @Inject
    private ConfiguredByContext context;
    private final ConcurrentHashMap<ActiveDescriptor<?>, BeanInfo> beanMap = new ConcurrentHashMap();

    private static String getParameterNameFromConstructor(Constructor<?> cnst, int position) {
        Annotation[] paramAnnotations = cnst.getParameterAnnotations()[position];
        Configured c = null;
        for (Annotation anno : paramAnnotations) {
            if (!Configured.class.equals(anno.annotationType())) continue;
            c = (Configured)anno;
            break;
        }
        if (c == null) {
            return null;
        }
        String key = c.value();
        if (BeanUtilities.isEmpty(key)) {
            throw new AssertionError((Object)("Not enough in @Configured annotation in constructor " + cnst + " at parameter index " + position));
        }
        return key;
    }

    private static String getParameterNameFromMethod(Method method, int position) {
        Annotation[] paramAnnotations = method.getParameterAnnotations()[position];
        Configured c = null;
        for (Annotation anno : paramAnnotations) {
            if (!Configured.class.equals(anno.annotationType())) continue;
            c = (Configured)anno;
            break;
        }
        if (c == null) {
            return null;
        }
        String key = c.value();
        if (BeanUtilities.isEmpty(key)) {
            throw new AssertionError((Object)("Not enough in @Configured annotation in method " + method + " at parameter index " + position));
        }
        return key;
    }

    public synchronized Object resolve(Injectee injectee, ServiceHandle<?> root) {
        ActiveDescriptor injecteeParent = injectee.getInjecteeDescriptor();
        if (injecteeParent == null) {
            return this.systemResolver.resolve(injectee, root);
        }
        AnnotatedElement ae = injectee.getParent();
        if (ae == null) {
            return this.systemResolver.resolve(injectee, root);
        }
        String parameterName = null;
        if (ae instanceof Field) {
            parameterName = BeanUtilities.getParameterNameFromField((Field)ae, false);
        } else if (ae instanceof Constructor) {
            parameterName = ConfiguredByInjectionResolver.getParameterNameFromConstructor((Constructor)ae, injectee.getPosition());
        } else if (ae instanceof Method) {
            parameterName = ConfiguredByInjectionResolver.getParameterNameFromMethod((Method)ae, injectee.getPosition());
        } else {
            return this.systemResolver.resolve(injectee, root);
        }
        if (parameterName == null) {
            return this.systemResolver.resolve(injectee, root);
        }
        ActiveDescriptor<?> workingOn = this.context.getWorkingOn();
        if (workingOn == null) {
            return this.systemResolver.resolve(injectee, root);
        }
        BeanInfo beanInfo = this.beanMap.get(workingOn);
        if (beanInfo == null) {
            throw new IllegalStateException("Could not find a configuration bean for " + injectee + " with descriptor " + workingOn);
        }
        return BeanUtilities.getBeanPropertyValue(injectee.getRequiredType(), parameterName, beanInfo);
    }

    public boolean isConstructorParameterIndicator() {
        return true;
    }

    public boolean isMethodParameterIndicator() {
        return true;
    }

    synchronized BeanInfo addBean(ActiveDescriptor<?> descriptor, Object bean, String type, Object metadata) {
        BeanInfo retVal = new BeanInfo(type, descriptor.getName(), bean, metadata);
        this.beanMap.put(descriptor, retVal);
        return retVal;
    }

    synchronized void removeBean(ActiveDescriptor<?> descriptor) {
        this.beanMap.remove(descriptor);
    }

    public String toString() {
        return "ConfiguredByInjectionResolver(" + System.identityHashCode(this) + ")";
    }
}

