/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.configuration.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.api.ChildInject;
import org.glassfish.hk2.configuration.api.ChildIterable;
import org.glassfish.hk2.configuration.internal.ChildFilter;
import org.glassfish.hk2.configuration.internal.ChildIterableImpl;
import org.glassfish.hk2.configuration.internal.ConfiguredByContext;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;

@Singleton
public class ChildInjectResolverImpl
implements InjectionResolver<ChildInject> {
    @Inject
    private ServiceLocator locator;
    @Inject
    private InjectionResolver<Inject> systemResolver;
    @Inject
    private ConfiguredByContext configuredByContext;

    public Object resolve(Injectee injectee, ServiceHandle<?> root) {
        ActiveDescriptor<?> parentDescriptor = injectee.getInjecteeDescriptor();
        if (parentDescriptor == null) {
            return this.systemResolver.resolve(injectee, root);
        }
        parentDescriptor = this.configuredByContext.getWorkingOn();
        if (parentDescriptor == null) {
            return this.systemResolver.resolve(injectee, root);
        }
        Type requiredType = injectee.getRequiredType();
        Class requiredClass = ReflectionHelper.getRawClass((Type)requiredType);
        if (requiredClass == null) {
            return this.systemResolver.resolve(injectee, root);
        }
        ChildInject childInject = ChildInjectResolverImpl.getInjectionAnnotation(injectee.getParent(), injectee.getPosition());
        String prefixName = parentDescriptor.getName();
        if (prefixName == null) {
            prefixName = "";
        }
        String separator = childInject.separator();
        prefixName = prefixName + childInject.value();
        if (ChildIterable.class.equals((Object)requiredClass) && requiredType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)requiredType;
            requiredClass = ReflectionHelper.getRawClass((Type)(requiredType = pt.getActualTypeArguments()[0]));
            if (requiredClass == null) {
                return this.systemResolver.resolve(injectee, root);
            }
            return new ChildIterableImpl(this.locator, requiredType, prefixName, separator);
        }
        List matches = this.locator.getDescriptors((Filter)new ChildFilter(requiredType, prefixName));
        if (matches.isEmpty()) {
            if (injectee.isOptional()) {
                return null;
            }
            throw new IllegalStateException("Could not find a child injection point for " + injectee);
        }
        return this.locator.getServiceHandle((ActiveDescriptor)matches.get(0)).getService();
    }

    private static ChildInject getInjectionAnnotation(AnnotatedElement element, int position) {
        Annotation[] annotations;
        if (element instanceof Field) {
            Field field = (Field)element;
            return field.getAnnotation(ChildInject.class);
        }
        if (element instanceof Constructor) {
            Constructor constructor = (Constructor)element;
            annotations = constructor.getParameterAnnotations()[position];
        } else if (element instanceof Method) {
            Method method = (Method)element;
            annotations = method.getParameterAnnotations()[position];
        } else {
            throw new IllegalArgumentException();
        }
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(ChildInject.class)) continue;
            return (ChildInject)annotation;
        }
        throw new IllegalArgumentException();
    }

    public boolean isConstructorParameterIndicator() {
        return true;
    }

    public boolean isMethodParameterIndicator() {
        return true;
    }
}

