/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.configuration.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.DescriptorType;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.HK2Loader;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.utilities.NamedImpl;

public class DelegatingNamedActiveDescriptor
implements ActiveDescriptor<Object> {
    private final ActiveDescriptor<?> parent;
    private final Named name;
    private final HashSet<String> qualifierNames;
    private final HashSet<Annotation> qualifiers;
    private int ranking = 0;
    private Object lock = new Object();
    private Object cache;
    private boolean isSet = false;

    DelegatingNamedActiveDescriptor(ActiveDescriptor<?> parent, String name) {
        this.parent = parent;
        this.name = new NamedImpl(name);
        this.qualifierNames = new HashSet(parent.getQualifiers());
        this.qualifierNames.add(Named.class.getName());
        this.qualifiers = new HashSet(parent.getQualifierAnnotations());
        this.qualifiers.add((Annotation)this.name);
    }

    public String getImplementation() {
        return this.parent.getImplementation();
    }

    public Set<String> getAdvertisedContracts() {
        return this.parent.getAdvertisedContracts();
    }

    public String getScope() {
        return this.parent.getScope();
    }

    public String getName() {
        return this.name.value();
    }

    public Set<String> getQualifiers() {
        return this.qualifierNames;
    }

    public DescriptorType getDescriptorType() {
        return this.parent.getDescriptorType();
    }

    public DescriptorVisibility getDescriptorVisibility() {
        return this.parent.getDescriptorVisibility();
    }

    public Map<String, List<String>> getMetadata() {
        return this.parent.getMetadata();
    }

    public HK2Loader getLoader() {
        return this.parent.getLoader();
    }

    public int getRanking() {
        return this.ranking;
    }

    public int setRanking(int ranking) {
        int retVal = ranking;
        this.ranking = ranking;
        return retVal;
    }

    public Boolean isProxiable() {
        return this.parent.isProxiable();
    }

    public Boolean isProxyForSameScope() {
        return this.parent.isProxyForSameScope();
    }

    public String getClassAnalysisName() {
        return this.parent.getClassAnalysisName();
    }

    public Long getServiceId() {
        return null;
    }

    public Long getLocatorId() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCache() {
        Object object = this.lock;
        synchronized (object) {
            return this.cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCacheSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.isSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCache(Object cacheMe) {
        Object object = this.lock;
        synchronized (object) {
            this.isSet = true;
            this.cache = cacheMe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseCache() {
        Object object = this.lock;
        synchronized (object) {
            this.cache = null;
            this.isSet = false;
        }
    }

    public boolean isReified() {
        return this.parent.isReified();
    }

    public Class<?> getImplementationClass() {
        return this.parent.getImplementationClass();
    }

    public Set<Type> getContractTypes() {
        return this.parent.getContractTypes();
    }

    public Class<? extends Annotation> getScopeAnnotation() {
        return this.parent.getScopeAnnotation();
    }

    public Set<Annotation> getQualifierAnnotations() {
        return this.qualifiers;
    }

    public List<Injectee> getInjectees() {
        return this.parent.getInjectees();
    }

    public Long getFactoryServiceId() {
        return this.parent.getFactoryServiceId();
    }

    public Long getFactoryLocatorId() {
        return this.parent.getFactoryLocatorId();
    }

    public Object create(ServiceHandle<?> root) {
        return this.parent.create(root);
    }

    public void dispose(Object instance) {
        this.parent.dispose(instance);
    }
}

