/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.configuration.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.api.ConfiguredBy;
import org.glassfish.hk2.configuration.api.PostDynamicChange;
import org.glassfish.hk2.configuration.api.PreDynamicChange;
import org.glassfish.hk2.configuration.hub.api.BeanDatabase;
import org.glassfish.hk2.configuration.hub.api.BeanDatabaseUpdateListener;
import org.glassfish.hk2.configuration.hub.api.Change;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.Type;
import org.glassfish.hk2.configuration.internal.BeanInfo;
import org.glassfish.hk2.configuration.internal.BeanUtilities;
import org.glassfish.hk2.configuration.internal.ConfiguredByContext;
import org.glassfish.hk2.configuration.internal.ConfiguredByInjectionResolver;
import org.glassfish.hk2.configuration.internal.DelegatingNamedActiveDescriptor;
import org.glassfish.hk2.configuration.internal.NoNameTypeFilter;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.reflection.ClassReflectionHelper;
import org.glassfish.hk2.utilities.reflection.MethodWrapper;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.glassfish.hk2.utilities.reflection.internal.ClassReflectionHelperImpl;

@Singleton
public class ConfigurationListener
implements BeanDatabaseUpdateListener {
    @Inject
    private Hub hub;
    @Inject
    private ServiceLocator locator;
    @Inject
    private DynamicConfigurationService configurationService;
    @Inject
    private ConfiguredByInjectionResolver injectionResolver;
    @Inject
    private ConfiguredByContext context;
    private final Map<String, ModificationInformation> typeInformation = new HashMap<String, ModificationInformation>();

    @PostConstruct
    private void postConstruct() {
        this.hub.addListener((BeanDatabaseUpdateListener)this);
    }

    private ActiveDescriptor<?> addInstanceDescriptor(DynamicConfiguration config, ActiveDescriptor<?> parent, String name, String type, Object bean) {
        DelegatingNamedActiveDescriptor addMe = new DelegatingNamedActiveDescriptor(parent, name);
        ActiveDescriptor systemDescriptor = config.addActiveDescriptor((ActiveDescriptor)addMe);
        this.injectionResolver.addBean(systemDescriptor, bean, type);
        return systemDescriptor;
    }

    private boolean invokePreMethod(Object target, List<PropertyChangeEvent> changes, String typeName) {
        ModificationInformation modInfo = this.typeInformation.get(typeName);
        if (modInfo == null) {
            return true;
        }
        Method preMethod = modInfo.getPreDynamicChangeMethod(target.getClass());
        if (preMethod == null) {
            return true;
        }
        Class<?>[] params = preMethod.getParameterTypes();
        Object result = null;
        if (params.length <= 0) {
            try {
                result = ReflectionHelper.invoke((Object)target, (Method)preMethod, (Object[])new Object[0], (boolean)true);
            }
            catch (Throwable th) {
                return true;
            }
        } else if (params.length == 1) {
            if (!List.class.isAssignableFrom(params[0])) {
                return true;
            }
            Object[] pValues = new Object[]{Collections.unmodifiableList(changes)};
            try {
                result = ReflectionHelper.invoke((Object)target, (Method)preMethod, (Object[])pValues, (boolean)true);
            }
            catch (Throwable th) {
                return true;
            }
        } else {
            return true;
        }
        if (result == null || !(result instanceof Boolean)) {
            return true;
        }
        Boolean b = (Boolean)result;
        return b;
    }

    private void invokePostMethod(Object target, List<PropertyChangeEvent> changes, String typeName) {
        ModificationInformation modInfo = this.typeInformation.get(typeName);
        if (modInfo == null) {
            return;
        }
        Method postMethod = modInfo.getPostDynamicChangeMethod(target.getClass());
        if (postMethod == null) {
            return;
        }
        Class<?>[] params = postMethod.getParameterTypes();
        if (params.length <= 0) {
            try {
                ReflectionHelper.invoke((Object)target, (Method)postMethod, (Object[])new Object[0], (boolean)true);
            }
            finally {
                return;
            }
        }
        if (params.length == 1) {
            if (!List.class.isAssignableFrom(params[0])) {
                return;
            }
            Object[] pValues = new Object[]{Collections.unmodifiableList(changes)};
            try {
                ReflectionHelper.invoke((Object)target, (Method)postMethod, (Object[])pValues, (boolean)true);
            }
            catch (Throwable th) {
                return;
            }
        }
    }

    private void modifyInstanceDescriptor(ActiveDescriptor<?> parent, String name, Object bean, String typeName, List<PropertyChangeEvent> changes) {
        BeanInfo modifiedInfo = this.injectionResolver.addBean(parent, bean, typeName);
        Object target = this.context.findOnly(parent);
        if (target == null) {
            return;
        }
        boolean moveForward = this.invokePreMethod(target, changes, typeName);
        if (!moveForward) {
            return;
        }
        HashMap<String, PropertyChangeEvent> changedProperties = new HashMap<String, PropertyChangeEvent>();
        for (PropertyChangeEvent pce : changes) {
            changedProperties.put(pce.getPropertyName(), pce);
            if (!(target instanceof PropertyChangeListener)) continue;
            PropertyChangeListener listener = (PropertyChangeListener)target;
            try {
                listener.propertyChange(pce);
            }
            catch (Throwable throwable) {}
        }
        HashMap<Method, Object[]> dynamicMethods = new HashMap<Method, Object[]>();
        HashSet<Method> notDynamicMethods = new HashSet<Method>();
        for (Injectee injectee : parent.getInjectees()) {
            String propName;
            Method method;
            AnnotatedElement ae = injectee.getParent();
            if (ae == null) continue;
            if (ae instanceof Field) {
                PropertyChangeEvent pce;
                String propName2 = BeanUtilities.getParameterNameFromField((Field)ae, true);
                if (propName2 == null || (pce = (PropertyChangeEvent)changedProperties.get(propName2)) == null) continue;
                try {
                    ReflectionHelper.setField((Field)((Field)ae), (Object)target, (Object)pce.getNewValue());
                }
                catch (Throwable th) {}
                continue;
            }
            if (!(ae instanceof Method) || notDynamicMethods.contains(method = (Method)ae)) continue;
            if (!BeanUtilities.hasDynamicParameter(method)) {
                notDynamicMethods.add(method);
                continue;
            }
            Object[] params = (Object[])dynamicMethods.get(method);
            if (params == null) {
                params = new Object[method.getParameterTypes().length];
                dynamicMethods.put(method, params);
            }
            if ((propName = BeanUtilities.getParameterNameFromMethod(method, injectee.getPosition())) == null) {
                ActiveDescriptor paramDescriptor = this.locator.getInjecteeDescriptor(injectee);
                if (paramDescriptor == null) {
                    params[injectee.getPosition()] = null;
                    continue;
                }
                params[injectee.getPosition()] = this.locator.getServiceHandle(paramDescriptor).getService();
                continue;
            }
            PropertyChangeEvent pce = (PropertyChangeEvent)changedProperties.get(propName);
            if (pce != null) {
                params[injectee.getPosition()] = pce.getNewValue();
                continue;
            }
            params[injectee.getPosition()] = BeanUtilities.getBeanPropertyValue(propName, modifiedInfo);
        }
        for (Map.Entry entry : dynamicMethods.entrySet()) {
            try {
                ReflectionHelper.invoke((Object)target, (Method)((Method)entry.getKey()), (Object[])((Object[])entry.getValue()), (boolean)true);
            }
            catch (Throwable e) {}
        }
        this.invokePostMethod(target, changes, typeName);
    }

    public void initialize(BeanDatabase database) {
        Set allTypes = database.getAllTypes();
        LinkedList added = new LinkedList();
        DynamicConfiguration config = this.configurationService.createDynamicConfiguration();
        for (Type type : allTypes) {
            String typeName = type.getName();
            this.typeInformation.put(typeName, new ModificationInformation());
            List typeDescriptors = this.locator.getDescriptors((Filter)new NoNameTypeFilter(this.locator, typeName, null));
            for (ActiveDescriptor typeDescriptor : typeDescriptors) {
                Map typeInstances = type.getInstances();
                for (Map.Entry entry : typeInstances.entrySet()) {
                    added.add(this.addInstanceDescriptor(config, typeDescriptor, (String)entry.getKey(), typeName, entry.getValue()));
                }
            }
        }
        config.commit();
        for (ActiveDescriptor activeDescriptor : added) {
            if (!ConfigurationListener.isEager(activeDescriptor)) continue;
            ServiceHandle handle = this.locator.getServiceHandle(activeDescriptor);
            handle.getService();
        }
    }

    private static boolean isEager(ActiveDescriptor<?> descriptor) {
        Class implClass = descriptor.getImplementationClass();
        if (implClass == null) {
            return false;
        }
        ConfiguredBy configuredBy = implClass.getAnnotation(ConfiguredBy.class);
        if (configuredBy == null) {
            return false;
        }
        return ConfiguredBy.CreationPolicy.EAGER.equals((Object)configuredBy.creationPolicy());
    }

    public void databaseHasChanged(BeanDatabase newDatabase, List<Change> changes) {
        LinkedList added = new LinkedList();
        LinkedList<ActiveDescriptor> removed = new LinkedList<ActiveDescriptor>();
        DynamicConfiguration config = this.configurationService.createDynamicConfiguration();
        for (Change change : changes) {
            String addedInstanceKey;
            String typeName;
            if (Change.ChangeCategory.ADD_INSTANCE.equals((Object)change.getChangeCategory())) {
                typeName = change.getChangeType().getName();
                if (!this.typeInformation.containsKey(typeName)) {
                    this.typeInformation.put(typeName, new ModificationInformation());
                }
                String addedInstanceKey2 = change.getInstanceKey();
                Object addedInstanceBean = change.getInstanceValue();
                List typeDescriptors = this.locator.getDescriptors((Filter)new NoNameTypeFilter(this.locator, change.getChangeType().getName(), null));
                for (ActiveDescriptor typeDescriptor : typeDescriptors) {
                    added.add(this.addInstanceDescriptor(config, typeDescriptor, addedInstanceKey2, typeName, addedInstanceBean));
                }
                continue;
            }
            if (Change.ChangeCategory.MODIFY_INSTANCE.equals((Object)change.getChangeCategory())) {
                addedInstanceKey = change.getInstanceKey();
                Object addedInstanceBean = change.getInstanceValue();
                List typeDescriptors = this.locator.getDescriptors((Filter)new NoNameTypeFilter(this.locator, change.getChangeType().getName(), addedInstanceKey));
                for (ActiveDescriptor typeDescriptor : typeDescriptors) {
                    this.modifyInstanceDescriptor(typeDescriptor, addedInstanceKey, addedInstanceBean, change.getChangeType().getName(), change.getModifiedProperties());
                }
                continue;
            }
            if (Change.ChangeCategory.REMOVE_TYPE.equals((Object)change.getChangeCategory())) {
                typeName = change.getChangeType().getName();
                ModificationInformation cache = this.typeInformation.remove(typeName);
                if (cache == null) continue;
                cache.dispose();
                continue;
            }
            if (!Change.ChangeCategory.REMOVE_INSTANCE.equals((Object)change.getChangeCategory())) continue;
            addedInstanceKey = change.getInstanceKey();
            List removeDescriptors = this.locator.getDescriptors((Filter)new NoNameTypeFilter(this.locator, change.getChangeType().getName(), addedInstanceKey));
            for (ActiveDescriptor removeDescriptor : removeDescriptors) {
                config.addUnbindFilter((Filter)BuilderHelper.createSpecificDescriptorFilter((Descriptor)removeDescriptor));
                this.injectionResolver.removeBean(removeDescriptor);
                removed.add(removeDescriptor);
            }
        }
        if (!added.isEmpty() || !removed.isEmpty()) {
            ServiceHandle handle;
            config.commit();
            for (ActiveDescriptor activeDescriptor : added) {
                if (!ConfigurationListener.isEager(activeDescriptor)) continue;
                handle = this.locator.getServiceHandle(activeDescriptor);
                handle.getService();
            }
            for (ActiveDescriptor activeDescriptor : removed) {
                handle = this.locator.getServiceHandle(activeDescriptor);
                handle.destroy();
            }
        }
    }

    private static class ModificationInformation {
        private final ClassReflectionHelper helper = new ClassReflectionHelperImpl();
        private final HashMap<Class<?>, Method> preMethods = new HashMap();
        private final HashMap<Class<?>, Method> postMethods = new HashMap();

        private ModificationInformation() {
        }

        private Method getPreDynamicChangeMethod(Class<?> rawClass) {
            if (this.preMethods.containsKey(rawClass)) {
                return this.preMethods.get(rawClass);
            }
            Method preModificationMethod = this.getSpecialMethod(rawClass, PreDynamicChange.class);
            this.preMethods.put(rawClass, preModificationMethod);
            return preModificationMethod;
        }

        private Method getPostDynamicChangeMethod(Class<?> rawClass) {
            if (this.postMethods.containsKey(rawClass)) {
                return this.postMethods.get(rawClass);
            }
            Method postModificationMethod = this.getSpecialMethod(rawClass, PostDynamicChange.class);
            this.postMethods.put(rawClass, postModificationMethod);
            return postModificationMethod;
        }

        private Method getSpecialMethod(Class<?> rawClass, Class<? extends Annotation> anno) {
            Set wrappers = this.helper.getAllMethods(rawClass);
            for (MethodWrapper wrapper : wrappers) {
                Method candidate = wrapper.getMethod();
                if (candidate.getAnnotation(anno) == null) continue;
                return candidate;
            }
            return null;
        }

        private void dispose() {
            this.helper.dispose();
            this.preMethods.clear();
            this.postMethods.clear();
        }
    }
}

