/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.configuration.hub.internal;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.configuration.hub.api.Type;
import org.glassfish.hk2.utilities.reflection.ClassReflectionHelper;

public class TypeImpl
implements Type {
    private final ReentrantLock lock = new ReentrantLock();
    private final String name;
    private final Map<String, Instance> instances;
    private final ClassReflectionHelper helper;
    private Object metadata;

    TypeImpl(Type baseType, ClassReflectionHelper helper) {
        this.name = baseType.getName();
        this.instances = Collections.unmodifiableMap(baseType.getInstances());
        this.helper = helper;
        this.metadata = baseType.getMetadata();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, Instance> getInstances() {
        return this.instances;
    }

    @Override
    public Instance getInstance(String key) {
        return this.instances.get(key);
    }

    ClassReflectionHelper getHelper() {
        return this.helper;
    }

    @Override
    public Object getMetadata() {
        this.lock.lock();
        try {
            Object object = this.metadata;
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setMetadata(Object metadata) {
        this.lock.lock();
        try {
            this.metadata = metadata;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return "TypeImpl(" + this.name + "," + System.identityHashCode(this) + ")";
    }
}

