/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.configuration.hub.internal;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.glassfish.hk2.configuration.hub.api.BeanDatabase;
import org.glassfish.hk2.configuration.hub.api.Type;
import org.glassfish.hk2.utilities.reflection.Pretty;

public class Utilities {
    public static void dumpDatabase(BeanDatabase database, PrintStream stream) {
        for (Type type : database.getAllTypes()) {
            Set<String> instanceNames = type.getInstances().keySet();
            stream.println(type.getName() + " -> " + Pretty.collection(instanceNames));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dumpDatabaseAsString(BeanDatabase database) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (PrintStream printer = new PrintStream(baos);){
            Utilities.dumpDatabase(database, printer);
            printer.close();
            String string = new String(baos.toByteArray(), StandardCharsets.UTF_8);
            return string;
        }
    }
}

