/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.configuration.hub.internal;

import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.List;
import org.glassfish.hk2.configuration.hub.api.Change;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.configuration.hub.api.Type;

public class ChangeImpl
implements Change {
    private final Change.ChangeCategory changeCategory;
    private final Type changeType;
    private final String instanceKey;
    private final Instance instanceValue;
    private final Instance originalInstanceValue;
    private final List<PropertyChangeEvent> propertyChanges;

    ChangeImpl(Change.ChangeCategory changeCategory, Type changeType, String instanceKey, Instance instanceValue, Instance originalInstanceValue, List<PropertyChangeEvent> propertyChanges) {
        this.changeCategory = changeCategory;
        this.changeType = changeType;
        this.instanceKey = instanceKey;
        this.instanceValue = instanceValue;
        this.originalInstanceValue = originalInstanceValue;
        this.propertyChanges = propertyChanges;
    }

    @Override
    public Change.ChangeCategory getChangeCategory() {
        return this.changeCategory;
    }

    @Override
    public Type getChangeType() {
        return this.changeType;
    }

    @Override
    public String getInstanceKey() {
        return this.instanceKey;
    }

    @Override
    public Instance getInstanceValue() {
        return this.instanceValue;
    }

    @Override
    public Instance getOriginalInstanceValue() {
        return this.originalInstanceValue;
    }

    @Override
    public List<PropertyChangeEvent> getModifiedProperties() {
        if (this.propertyChanges == null) {
            return null;
        }
        return Collections.unmodifiableList(this.propertyChanges);
    }

    public String toString() {
        StringBuffer propChanges = new StringBuffer(",propChanges=[");
        if (this.propertyChanges != null) {
            boolean firstTime = true;
            for (PropertyChangeEvent pce : this.propertyChanges) {
                if (firstTime) {
                    propChanges.append(pce.getPropertyName());
                    firstTime = false;
                    continue;
                }
                propChanges.append("," + pce.getPropertyName());
            }
        }
        propChanges.append("]");
        return "ChangeImpl(" + this.changeCategory + ",type=" + this.changeType + ",instanceKey=" + this.instanceKey + propChanges.toString() + ",sid=" + System.identityHashCode(this) + ")";
    }
}

