/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.configuration.hub.internal;

import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.hk2.configuration.hub.api.BeanDatabase;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.configuration.hub.api.Type;
import org.glassfish.hk2.configuration.hub.internal.TypeImpl;
import org.glassfish.hk2.configuration.hub.internal.Utilities;
import org.glassfish.hk2.configuration.hub.internal.WriteableTypeImpl;

public class BeanDatabaseImpl
implements BeanDatabase {
    private final long revision;
    private final HashMap<String, TypeImpl> types = new HashMap();

    BeanDatabaseImpl(long revision) {
        this.revision = revision;
    }

    BeanDatabaseImpl(long revision, BeanDatabase beanDatabase) {
        this(revision);
        for (Type type : beanDatabase.getAllTypes()) {
            this.types.put(type.getName(), new TypeImpl(type, ((WriteableTypeImpl)type).getHelper()));
        }
    }

    @Override
    public synchronized Set<Type> getAllTypes() {
        return Collections.unmodifiableSet(new HashSet<TypeImpl>(this.types.values()));
    }

    @Override
    public synchronized Instance getInstance(String type, String instanceKey) {
        Type t = this.getType(type);
        if (t == null) {
            return null;
        }
        return t.getInstance(instanceKey);
    }

    @Override
    public synchronized Type getType(String type) {
        return this.types.get(type);
    }

    long getRevision() {
        return this.revision;
    }

    @Override
    public void dumpDatabase() {
        this.dumpDatabase(System.err);
    }

    @Override
    public void dumpDatabase(PrintStream output) {
        Utilities.dumpDatabase(this, output);
    }

    @Override
    public String dumpDatabaseAsString() {
        return Utilities.dumpDatabaseAsString(this);
    }

    public String toString() {
        return "BeanDatabaseImpl(" + this.revision + "," + System.identityHashCode(this) + ")";
    }
}

