/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.configuration.hub.internal;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.hk2.configuration.hub.api.Change;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.configuration.hub.api.WriteableType;
import org.glassfish.hk2.configuration.hub.internal.ChangeImpl;
import org.glassfish.hk2.configuration.hub.internal.InstanceImpl;
import org.glassfish.hk2.configuration.hub.internal.TypeImpl;
import org.glassfish.hk2.configuration.hub.internal.WriteableBeanDatabaseImpl;
import org.glassfish.hk2.utilities.reflection.BeanReflectionHelper;
import org.glassfish.hk2.utilities.reflection.ClassReflectionHelper;
import org.glassfish.hk2.utilities.reflection.internal.ClassReflectionHelperImpl;

public class WriteableTypeImpl
implements WriteableType {
    private final WriteableBeanDatabaseImpl parent;
    private final String name;
    private final HashMap<String, Instance> beanMap = new HashMap();
    private final ClassReflectionHelper helper;
    private Object metadata;

    WriteableTypeImpl(WriteableBeanDatabaseImpl parent, TypeImpl mother) {
        this.parent = parent;
        this.name = mother.getName();
        this.metadata = mother.getMetadata();
        this.beanMap.putAll(mother.getInstances());
        this.helper = mother.getHelper();
    }

    WriteableTypeImpl(WriteableBeanDatabaseImpl parent, String name) {
        this.parent = parent;
        this.name = name;
        this.helper = new ClassReflectionHelperImpl();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized Map<String, Instance> getInstances() {
        return Collections.unmodifiableMap(this.beanMap);
    }

    @Override
    public synchronized Instance getInstance(String key) {
        return this.beanMap.get(key);
    }

    @Override
    public synchronized void addInstance(String key, Object bean) {
        this.addInstance(key, bean, null);
    }

    @Override
    public synchronized void addInstance(String key, Object bean, Object metadata) {
        if (key == null || bean == null) {
            throw new IllegalArgumentException();
        }
        InstanceImpl ii = new InstanceImpl(bean, metadata);
        this.parent.addChange(new ChangeImpl(Change.ChangeCategory.ADD_INSTANCE, this, key, ii, null, null));
        this.beanMap.put(key, ii);
    }

    @Override
    public synchronized Instance removeInstance(String key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Instance removedValue = this.beanMap.remove(key);
        if (removedValue == null) {
            return null;
        }
        this.parent.addChange(new ChangeImpl(Change.ChangeCategory.REMOVE_INSTANCE, this, key, removedValue, null, null));
        return removedValue;
    }

    @Override
    public synchronized PropertyChangeEvent[] modifyInstance(String key, Object newBean, PropertyChangeEvent ... propChanges) {
        if (key == null || newBean == null) {
            throw new IllegalArgumentException();
        }
        Instance oldInstance = this.beanMap.get(key);
        if (oldInstance == null) {
            throw new IllegalStateException("Attempting to modify bean with key " + key + " but no such bean exists");
        }
        InstanceImpl newInstance = new InstanceImpl(newBean, oldInstance.getMetadata());
        if (propChanges.length == 0) {
            propChanges = BeanReflectionHelper.getChangeEvents((ClassReflectionHelper)this.helper, (Object)oldInstance.getBean(), (Object)newInstance.getBean());
        }
        this.beanMap.put(key, newInstance);
        ArrayList<PropertyChangeEvent> propChangesList = new ArrayList<PropertyChangeEvent>(propChanges.length);
        for (PropertyChangeEvent pce : propChanges) {
            propChangesList.add(pce);
        }
        this.parent.addChange(new ChangeImpl(Change.ChangeCategory.MODIFY_INSTANCE, this, key, newInstance, oldInstance, propChangesList));
        return propChanges;
    }

    ClassReflectionHelper getHelper() {
        return this.helper;
    }

    @Override
    public synchronized Object getMetadata() {
        return this.metadata;
    }

    @Override
    public synchronized void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public String toString() {
        return "WriteableTypeImpl(" + this.name + "," + this.metadata + "," + System.identityHashCode(this) + ")";
    }
}

