/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.configuration.hub.internal;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.glassfish.hk2.api.IterableProvider;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.configuration.hub.api.BeanDatabase;
import org.glassfish.hk2.configuration.hub.api.BeanDatabaseUpdateListener;
import org.glassfish.hk2.configuration.hub.api.Change;
import org.glassfish.hk2.configuration.hub.api.CommitFailedException;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.PrepareFailedException;
import org.glassfish.hk2.configuration.hub.api.RollbackFailedException;
import org.glassfish.hk2.configuration.hub.api.WriteableBeanDatabase;
import org.glassfish.hk2.configuration.hub.internal.BeanDatabaseImpl;
import org.glassfish.hk2.configuration.hub.internal.WriteableBeanDatabaseImpl;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Service;

@Service
@ContractsProvided(value={Hub.class})
public class HubImpl
implements Hub {
    private static final AtomicLong revisionCounter = new AtomicLong(1L);
    private final Object lock = new Object();
    private BeanDatabaseImpl currentDatabase = new BeanDatabaseImpl(revisionCounter.getAndIncrement());
    @Inject
    private IterableProvider<BeanDatabaseUpdateListener> listeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BeanDatabase getCurrentDatabase() {
        Object object = this.lock;
        synchronized (object) {
            return this.currentDatabase;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WriteableBeanDatabase getWriteableDatabaseCopy() {
        Object object = this.lock;
        synchronized (object) {
            return new WriteableBeanDatabaseImpl(this, this.currentDatabase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCurrentDatabase(WriteableBeanDatabaseImpl writeableDatabase, Object commitMessage, List<Change> changes) {
        Object object = this.lock;
        synchronized (object) {
            long currentRevision = this.currentDatabase.getRevision();
            long writeRevision = writeableDatabase.getBaseRevision();
            if (currentRevision != writeRevision) {
                throw new IllegalStateException("commit was called on a WriteableDatabase but the current database has changed after that copy was made");
            }
            LinkedList<BeanDatabaseUpdateListener> completedListeners = new LinkedList<BeanDatabaseUpdateListener>();
            for (BeanDatabaseUpdateListener listener : this.listeners) {
                try {
                    listener.prepareDatabaseChange(this.currentDatabase, writeableDatabase, commitMessage, changes);
                    completedListeners.add(listener);
                }
                catch (Throwable th) {
                    MultiException throwMe = new MultiException((Throwable)((Object)new PrepareFailedException(th)));
                    for (BeanDatabaseUpdateListener completedListener : completedListeners) {
                        try {
                            completedListener.rollbackDatabaseChange(this.currentDatabase, writeableDatabase, commitMessage, changes);
                        }
                        catch (Throwable rollTh) {
                            throwMe.addError((Throwable)((Object)new RollbackFailedException(rollTh)));
                        }
                    }
                    throw throwMe;
                }
            }
            BeanDatabaseImpl oldDatabase = this.currentDatabase;
            this.currentDatabase = new BeanDatabaseImpl(revisionCounter.getAndIncrement(), writeableDatabase);
            MultiException commitError = null;
            for (BeanDatabaseUpdateListener completedListener : completedListeners) {
                try {
                    completedListener.commitDatabaseChange(oldDatabase, this.currentDatabase, commitMessage, changes);
                }
                catch (Throwable th) {
                    if (commitError == null) {
                        commitError = new MultiException((Throwable)((Object)new CommitFailedException(th)));
                        continue;
                    }
                    commitError.addError((Throwable)((Object)new CommitFailedException(th)));
                }
            }
            if (commitError != null) {
                throw commitError;
            }
        }
    }
}

