/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.configuration.hub.internal;

import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.glassfish.hk2.configuration.hub.api.Change;
import org.glassfish.hk2.configuration.hub.api.Type;
import org.glassfish.hk2.configuration.hub.api.WriteableBeanDatabase;
import org.glassfish.hk2.configuration.hub.api.WriteableType;
import org.glassfish.hk2.configuration.hub.internal.BeanDatabaseImpl;
import org.glassfish.hk2.configuration.hub.internal.ChangeImpl;
import org.glassfish.hk2.configuration.hub.internal.HubImpl;
import org.glassfish.hk2.configuration.hub.internal.TypeImpl;
import org.glassfish.hk2.configuration.hub.internal.Utilities;
import org.glassfish.hk2.configuration.hub.internal.WriteableTypeImpl;

public class WriteableBeanDatabaseImpl
implements WriteableBeanDatabase {
    private final long baseRevision;
    private final HashMap<String, WriteableTypeImpl> types = new HashMap();
    private final HubImpl hub;
    private final LinkedList<Change> changes = new LinkedList();
    private final LinkedList<WriteableTypeImpl> removedTypes = new LinkedList();
    private boolean committed = false;

    WriteableBeanDatabaseImpl(HubImpl hub, BeanDatabaseImpl currentDatabase) {
        this.hub = hub;
        this.baseRevision = currentDatabase.getRevision();
        for (Type type : currentDatabase.getAllTypes()) {
            this.types.put(type.getName(), new WriteableTypeImpl(this, (TypeImpl)type));
        }
    }

    @Override
    public synchronized Set<Type> getAllTypes() {
        return Collections.unmodifiableSet(new HashSet<WriteableTypeImpl>(this.types.values()));
    }

    @Override
    public synchronized Type getType(String type) {
        return this.types.get(type);
    }

    @Override
    public synchronized Object getInstance(String type, String instanceKey) {
        Type t = this.getType(type);
        if (t == null) {
            return null;
        }
        return t.getInstance(instanceKey);
    }

    private void checkState() {
        if (this.committed) {
            throw new IllegalStateException("This database has already been committed");
        }
    }

    @Override
    public synchronized WriteableType addType(String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException();
        }
        this.checkState();
        WriteableTypeImpl wti = new WriteableTypeImpl(this, typeName);
        this.changes.add(new ChangeImpl(Change.ChangeCategory.ADD_TYPE, wti, null, null, null));
        this.types.put(typeName, wti);
        return wti;
    }

    @Override
    public synchronized Type removeType(String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException();
        }
        this.checkState();
        WriteableTypeImpl retVal = this.types.remove(typeName);
        if (retVal == null) {
            return null;
        }
        Map<String, Object> instances = retVal.getInstances();
        for (String key : new HashSet<String>(instances.keySet())) {
            retVal.removeInstance(key);
        }
        this.changes.add(new ChangeImpl(Change.ChangeCategory.REMOVE_TYPE, retVal, null, null, null));
        this.removedTypes.add(retVal);
        return retVal;
    }

    @Override
    public synchronized WriteableType getWriteableType(String typeName) {
        this.checkState();
        return this.types.get(typeName);
    }

    @Override
    public synchronized WriteableType findOrAddWriteableType(String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException();
        }
        this.checkState();
        WriteableTypeImpl wti = this.types.get(typeName);
        if (wti == null) {
            return this.addType(typeName);
        }
        return wti;
    }

    @Override
    public void commit() {
        this.commit(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Object commitMessage) {
        WriteableBeanDatabaseImpl writeableBeanDatabaseImpl = this;
        synchronized (writeableBeanDatabaseImpl) {
            this.checkState();
            this.committed = true;
        }
        this.hub.setCurrentDatabase(this, commitMessage, this.changes);
        for (WriteableTypeImpl removedType : this.removedTypes) {
            removedType.getHelper().dispose();
        }
        this.removedTypes.clear();
    }

    long getBaseRevision() {
        return this.baseRevision;
    }

    synchronized void addChange(Change change) {
        this.changes.add(change);
    }

    @Override
    public void dumpDatabase() {
        this.dumpDatabase(System.err);
    }

    @Override
    public synchronized void dumpDatabase(PrintStream output) {
        Utilities.dumpDatabase(this, output);
    }
}

