/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.configuration.hub.internal;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.configuration.hub.api.BeanDatabase;
import org.glassfish.hk2.configuration.hub.api.BeanDatabaseUpdateListener;
import org.glassfish.hk2.configuration.hub.api.Change;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.WriteableBeanDatabase;
import org.glassfish.hk2.configuration.hub.internal.BeanDatabaseImpl;
import org.glassfish.hk2.configuration.hub.internal.WriteableBeanDatabaseImpl;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Service;

@Service
@ContractsProvided(value={Hub.class})
public class HubImpl
implements Hub {
    private static final AtomicLong revisionCounter = new AtomicLong(1L);
    private final Object lock = new Object();
    private BeanDatabaseImpl currentDatabase = new BeanDatabaseImpl(revisionCounter.getAndIncrement());
    private final HashSet<BeanDatabaseUpdateListener> listeners = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BeanDatabase getCurrentDatabase() {
        Object object = this.lock;
        synchronized (object) {
            return this.currentDatabase;
        }
    }

    @Override
    public synchronized void addListener(BeanDatabaseUpdateListener listener) {
        try {
            listener.initialize(this.currentDatabase);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable th) {
            throw new MultiException(th);
        }
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeListener(BeanDatabaseUpdateListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WriteableBeanDatabase getWriteableDatabaseCopy() {
        Object object = this.lock;
        synchronized (object) {
            return new WriteableBeanDatabaseImpl(this, this.currentDatabase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCurrentDatabase(WriteableBeanDatabaseImpl writeableDatabase, Object commitMessage, List<Change> changes) {
        Object object = this.lock;
        synchronized (object) {
            long currentRevision = this.currentDatabase.getRevision();
            long writeRevision = writeableDatabase.getBaseRevision();
            if (currentRevision != writeRevision) {
                throw new IllegalStateException("commit was called on a WriteableDatabase but the current database has changed after that copy was made");
            }
            this.currentDatabase = new BeanDatabaseImpl(revisionCounter.getAndIncrement(), writeableDatabase);
            for (BeanDatabaseUpdateListener listener : this.listeners) {
                try {
                    listener.databaseHasChanged(this.currentDatabase, commitMessage, changes);
                }
                catch (Throwable th) {}
            }
        }
    }
}

