/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.configuration.hub.internal;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.hk2.configuration.hub.api.Change;
import org.glassfish.hk2.configuration.hub.api.WriteableType;
import org.glassfish.hk2.configuration.hub.internal.ChangeImpl;
import org.glassfish.hk2.configuration.hub.internal.TypeImpl;
import org.glassfish.hk2.configuration.hub.internal.WriteableBeanDatabaseImpl;
import org.glassfish.hk2.utilities.reflection.BeanReflectionHelper;
import org.glassfish.hk2.utilities.reflection.ClassReflectionHelper;
import org.glassfish.hk2.utilities.reflection.internal.ClassReflectionHelperImpl;

public class WriteableTypeImpl
implements WriteableType {
    private final WriteableBeanDatabaseImpl parent;
    private final String name;
    private final HashMap<String, Object> beanMap = new HashMap();
    private final ClassReflectionHelper helper;

    WriteableTypeImpl(WriteableBeanDatabaseImpl parent, TypeImpl mother) {
        this.parent = parent;
        this.name = mother.getName();
        this.beanMap.putAll(mother.getInstances());
        this.helper = mother.getHelper();
    }

    WriteableTypeImpl(WriteableBeanDatabaseImpl parent, String name) {
        this.parent = parent;
        this.name = name;
        this.helper = new ClassReflectionHelperImpl();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized Map<String, Object> getInstances() {
        return Collections.unmodifiableMap(this.beanMap);
    }

    @Override
    public synchronized Object getInstance(String key) {
        return this.beanMap.get(key);
    }

    @Override
    public synchronized void addInstance(String key, Object bean) {
        if (key == null || bean == null) {
            throw new IllegalArgumentException();
        }
        this.parent.addChange(new ChangeImpl(Change.ChangeCategory.ADD_INSTANCE, this, key, bean, null));
        this.beanMap.put(key, bean);
    }

    @Override
    public synchronized Object removeInstance(String key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Object removedValue = this.beanMap.remove(key);
        if (removedValue == null) {
            return null;
        }
        this.parent.addChange(new ChangeImpl(Change.ChangeCategory.REMOVE_INSTANCE, this, key, removedValue, null));
        return removedValue;
    }

    @Override
    public synchronized PropertyChangeEvent[] modifyInstance(String key, Object newBean, PropertyChangeEvent ... propChanges) {
        if (key == null || newBean == null) {
            throw new IllegalArgumentException();
        }
        Object oldBean = this.beanMap.get(key);
        if (oldBean == null) {
            throw new IllegalStateException("Attempting to modify bean with key " + key + " but no such bean exists");
        }
        if (propChanges.length == 0) {
            propChanges = BeanReflectionHelper.getChangeEvents((ClassReflectionHelper)this.helper, (Object)oldBean, (Object)newBean);
        }
        this.beanMap.put(key, newBean);
        ArrayList<PropertyChangeEvent> propChangesList = new ArrayList<PropertyChangeEvent>(propChanges.length);
        for (PropertyChangeEvent pce : propChanges) {
            propChangesList.add(pce);
        }
        this.parent.addChange(new ChangeImpl(Change.ChangeCategory.MODIFY_INSTANCE, this, key, newBean, propChangesList));
        return propChanges;
    }

    ClassReflectionHelper getHelper() {
        return this.helper;
    }
}

