/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.testing.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.glassfish.hk2.testing.collections.DefaultTestCollectionElement;
import org.glassfish.hk2.testing.collections.TestCollectionElement;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractMapTest {
    protected static final String NULL_KEY = "null";
    protected static final String NULL_VALUE = "null";
    protected static final String ONE_KEY = "One";
    protected static final String ONE_VALUE = "1";
    protected static final String TWO_KEY = "Two";
    protected static final String TWO_VALUE = "2";
    protected static final String THREE_KEY = "Three";
    protected static final String THREE_VALUE = "3";
    protected static final String FOUR_KEY = "Four";
    protected static final String FOUR_VALUE = "4";
    private TestCollectionElement globalOneKey;
    private TestCollectionElement globalTwoKey;
    private TestCollectionElement globalThreeKey;
    private TestCollectionElement globalOneValue;
    private TestCollectionElement globalTwoValue;
    private TestCollectionElement globalThreeValue;

    protected boolean isNullArgumentConstructorSupported() {
        return true;
    }

    protected boolean isMapArgumentConstructorSupported() {
        return true;
    }

    protected boolean doesMapDelegateFromOriginalMap() {
        return false;
    }

    protected boolean doesMapAllowNullKeys() {
        return true;
    }

    protected boolean doesMapAllowNullValues() {
        return true;
    }

    protected boolean doesMapSupportRemove() {
        return true;
    }

    protected abstract Map<?, ?> createMap();

    protected abstract Map<?, ?> createMap(Map<?, ?> var1);

    protected TestCollectionElement getElement(String data) {
        return new DefaultTestCollectionElement(data);
    }

    private Map<?, ?> createEmptyMap() {
        if (this.isNullArgumentConstructorSupported()) {
            return this.createMap();
        }
        if (this.isMapArgumentConstructorSupported()) {
            return this.createMap(new HashMap());
        }
        Assert.fail((String)"Neither null nor Collection constructor is supported by the List implementation");
        return null;
    }

    @Test
    public void testMapFromNullConstructorHasZeroSize() {
        if (!this.isNullArgumentConstructorSupported()) {
            return;
        }
        Map<?, ?> myMap = this.createMap();
        Assert.assertEquals((long)0L, (long)myMap.size());
        Assert.assertTrue((boolean)myMap.isEmpty());
    }

    @Test
    public void testMapFromMapConstructorHasZeroSize() {
        if (!this.isMapArgumentConstructorSupported()) {
            return;
        }
        Map<?, ?> myMap = this.createMap(Collections.emptyMap());
        Assert.assertEquals((long)0L, (long)myMap.size());
        Assert.assertTrue((boolean)myMap.isEmpty());
    }

    @Test(expected=NullPointerException.class)
    public void testMapConstructedWithNullMapThrows() {
        if (!this.isMapArgumentConstructorSupported()) {
            throw new NullPointerException();
        }
        this.createMap(null);
    }

    @Test
    public void testCanAddToMap() {
        Map<?, ?> map = this.createEmptyMap();
        TestCollectionElement oneKey = this.getElement(ONE_KEY);
        TestCollectionElement oneValue = this.getElement(ONE_VALUE);
        map.put(oneKey, oneValue);
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertFalse((boolean)map.isEmpty());
        Assert.assertTrue((boolean)map.containsKey(oneKey));
        Assert.assertTrue((boolean)map.containsValue(oneValue));
        Assert.assertEquals((Object)oneValue, map.get(oneKey));
    }

    @Test
    public void testModifyingOriginalCollectionDoesNotAffectNewCollection() {
        if (!this.isMapArgumentConstructorSupported() || this.doesMapDelegateFromOriginalMap()) {
            return;
        }
        HashMap<TestCollectionElement, TestCollectionElement> originalList = new HashMap<TestCollectionElement, TestCollectionElement>();
        originalList.put(this.getElement(ONE_KEY), this.getElement(ONE_VALUE));
        originalList.put(this.getElement(TWO_KEY), this.getElement(TWO_VALUE));
        Map<?, ?> mapUnderTest = this.createMap(originalList);
        originalList.put(this.getElement(THREE_KEY), this.getElement(THREE_VALUE));
        Assert.assertEquals((long)2L, (long)mapUnderTest.size());
        originalList.clear();
        Assert.assertEquals((long)2L, (long)mapUnderTest.size());
    }

    @Test
    public void testContainsAfterPut() {
        Map<?, ?> map = this.createEmptyMap();
        TestCollectionElement oneKey = this.getElement(ONE_KEY);
        TestCollectionElement twoKey = this.getElement(TWO_KEY);
        TestCollectionElement threeKey = this.getElement(THREE_KEY);
        TestCollectionElement fourKey = this.getElement(FOUR_KEY);
        TestCollectionElement oneValue = this.getElement(ONE_VALUE);
        TestCollectionElement twoValue = this.getElement(TWO_VALUE);
        TestCollectionElement threeValue = this.getElement(THREE_VALUE);
        TestCollectionElement fourValue = this.getElement(FOUR_VALUE);
        map.put(oneKey, oneValue);
        map.put(twoKey, twoValue);
        map.put(threeKey, threeValue);
        Assert.assertTrue((boolean)map.containsKey(threeKey));
        Assert.assertTrue((boolean)map.containsKey(twoKey));
        Assert.assertTrue((boolean)map.containsKey(oneKey));
        Assert.assertFalse((boolean)map.containsKey(fourKey));
        Assert.assertTrue((boolean)map.containsValue(threeValue));
        Assert.assertTrue((boolean)map.containsValue(twoValue));
        Assert.assertTrue((boolean)map.containsValue(oneValue));
        Assert.assertFalse((boolean)map.containsValue(fourValue));
        if (this.doesMapAllowNullKeys()) {
            Assert.assertFalse((boolean)map.containsKey(null));
        }
        if (this.doesMapAllowNullValues()) {
            Assert.assertFalse((boolean)map.containsValue(null));
        }
    }

    @Test
    public void testCanMapHaveNullKeys() {
        if (!this.doesMapAllowNullKeys()) {
            return;
        }
        Map<?, ?> map = this.createEmptyMap();
        TestCollectionElement oneValue = this.getElement(ONE_VALUE);
        map.put(null, oneValue);
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertTrue((boolean)map.containsKey(null));
        Assert.assertTrue((boolean)map.containsValue(oneValue));
        Assert.assertEquals((Object)oneValue, map.get(null));
    }

    @Test
    public void testCanMapHaveNullValues() {
        if (!this.doesMapAllowNullValues()) {
            return;
        }
        Map<?, ?> map = this.createEmptyMap();
        TestCollectionElement oneKey = this.getElement(ONE_KEY);
        map.put(oneKey, null);
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertTrue((boolean)map.containsKey(oneKey));
        Assert.assertTrue((boolean)map.containsValue(null));
        Assert.assertNull(map.get(oneKey));
    }

    private TestCollectionElement getSafeNullKey() {
        if (this.doesMapAllowNullKeys()) {
            return null;
        }
        return this.getElement("null");
    }

    private TestCollectionElement getSafeNullValue() {
        if (this.doesMapAllowNullValues()) {
            return null;
        }
        return this.getElement("null");
    }

    @Test
    public void testCanCollectionHaveNullAndNonNullEntries() {
        Map<?, ?> map = this.createEmptyMap();
        TestCollectionElement oneKey = this.getElement(ONE_KEY);
        TestCollectionElement twoKey = this.getElement(TWO_KEY);
        TestCollectionElement oneValue = this.getElement(ONE_VALUE);
        TestCollectionElement twoValue = this.getElement(TWO_VALUE);
        TestCollectionElement nullKey = this.getSafeNullKey();
        TestCollectionElement threeKey = this.getElement(THREE_KEY);
        TestCollectionElement threeValue = this.getElement(THREE_VALUE);
        TestCollectionElement nullValue = this.getSafeNullValue();
        TestCollectionElement fourKey = this.getElement(FOUR_KEY);
        TestCollectionElement fourValue = this.getElement(FOUR_VALUE);
        map.put(nullKey, twoValue);
        map.put(oneKey, oneValue);
        map.put(twoKey, nullValue);
        map.put(threeKey, threeValue);
        map.put(fourKey, nullValue);
        Assert.assertEquals((long)5L, (long)map.size());
        Assert.assertTrue((boolean)map.containsKey(nullKey));
        Assert.assertTrue((boolean)map.containsKey(oneKey));
        Assert.assertTrue((boolean)map.containsKey(twoKey));
        Assert.assertTrue((boolean)map.containsKey(threeKey));
        Assert.assertTrue((boolean)map.containsKey(fourKey));
        Assert.assertTrue((boolean)map.containsValue(nullValue));
        Assert.assertTrue((boolean)map.containsValue(oneValue));
        Assert.assertTrue((boolean)map.containsValue(twoValue));
        Assert.assertTrue((boolean)map.containsValue(threeValue));
        Assert.assertFalse((boolean)map.containsValue(fourValue));
        Assert.assertEquals((Object)twoValue, map.get(nullKey));
        Assert.assertEquals((Object)oneValue, map.get(oneKey));
        Assert.assertEquals((Object)nullValue, map.get(twoKey));
        Assert.assertEquals((Object)threeValue, map.get(threeKey));
        Assert.assertEquals((Object)nullValue, map.get(fourKey));
    }

    @Test
    public void testRemoveFromEmptyMap() {
        if (!this.doesMapSupportRemove()) {
            return;
        }
        Map<?, ?> map = this.createEmptyMap();
        TestCollectionElement oneKey = this.getElement(ONE_KEY);
        Assert.assertNull(map.remove(oneKey));
        Assert.assertEquals((long)0L, (long)map.size());
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testRemoveFromOneElementMap() {
        if (!this.doesMapSupportRemove()) {
            return;
        }
        Map<?, ?> map = this.createEmptyMap();
        TestCollectionElement oneKey = this.getElement(ONE_KEY);
        TestCollectionElement oneValue = this.getElement(ONE_VALUE);
        map.put(oneKey, oneValue);
        Assert.assertEquals((Object)oneValue, map.remove(oneKey));
        Assert.assertEquals((long)0L, (long)map.size());
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testRemoveFirstThingFromMultiElementMap() {
        if (!this.doesMapSupportRemove()) {
            return;
        }
        Map<?, ?> map = this.createEmptyMap();
        TestCollectionElement oneKey = this.getElement(ONE_KEY);
        TestCollectionElement twoKey = this.getElement(TWO_KEY);
        TestCollectionElement threeKey = this.getElement(THREE_KEY);
        TestCollectionElement oneValue = this.getElement(ONE_VALUE);
        TestCollectionElement twoValue = this.getElement(TWO_VALUE);
        TestCollectionElement threeValue = this.getElement(THREE_VALUE);
        map.put(oneKey, oneValue);
        map.put(twoKey, twoValue);
        map.put(threeKey, threeValue);
        Assert.assertEquals((Object)oneValue, map.remove(oneKey));
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertFalse((boolean)map.isEmpty());
        Assert.assertTrue((boolean)map.containsKey(twoKey));
        Assert.assertTrue((boolean)map.containsValue(threeValue));
        Assert.assertFalse((boolean)map.containsKey(oneKey));
        Assert.assertFalse((boolean)map.containsValue(oneValue));
    }

    @Test
    public void testRemoveLastThingFromMultiElementMap() {
        if (!this.doesMapSupportRemove()) {
            return;
        }
        Map<?, ?> map = this.createEmptyMap();
        TestCollectionElement oneKey = this.getElement(ONE_KEY);
        TestCollectionElement twoKey = this.getElement(TWO_KEY);
        TestCollectionElement threeKey = this.getElement(THREE_KEY);
        TestCollectionElement oneValue = this.getElement(ONE_VALUE);
        TestCollectionElement twoValue = this.getElement(TWO_VALUE);
        TestCollectionElement threeValue = this.getElement(THREE_VALUE);
        map.put(oneKey, oneValue);
        map.put(twoKey, twoValue);
        map.put(threeKey, threeValue);
        Assert.assertEquals((Object)threeValue, map.remove(threeKey));
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertFalse((boolean)map.isEmpty());
        Assert.assertTrue((boolean)map.containsKey(twoKey));
        Assert.assertTrue((boolean)map.containsValue(oneValue));
        Assert.assertFalse((boolean)map.containsKey(threeKey));
        Assert.assertFalse((boolean)map.containsValue(threeValue));
    }

    @Test
    public void testRemoveMiddleThingFromMultiElementMap() {
        if (!this.doesMapSupportRemove()) {
            return;
        }
        Map<?, ?> map = this.createEmptyMap();
        TestCollectionElement oneKey = this.getElement(ONE_KEY);
        TestCollectionElement twoKey = this.getElement(TWO_KEY);
        TestCollectionElement threeKey = this.getElement(THREE_KEY);
        TestCollectionElement oneValue = this.getElement(ONE_VALUE);
        TestCollectionElement twoValue = this.getElement(TWO_VALUE);
        TestCollectionElement threeValue = this.getElement(THREE_VALUE);
        map.put(oneKey, oneValue);
        map.put(twoKey, twoValue);
        map.put(threeKey, threeValue);
        Assert.assertEquals((Object)twoValue, map.remove(twoKey));
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertFalse((boolean)map.isEmpty());
        Assert.assertTrue((boolean)map.containsKey(threeKey));
        Assert.assertTrue((boolean)map.containsValue(oneValue));
        Assert.assertFalse((boolean)map.containsKey(twoKey));
        Assert.assertFalse((boolean)map.containsValue(twoValue));
    }

    private void addGlobalsToMap(Map aMap) {
        this.globalOneKey = this.getElement(ONE_KEY);
        this.globalTwoKey = this.getElement(TWO_KEY);
        this.globalThreeKey = this.getElement(THREE_KEY);
        this.globalOneValue = this.getElement(ONE_VALUE);
        this.globalTwoValue = this.getElement(TWO_VALUE);
        this.globalThreeValue = this.getElement(THREE_VALUE);
        aMap.put(this.globalOneKey, this.globalOneValue);
        aMap.put(this.globalTwoKey, this.globalTwoValue);
        aMap.put(this.globalThreeKey, this.globalThreeValue);
    }

    private Map<TestCollectionElement, TestCollectionElement> createMapWithOneTwoThree() {
        HashMap<TestCollectionElement, TestCollectionElement> retVal = new HashMap<TestCollectionElement, TestCollectionElement>();
        this.addGlobalsToMap(retVal);
        return retVal;
    }

    @Test
    public void testPutAllEmptyOriginalEmptyAdding() {
        Map<?, ?> originalMap = this.createEmptyMap();
        Map<?, ?> putAllMap = this.createEmptyMap();
        originalMap.putAll(putAllMap);
        Assert.assertTrue((boolean)originalMap.isEmpty());
    }

    @Test
    public void testPutAllEmptyOriginalNonEmptyAdding() {
        Map<?, ?> originalMap = this.createEmptyMap();
        Map<TestCollectionElement, TestCollectionElement> putAllMap = this.createMapWithOneTwoThree();
        originalMap.putAll(putAllMap);
        Assert.assertEquals((long)3L, (long)originalMap.size());
        Assert.assertTrue((boolean)originalMap.containsKey(this.globalOneKey));
        Assert.assertTrue((boolean)originalMap.containsKey(this.globalTwoKey));
        Assert.assertTrue((boolean)originalMap.containsKey(this.globalThreeKey));
        Assert.assertTrue((boolean)originalMap.containsValue(this.globalOneValue));
        Assert.assertTrue((boolean)originalMap.containsValue(this.globalTwoValue));
        Assert.assertTrue((boolean)originalMap.containsValue(this.globalThreeValue));
        Assert.assertEquals((Object)this.globalOneValue, originalMap.get(this.globalOneKey));
        Assert.assertEquals((Object)this.globalTwoValue, originalMap.get(this.globalTwoKey));
        Assert.assertEquals((Object)this.globalThreeValue, originalMap.get(this.globalThreeKey));
    }

    @Test
    public void testPutAllNonEmptyOriginalEmptyAdding() {
        Map<?, ?> originalMap = this.createEmptyMap();
        Map<?, ?> putAllMap = this.createEmptyMap();
        this.addGlobalsToMap(originalMap);
        originalMap.putAll(putAllMap);
        Assert.assertEquals((long)3L, (long)originalMap.size());
        Assert.assertTrue((boolean)originalMap.containsKey(this.globalOneKey));
        Assert.assertTrue((boolean)originalMap.containsKey(this.globalTwoKey));
        Assert.assertTrue((boolean)originalMap.containsKey(this.globalThreeKey));
        Assert.assertTrue((boolean)originalMap.containsValue(this.globalOneValue));
        Assert.assertTrue((boolean)originalMap.containsValue(this.globalTwoValue));
        Assert.assertTrue((boolean)originalMap.containsValue(this.globalThreeValue));
        Assert.assertEquals((Object)this.globalOneValue, originalMap.get(this.globalOneKey));
        Assert.assertEquals((Object)this.globalTwoValue, originalMap.get(this.globalTwoKey));
        Assert.assertEquals((Object)this.globalThreeValue, originalMap.get(this.globalThreeKey));
    }

    @Test
    public void testPutAllNonEmptyOriginalNonEmptyAdding() {
        Map<?, ?> originalMap = this.createEmptyMap();
        Map<TestCollectionElement, TestCollectionElement> putAllMap = this.createMapWithOneTwoThree();
        TestCollectionElement fourKey = this.getElement(FOUR_KEY);
        TestCollectionElement fourValue = this.getElement(FOUR_VALUE);
        originalMap.put(fourKey, fourValue);
        originalMap.putAll(putAllMap);
        Assert.assertEquals((long)4L, (long)originalMap.size());
        Assert.assertTrue((boolean)originalMap.containsKey(this.globalOneKey));
        Assert.assertTrue((boolean)originalMap.containsKey(this.globalTwoKey));
        Assert.assertTrue((boolean)originalMap.containsKey(this.globalThreeKey));
        Assert.assertTrue((boolean)originalMap.containsKey(fourKey));
        Assert.assertTrue((boolean)originalMap.containsValue(this.globalOneValue));
        Assert.assertTrue((boolean)originalMap.containsValue(this.globalTwoValue));
        Assert.assertTrue((boolean)originalMap.containsValue(this.globalThreeValue));
        Assert.assertTrue((boolean)originalMap.containsValue(fourValue));
        Assert.assertEquals((Object)this.globalOneValue, originalMap.get(this.globalOneKey));
        Assert.assertEquals((Object)this.globalTwoValue, originalMap.get(this.globalTwoKey));
        Assert.assertEquals((Object)this.globalThreeValue, originalMap.get(this.globalThreeKey));
        Assert.assertEquals((Object)fourValue, originalMap.get(fourKey));
    }

    @Test
    public void testClearOnEmptyMap() {
        if (!this.doesMapSupportRemove()) {
            return;
        }
        Map<?, ?> originalMap = this.createEmptyMap();
        originalMap.clear();
        Assert.assertTrue((boolean)originalMap.isEmpty());
    }

    @Test
    public void testClearOnNonEmptyMap() {
        if (!this.doesMapSupportRemove()) {
            return;
        }
        Map<?, ?> originalMap = this.createEmptyMap();
        this.addGlobalsToMap(originalMap);
        originalMap.clear();
        Assert.assertTrue((boolean)originalMap.isEmpty());
    }

    @Test
    public void testKeySetOnEmptyMap() {
        Map<?, ?> originalMap = this.createEmptyMap();
        Set<?> set = originalMap.keySet();
        Assert.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void testKeySetOnNonEmptyMap() {
        Map<?, ?> originalMap = this.createEmptyMap();
        this.addGlobalsToMap(originalMap);
        Set<?> set = originalMap.keySet();
        Assert.assertEquals((long)3L, (long)set.size());
        Assert.assertTrue((boolean)set.contains(this.globalOneKey));
        Assert.assertTrue((boolean)set.contains(this.globalTwoKey));
        Assert.assertTrue((boolean)set.contains(this.globalThreeKey));
    }

    @Test
    public void testValuesOnEmptyMap() {
        Map<?, ?> originalMap = this.createEmptyMap();
        Collection<?> collection = originalMap.values();
        Assert.assertTrue((boolean)collection.isEmpty());
    }

    @Test
    public void testValuesOnNonEmptyMap() {
        Map<?, ?> originalMap = this.createEmptyMap();
        this.addGlobalsToMap(originalMap);
        Collection<?> values = originalMap.values();
        Assert.assertEquals((long)3L, (long)values.size());
        Assert.assertTrue((boolean)values.contains(this.globalOneValue));
        Assert.assertTrue((boolean)values.contains(this.globalTwoValue));
        Assert.assertTrue((boolean)values.contains(this.globalThreeValue));
    }

    @Test
    public void testEntrySetOnEmptyMap() {
        Map<?, ?> originalMap = this.createEmptyMap();
        Set<Map.Entry<?, ?>> set = originalMap.entrySet();
        Assert.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void testEntrySetOnNonEmptyMap() {
        Map<?, ?> originalMap = this.createEmptyMap();
        this.addGlobalsToMap(originalMap);
        Set<Map.Entry<?, ?>> entrySet = originalMap.entrySet();
        Assert.assertEquals((long)3L, (long)entrySet.size());
        boolean gotOne = false;
        boolean gotTwo = false;
        boolean gotThree = false;
        for (Map.Entry<?, ?> rawEntry : entrySet) {
            Assert.assertTrue((boolean)(rawEntry instanceof Map.Entry));
            Map.Entry<?, ?> entry = rawEntry;
            if (entry.getKey().equals(this.globalOneKey)) {
                Assert.assertFalse((boolean)gotOne);
                gotOne = true;
                Assert.assertEquals(entry.getValue(), (Object)this.globalOneValue);
                continue;
            }
            if (entry.getKey().equals(this.globalTwoKey)) {
                Assert.assertFalse((boolean)gotTwo);
                gotTwo = true;
                Assert.assertEquals(entry.getValue(), (Object)this.globalTwoValue);
                continue;
            }
            if (entry.getKey().equals(this.globalThreeKey)) {
                Assert.assertFalse((boolean)gotThree);
                gotThree = true;
                Assert.assertEquals(entry.getValue(), (Object)this.globalThreeValue);
                continue;
            }
            Assert.fail((String)("Unknown entry " + entry.getKey() + " value " + entry.getValue()));
        }
        Assert.assertTrue((boolean)gotOne);
        Assert.assertTrue((boolean)gotTwo);
        Assert.assertTrue((boolean)gotThree);
    }

    private static int keyToInt(TestCollectionElement key) {
        String value = key.testCollectionValue();
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    @Test
    public void testAddOneThousandEntries() {
        Map<?, ?> map = this.createEmptyMap();
        HashSet<TestCollectionElement> keys = new HashSet<TestCollectionElement>();
        for (int lcv = 0; lcv < 1000; ++lcv) {
            TestCollectionElement element = this.getElement("" + lcv);
            map.put(element, new Integer(lcv));
            keys.add(element);
        }
        for (TestCollectionElement key : keys) {
            Assert.assertTrue((boolean)map.containsKey(key));
            int keyValue = AbstractMapTest.keyToInt(key);
            Integer value = (Integer)map.get(key);
            Assert.assertEquals((long)keyValue, (long)value.intValue());
        }
    }
}

