/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.maven;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HK2GenerateMojo
extends AbstractMojo {
    protected File manifestLocation;
    protected MavenProject project;

    public void execute() throws MojoExecutionException {
        if (this.project.getDependencyArtifacts() != null) {
            ArrayList<String> consolidatedInhabitants = new ArrayList<String>();
            for (Artifact a : this.project.getDependencyArtifacts()) {
                if (a.getScope() != null && a.getScope().equals("test")) continue;
                this.getLog().info((CharSequence)("Dependency Artifact: " + a.getFile().toString()));
                try {
                    JarFile jf = new JarFile(a.getFile());
                    JarEntry je = jf.getJarEntry("META-INF/inhabitants");
                    if (je == null) continue;
                    this.getLog().debug((CharSequence)("Dependency Artifact " + a + " has Inhabitants File: " + je));
                    Enumeration<JarEntry> entries = jf.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (entry.isDirectory() || !entry.getName().startsWith("META-INF/inhabitants")) continue;
                        this.getLog().info((CharSequence)("Entry: " + entry.getName()));
                        consolidatedInhabitants.addAll(this.loadInhabitants(jf, entry));
                    }
                }
                catch (IOException iex) {
                    iex.printStackTrace();
                }
            }
            this.writeToFile(consolidatedInhabitants);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> loadInhabitants(JarFile jf, JarEntry e) throws IOException {
        ArrayList<String> l = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            DataInputStream in = new DataInputStream(jf.getInputStream(e));
            reader = new BufferedReader(new InputStreamReader(in));
            String line = null;
            while ((line = reader.readLine()) != null) {
                l.add(line);
            }
        }
        catch (IOException iex) {
            iex.printStackTrace();
        }
        finally {
            reader.close();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(List<String> consolidatedInhabitants) {
        String inhabitantsDir = "" + this.manifestLocation + File.separatorChar + "META-INF" + File.separatorChar + "inhabitants";
        boolean success = new File(inhabitantsDir).mkdirs();
        String fileLocation = inhabitantsDir + File.separatorChar + "default";
        this.getLog().info((CharSequence)("Writing consolidated inhabitants to: " + fileLocation));
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(fileLocation));
            for (String s : consolidatedInhabitants) {
                out.write(s);
                out.newLine();
            }
        }
        catch (IOException iex) {
            iex.printStackTrace();
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iex) {}
        }
    }
}

