/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.hk2.classmodel.reflect.impl.TypeProxy;

public class TypesCtr
implements Types {
    private final ConcurrentMap<Class, ConcurrentMap<String, TypeProxy<Type>>> storage = new ConcurrentHashMap<Class, ConcurrentMap<String, TypeProxy<Type>>>();
    private final ConcurrentMap<String, TypeProxy<Type>> unknownTypesStorage = new ConcurrentHashMap<String, TypeProxy<Type>>();
    private final Stack<TypeProxy> nonVisited = new Stack();

    @Override
    public Type getBy(String name) {
        for (Map map : this.storage.values()) {
            TypeProxy proxy = (TypeProxy)map.get(name);
            if (proxy == null) continue;
            return proxy.get();
        }
        return null;
    }

    @Override
    public <T extends Type> T getBy(Class<T> type, String name) {
        Type t = this.getBy(name);
        try {
            return (T)((Type)type.cast(t));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public TypeProxy<Type> getHolder(String name) {
        if (name.equals("java.lang.Object")) {
            return null;
        }
        for (Map map : this.storage.values()) {
            TypeProxy proxy = (TypeProxy)map.get(name);
            if (proxy == null) continue;
            return proxy;
        }
        if (this.unknownTypesStorage.containsKey(name)) {
            return (TypeProxy)this.unknownTypesStorage.get(name);
        }
        TypeProxy<Type> typeProxy = new TypeProxy<Type>(null, name);
        TypeProxy<Type> old = this.unknownTypesStorage.putIfAbsent(name, typeProxy);
        if (old == null) {
            this.nonVisited.push(typeProxy);
            return typeProxy;
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Type> TypeProxy<Type> getHolder(String name, Class<T> type) {
        TypeProxy typeProxy;
        ConcurrentMap old;
        if (name.equals("java.lang.Object")) {
            return null;
        }
        ConcurrentMap typeStorage = (ConcurrentHashMap)this.storage.get(type);
        if (typeStorage == null && (old = (ConcurrentMap)this.storage.putIfAbsent(type, typeStorage = new ConcurrentHashMap())) != null) {
            typeStorage = old;
        }
        if ((typeProxy = (TypeProxy)typeStorage.get(name)) == null) {
            TypeProxy old2;
            for (ConcurrentMap<String, TypeProxy<Type>> map : this.storage.values()) {
                TypeProxy proxy = (TypeProxy)map.get(name);
                if (proxy == null) continue;
                return proxy;
            }
            TypeProxy tmp = (TypeProxy)this.unknownTypesStorage.get(name);
            if (tmp != null) {
                ConcurrentMap<String, TypeProxy<Type>> map;
                map = this.unknownTypesStorage;
                synchronized (map) {
                    typeProxy = (TypeProxy)this.unknownTypesStorage.remove(name);
                    if (typeProxy == null) {
                        typeProxy = tmp;
                    }
                }
                if (typeProxy != null && (old2 = typeStorage.putIfAbsent(name, typeProxy)) != null) {
                    typeProxy = old2;
                }
            } else {
                typeProxy = new TypeProxy(null, name);
                old2 = typeStorage.putIfAbsent(name, typeProxy);
                if (old2 == null) {
                    this.nonVisited.push(typeProxy);
                } else {
                    typeProxy = old2;
                }
            }
        }
        return typeProxy;
    }

    public void onNotVisitedEntries(ProxyTask proxyTask) {
        while (!this.nonVisited.isEmpty()) {
            TypeProxy proxy = this.nonVisited.pop();
            if (proxy.isVisited()) continue;
            proxyTask.on(proxy);
        }
    }

    public void clearNonVisitedEntries() {
        this.nonVisited.clear();
        this.unknownTypesStorage.clear();
    }

    @Override
    public Collection<Type> getAllTypes() {
        ArrayList<Type> allTypes = new ArrayList<Type>();
        for (Map map : this.storage.values()) {
            for (TypeProxy typeProxy : map.values()) {
                if (typeProxy.get() == null) continue;
                allTypes.add((Type)typeProxy.get());
            }
        }
        return allTypes;
    }

    public static interface ProxyTask {
        public void on(TypeProxy<?> var1);
    }
}

