/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.hk2.classmodel.reflect.util.ResourceLocator;
import org.glassfish.hk2.external.org.objectweb.asm.ClassReader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

public class CommonModelRegistry
implements ResourceLocator {
    BundleContext ctx;
    PackageAdmin pkgAdmin;
    private static CommonModelRegistry _instance = new CommonModelRegistry();

    private CommonModelRegistry() {
    }

    public static CommonModelRegistry getInstance() {
        return _instance;
    }

    void initialize(BundleContext ctx, PackageAdmin pkgAdmin) {
        this.ctx = ctx;
        this.pkgAdmin = pkgAdmin;
    }

    public boolean canLoadResources() {
        return this.pkgAdmin != null;
    }

    public void loadModel(ParsingContext ctx, String className) {
        int index = className.lastIndexOf(46);
        String packageName = index > 0 ? className.substring(0, index) : "";
        ExportedPackage pkg = this.pkgAdmin.getExportedPackage(packageName);
        if (pkg != null) {
            Bundle srcBundle = pkg.getExportingBundle();
            String resourceName = className.replace('.', '/');
            if (!resourceName.endsWith(".class")) {
                resourceName = resourceName + ".class";
            }
            URL url = srcBundle.getResource(resourceName);
            byte[] data = null;
            if (url != null) {
                try {
                    InputStream is = url.openStream();
                    data = new byte[is.available()];
                    int remaining = data.length;
                    while (remaining > 0) {
                        int read = is.read(data, data.length - remaining, remaining);
                        if (read <= 0) continue;
                        remaining -= read;
                    }
                    ByteArrayInputStream bis = new ByteArrayInputStream(data);
                    ClassReader cr = new ClassReader((InputStream)bis);
                    cr.accept(ctx.getClassVisitor(url.toURI(), className), 2);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    @Override
    public InputStream openResourceStream(String className) throws IOException {
        int index = className.lastIndexOf(47);
        String packageName = index > 0 ? className.substring(0, index) : "";
        ExportedPackage pkg = this.pkgAdmin.getExportedPackage(packageName.replace('/', '.'));
        ByteArrayInputStream inputStream = null;
        if (pkg != null) {
            Bundle srcBundle = pkg.getExportingBundle();
            URL url = srcBundle.getResource(className);
            byte[] data = null;
            if (url != null) {
                try {
                    InputStream is = url.openStream();
                    data = new byte[is.available()];
                    int remaining = data.length;
                    while (remaining > 0) {
                        int read = is.read(data, data.length - remaining, remaining);
                        if (read <= 0) continue;
                        remaining -= read;
                    }
                    inputStream = new ByteArrayInputStream(data);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return inputStream;
    }

    @Override
    public URL getResource(String className) {
        int index = className.lastIndexOf(47);
        String packageName = index > 0 ? className.substring(0, index) : "";
        ExportedPackage pkg = this.pkgAdmin.getExportedPackage(packageName.replace('/', '.'));
        Object inputStream = null;
        if (pkg != null) {
            Bundle srcBundle = pkg.getExportingBundle();
            return srcBundle.getResource(className);
        }
        return null;
    }
}

