/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.classmodel.reflect.ArchiveAdapter;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.hk2.classmodel.reflect.util.AbstractAdapter;
import org.glassfish.hk2.classmodel.reflect.util.InputStreamArchiveAdapter;

public class JarArchive
extends AbstractAdapter {
    private final Parser parser;
    private final JarFile jar;
    private final URI uri;
    private final AtomicInteger releaseCount = new AtomicInteger(1);

    public JarArchive(Parser parser, URI uri) throws IOException {
        File f = new File(uri);
        this.uri = uri;
        this.jar = new JarFile(f);
        this.parser = parser;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSelectedEntries(ArchiveAdapter.Selector selector, ArchiveAdapter.EntryTask task, final Logger logger) throws IOException {
        Enumeration<JarEntry> enumEntries = this.jar.entries();
        while (enumEntries.hasMoreElements()) {
            JarEntry ja = enumEntries.nextElement();
            if (ja.getName().endsWith(".jar")) {
                URI subURI = null;
                try {
                    subURI = new URI("jar:" + this.uri + "!/" + ja.getName());
                }
                catch (URISyntaxException e) {
                    try {
                        subURI = new URI(ja.getName());
                    }
                    catch (URISyntaxException e1) {
                        logger.log(Level.FINE, "ignoring exception", e1);
                    }
                }
                final InputStreamArchiveAdapter subArchive = new InputStreamArchiveAdapter(this, subURI, this.jar.getInputStream(this.jar.getEntry(ja.getName())));
                this.releaseCount.incrementAndGet();
                this.parser.parse(subArchive, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            subArchive.close();
                        }
                        catch (IOException e) {
                            logger.log(Level.SEVERE, "Cannot close sub archive {0}", subArchive.getURI());
                        }
                    }
                });
                subArchive.onSelectedEntries(selector, task, logger);
            }
            InputStream is = null;
            try {
                ArchiveAdapter.Entry entry = new ArchiveAdapter.Entry(ja.getName(), ja.getSize(), ja.isDirectory());
                if (!selector.isSelected(entry)) continue;
                is = this.jar.getInputStream(ja);
                try {
                    task.on(entry, is);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Exception while processing " + ja.getName() + " inside " + this.jar.getName() + " of size " + ja.getSize(), e);
                }
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
    }

    @Override
    public Manifest getManifest() throws IOException {
        return this.jar.getManifest();
    }

    @Override
    public void close() throws IOException {
        this.releaseCount();
    }

    void releaseCount() throws IOException {
        int release = this.releaseCount.decrementAndGet();
        if (release == 0) {
            this.jar.close();
        }
    }
}

