/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.classmodel.reflect.ArchiveAdapter;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.hk2.classmodel.reflect.util.AbstractAdapter;
import org.glassfish.hk2.classmodel.reflect.util.DirectoryArchive;
import org.glassfish.hk2.classmodel.reflect.util.JarArchive;
import org.objectweb.asm.ClassReader;

public class Parser {
    private final ParsingContext context;
    private final Parser parent;
    private final Map<URI, Types> processedURI = Collections.synchronizedMap(new HashMap());
    private final List<Future<Result>> futures = Collections.synchronizedList(new ArrayList());
    private final ExecutorService executorService;
    private final boolean ownES;

    public Parser(ParsingContext context) {
        this(context, null);
    }

    private Parser(ParsingContext context, Parser parent) {
        this.context = context;
        this.executorService = context.executorService == null ? this.createExecutorService() : context.executorService;
        this.ownES = context.executorService == null;
        this.parent = parent;
    }

    public Exception[] awaitTermination() throws InterruptedException {
        return this.awaitTermination(10, TimeUnit.SECONDS);
    }

    public synchronized Exception[] awaitTermination(int timeOut, TimeUnit unit) throws InterruptedException {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        if (this.context.logger.isLoggable(Level.FINE)) {
            this.context.logger.log(Level.FINE, "awaiting termination of " + this.futures.size() + " tasks");
        }
        for (Future<Result> f : this.futures) {
            try {
                Result result = f.get(timeOut, unit);
                if (this.context.logger.isLoggable(Level.FINER)) {
                    this.context.logger.log(Level.FINER, "result " + result);
                    if (result != null && result.fault != null) {
                        this.context.logger.log(Level.FINER, "result fault" + result);
                    }
                }
                if (result != null && result.fault != null) {
                    exceptions.add(result.fault);
                }
            }
            catch (TimeoutException e) {
                exceptions.add(e);
            }
            catch (ExecutionException e) {
                exceptions.add(e);
            }
            if (this.executorService == null || !this.ownES) continue;
            this.executorService.shutdown();
        }
        return exceptions.toArray(new Exception[exceptions.size()]);
    }

    public void parse(File source, final Runnable doneHook) throws IOException {
        final AbstractAdapter adapter = source.isFile() ? new JarArchive(source.toURI()) : new DirectoryArchive(source);
        Runnable cleanUpAndNotify = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    try {
                        adapter.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    if (doneHook != null) {
                        doneHook.run();
                    }
                }
            }
        };
        this.parse(adapter, cleanUpAndNotify);
    }

    public synchronized void parse(final ArchiveAdapter source, final Runnable doneHook) throws IOException {
        ExecutorService es = this.executorService;
        boolean immediateShutdown = false;
        if (es.isShutdown()) {
            Logger.getAnonymousLogger().info("Executor service is shutdown, since awaitTermination was called, provide an executor service instance from the context to avoid automatic shutdown");
            es = this.createExecutorService();
            immediateShutdown = true;
        }
        final Logger logger = this.context.logger;
        Types types = this.getResult(source.getURI());
        if (types != null) {
            if (!this.processedURI.containsKey(source.getURI())) {
                this.processedURI.put(source.getURI(), types);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Skipping reparsing..." + source.getURI());
            }
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "submitting file " + source.getURI().getPath());
        }
        this.futures.add(es.submit(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "elected file " + source.getURI().getPath());
                    }
                    Parser.this.doJob(source, doneHook);
                    return new Result(source.getURI().getPath(), null);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Exception while parsing file " + source, e);
                    return new Result(source.getURI().getPath(), e);
                }
            }
        }));
        if (immediateShutdown) {
            es.shutdown();
        }
    }

    private Types getResult(URI uri) {
        Types types = this.processedURI.get(uri);
        if (types == null && this.parent != null) {
            types = this.parent.getResult(uri);
        }
        return types;
    }

    private void saveResult(URI uri, Types types) {
        this.processedURI.put(uri, types);
        if (this.parent != null) {
            this.parent.saveResult(uri, types);
        }
    }

    private void doJob(ArchiveAdapter adapter, Runnable doneHook) throws Exception {
        final Logger logger = this.context.logger;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Parsing " + adapter.getURI() + " on thread " + Thread.currentThread().getName());
        }
        if (this.context.archiveSelector == null || this.context.archiveSelector.selects(adapter)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Parsing file " + adapter.getURI().getPath());
            }
            final URI uri = adapter.getURI();
            adapter.onSelectedEntries(new ArchiveAdapter.Selector(){

                @Override
                public boolean isSelected(ArchiveAdapter.Entry entry) {
                    return entry.name.endsWith(".class");
                }
            }, new ArchiveAdapter.EntryTask(){

                @Override
                public void on(ArchiveAdapter.Entry entry, byte[] bytes) throws IOException {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "Parsing class " + entry.name);
                    }
                    ClassReader cr = new ClassReader(bytes, 0, (int)entry.size);
                    try {
                        cr.accept(Parser.this.context.getClassVisitor(uri, entry.name), 2);
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, "Exception while visiting " + entry.name + " of size " + entry.size, e);
                    }
                }
            }, logger);
            this.saveResult(uri, this.context.getTypes());
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "before running doneHook" + adapter.getURI().getPath());
        }
        if (doneHook != null) {
            doneHook.run();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "after running doneHook " + adapter.getURI().getPath());
        }
    }

    public ParsingContext getContext() {
        return this.context;
    }

    private ExecutorService createExecutorService() {
        Runtime runtime = Runtime.getRuntime();
        int nrOfProcessors = runtime.availableProcessors();
        return Executors.newFixedThreadPool(nrOfProcessors, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("Hk2-jar-scanner");
                return t;
            }
        });
    }

    private class Result {
        final String name;
        final Exception fault;

        private Result(String name, Exception fault) {
            this.name = name;
            this.fault = fault;
        }

        public String toString() {
            return super.toString() + " Result for " + this.name;
        }
    }
}

