/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.classmodel.reflect.ArchiveAdapter;
import org.glassfish.hk2.classmodel.reflect.util.AbstractAdapter;

public class InputStreamArchiveAdapter
extends AbstractAdapter {
    private final InputStream is;
    private final URI uri;

    public InputStreamArchiveAdapter(URI uri, InputStream is) {
        this.uri = uri;
        this.is = is;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public Manifest getManifest() throws IOException {
        throw new IOException("Not Implemented");
    }

    @Override
    public void onSelectedEntries(ArchiveAdapter.Selector selector, ArchiveAdapter.EntryTask task, Logger logger) throws IOException {
        JarEntry ja;
        JarInputStream jis = new JarInputStream(this.is);
        byte[] bytes = new byte[52000];
        while ((ja = jis.getNextJarEntry()) != null) {
            ArchiveAdapter.Entry je = new ArchiveAdapter.Entry(ja.getName(), ja.getSize(), ja.isDirectory());
            if (!selector.isSelected(je)) continue;
            try {
                if (ja.getSize() > 0L && (long)jis.read(bytes, 0, (int)ja.getSize()) != ja.getSize()) {
                    logger.severe("Incorrect file length while processing " + ja.getName() + " of size " + ja.getSize());
                }
                task.on(je, bytes);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception while processing " + ja.getName() + " of size " + ja.getSize(), e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }
}

