/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.examples.caching.hk2;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.aopalliance.intercept.ConstructorInterceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.glassfish.examples.caching.aop.CachingConstructorInterceptor;
import org.glassfish.examples.caching.aop.CachingMethodInterceptor;
import org.glassfish.examples.caching.hk2.Cache;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.InterceptionService;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.jvnet.hk2.annotations.Service;

@Service
public class HK2InterceptionService
implements InterceptionService {
    private static final MethodInterceptor METHOD_INTERCEPTOR = new CachingMethodInterceptor();
    private static final ConstructorInterceptor CONSTRUCTOR_INTERCEPTOR = new CachingConstructorInterceptor();
    private static final List<MethodInterceptor> METHOD_LIST = Collections.singletonList(METHOD_INTERCEPTOR);
    private static final List<ConstructorInterceptor> CONSTRUCTOR_LIST = Collections.singletonList(CONSTRUCTOR_INTERCEPTOR);

    public Filter getDescriptorFilter() {
        return BuilderHelper.allFilter();
    }

    public List<MethodInterceptor> getMethodInterceptors(Method method) {
        if (method.isAnnotationPresent(Cache.class)) {
            return METHOD_LIST;
        }
        return null;
    }

    public List<ConstructorInterceptor> getConstructorInterceptors(Constructor<?> constructor) {
        if (constructor.isAnnotationPresent(Cache.class)) {
            return CONSTRUCTOR_LIST;
        }
        return null;
    }
}

