/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jvnet.hk2.Lexer;
import org.jvnet.hk2.Named;
import org.jvnet.hk2.OSGiConstants;

public final class ImportedPackage
extends Named
implements Comparable<ImportedPackage> {
    public final String version;
    public final Map<String, Set<String>> resolutions;

    ImportedPackage(Lexer sc) {
        super(sc);
        if (sc.at(OSGiConstants.RESOLUTION)) {
            this.resolutions = new HashMap<String, Set<String>>();
            while (sc.at(OSGiConstants.RESOLUTION)) {
                sc.read(OSGiConstants.RESOLUTION);
                String resolutionType = sc.readUntil(',');
                if (!this.resolutions.containsKey(resolutionType)) {
                    this.resolutions.put(resolutionType, new HashSet());
                }
                this.resolutions.get(resolutionType).addAll(Arrays.asList(sc.readUntil(';').split(",")));
            }
        } else {
            this.resolutions = Collections.emptyMap();
        }
        if (sc.at(OSGiConstants.VERSION)) {
            sc.read(OSGiConstants.VERSION);
            this.version = ImportedPackage.unquote(sc.read(OSGiConstants.POSSIBLY_QUOTED_TOKEN));
        } else {
            this.version = null;
        }
        if (sc.at(',')) {
            sc.consume(",");
        }
    }

    @Override
    public int compareTo(ImportedPackage that) {
        return this.name.compareTo(that.name);
    }
}

