/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2;

import java.util.regex.Pattern;
import org.jvnet.hk2.Lexer;
import org.jvnet.hk2.Named;

public final class RequiredBundle
extends Named
implements Comparable<RequiredBundle> {
    public final String version;
    public final String resolution;
    public final String visibility;
    static final Pattern PACKAGE = Pattern.compile("[^,;]+");
    static final Pattern BUNDLE_VERSION = Pattern.compile(";bundle-version=\"");
    static final Pattern RESOLUTION = Pattern.compile(";resolution:=");
    static final Pattern VISIBILITY = Pattern.compile(";visibility:=");
    static final Pattern TOKEN = Pattern.compile("[A-Za-z]+");

    RequiredBundle(Lexer sc) {
        super(sc);
        String version = null;
        String resolution = null;
        String visibility = null;
        while (true) {
            if (sc.at(BUNDLE_VERSION)) {
                sc.read(BUNDLE_VERSION);
                version = sc.readUntil('\"');
                sc.consume("\"");
                continue;
            }
            if (sc.at(RESOLUTION)) {
                sc.read(RESOLUTION);
                resolution = sc.read(TOKEN);
                continue;
            }
            if (!sc.at(VISIBILITY)) break;
            sc.read(VISIBILITY);
            visibility = sc.read(TOKEN);
        }
        this.version = version;
        this.resolution = resolution;
        this.visibility = visibility;
        if (sc.at(',')) {
            sc.consume(",");
        }
    }

    @Override
    public int compareTo(RequiredBundle that) {
        return this.name.compareTo(that.name);
    }
}

