/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jvnet.hk2.ExportedPackage;
import org.jvnet.hk2.ImportedPackage;
import org.jvnet.hk2.Lexer;
import org.jvnet.hk2.RequiredBundle;

public class OSGiManifest {
    public final Set<ExportedPackage> exportPackages;
    public final Set<RequiredBundle> requiredBundles;
    public final Set<ImportedPackage> importedPackages;
    public final Set<String> privatePackages;
    public final String version;
    public final String symbolName;
    public final String name;

    public OSGiManifest(Manifest m) {
        Lexer sc;
        Attributes atts = m.getMainAttributes();
        this.name = atts.getValue("Bundle-Name");
        this.version = atts.getValue("Bundle-Version");
        this.symbolName = atts.getValue("Bundle-SymbolicName");
        TreeSet<ImportedPackage> ipkgs = new TreeSet<ImportedPackage>();
        String ip = atts.getValue("Import-Package");
        if (ip != null) {
            sc = new Lexer(ip);
            while (!sc.isEmpty()) {
                ipkgs.add(new ImportedPackage(sc));
            }
        }
        this.importedPackages = Collections.unmodifiableSet(ipkgs);
        String pp = atts.getValue("Private-Package");
        this.privatePackages = pp != null ? Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList(pp.split(",")))) : Collections.emptySet();
        TreeSet<ExportedPackage> pkgs = new TreeSet<ExportedPackage>();
        String ep = atts.getValue("Export-Package");
        if (ep != null) {
            sc = new Lexer(ep);
            while (!sc.isEmpty()) {
                pkgs.add(new ExportedPackage(sc));
            }
        }
        this.exportPackages = Collections.unmodifiableSet(pkgs);
        TreeSet<RequiredBundle> bundles = new TreeSet<RequiredBundle>();
        String rb = atts.getValue("Require-Bundle");
        if (rb != null) {
            sc = new Lexer(rb);
            while (!sc.isEmpty()) {
                bundles.add(new RequiredBundle(sc));
            }
        }
        this.requiredBundles = Collections.unmodifiableSet(bundles);
    }
}

