/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Lexer {
    private String str;

    public Lexer(String str) {
        this.str = str;
    }

    public String consume(String s) {
        if (!this.str.startsWith(s)) {
            throw new IllegalStateException("Expecting " + s + " bout found " + this.str);
        }
        this.str = this.str.substring(s.length());
        return s;
    }

    private String consume(int len) {
        String r = this.str.substring(0, len);
        this.str = this.str.substring(len);
        return r;
    }

    public boolean at(Pattern p) {
        return p.matcher(this.str).lookingAt();
    }

    public String read(Pattern p) {
        Matcher m = p.matcher(this.str);
        if (m.lookingAt()) {
            return this.consume(m.group());
        }
        throw new IllegalStateException("Expecting " + p + " but found " + this.str);
    }

    public String readUntil(char ch) {
        if (this.str.indexOf(ch) == -1) {
            return this.str;
        }
        return this.consume(this.str.indexOf(ch));
    }

    public char nextChar() {
        return this.consume(1).charAt(0);
    }

    public boolean at(char ch) {
        return !this.isEmpty() && this.str.charAt(0) == ch;
    }

    public boolean isEmpty() {
        return this.str.length() == 0;
    }
}

