/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.classmodel;

import com.sun.enterprise.tools.InhabitantsDescriptor;
import com.sun.enterprise.tools.classmodel.CodeSourceFilter;
import com.sun.enterprise.tools.classmodel.Constants;
import com.sun.enterprise.tools.classmodel.Utilities;
import com.sun.hk2.component.InhabitantsParser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.classmodel.ClassPath;
import org.jvnet.hk2.component.classmodel.InhabitantsFeed;
import org.jvnet.hk2.component.classmodel.InhabitantsParsingContextGenerator;

public class InhabitantsGenerator
extends Constants {
    private static final Logger logger = Logger.getLogger(InhabitantsGenerator.class.getName());
    private static HashSet<String> IGNORE = new HashSet();
    private final CodeSourceFilter codeSourceFilter;
    private final InhabitantsParsingContextGenerator ipcGen;
    private final InhabitantsDescriptor descriptor;

    public InhabitantsGenerator(InhabitantsDescriptor descriptor, ClassPath inhabitantsSourceFiles, ClassPath inhabitantsClassPath) {
        inhabitantsClassPath = this.filterIgnores(inhabitantsClassPath);
        FileFilter advisor = null;
        logger.log(Level.FINE, "working classpath: {0}", inhabitantsClassPath);
        this.ipcGen = InhabitantsParsingContextGenerator.create(null, (ExecutorService)this.createExecutorService(), (ClassPath)inhabitantsClassPath, advisor);
        if (null != descriptor) {
            this.descriptor = descriptor;
        } else {
            this.descriptor = new InhabitantsDescriptor();
            this.descriptor.setComment("by " + this.getClass().getName());
        }
        try {
            logger.log(Level.FINE, "Parsing: {0}", inhabitantsSourceFiles);
            this.ipcGen.parse((Collection)inhabitantsSourceFiles.getFileEntries());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.codeSourceFilter = new CodeSourceFilter(inhabitantsSourceFiles);
    }

    private ExecutorService createExecutorService() {
        return null;
    }

    private ClassPath filterIgnores(ClassPath inhabitantsClassPath) {
        LinkedHashSet<File> newFiles = new LinkedHashSet<File>();
        LinkedHashSet entries = new LinkedHashSet(inhabitantsClassPath.getFileEntries());
        for (File file : entries) {
            if (!IGNORE.contains(file.getName())) {
                logger.log(Level.FINE, "accepting {0}", file);
                newFiles.add(file);
                continue;
            }
            logger.log(Level.FINE, "filtering {0}", file);
        }
        ClassPath newClassPath = ClassPath.create(null, newFiles);
        return newClassPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(File targetInhabitantFile, boolean sort) throws IOException {
        PrintWriter w;
        File parent = targetInhabitantFile.getParentFile();
        if (null != parent) {
            parent.mkdirs();
        }
        ByteArrayOutputStream out = null;
        if (sort) {
            out = new ByteArrayOutputStream();
            w = new PrintWriter(out);
        } else {
            w = new PrintWriter(targetInhabitantFile, "UTF-8");
        }
        try {
            this.generate(w);
        }
        finally {
            w.close();
        }
        if (this.descriptor.isEmpty()) {
            targetInhabitantFile.delete();
            return;
        }
        if (sort) {
            String sorterdInhabitants = Utilities.sortInhabitantsDescriptor(out.toString(), sort);
            FileOutputStream fos = new FileOutputStream(targetInhabitantFile);
            fos.write(sorterdInhabitants.getBytes());
            fos.close();
        }
    }

    public void generate(PrintWriter writer) throws IOException {
        this.descriptor.clear();
        InhabitantsParserDescriptorWriter ip = new InhabitantsParserDescriptorWriter();
        InhabitantsFeed feed = InhabitantsFeed.create((Habitat)new Habitat(), (InhabitantsParser)ip);
        feed.populate(this.ipcGen);
        ip.flush();
        this.descriptor.write(writer);
    }

    InhabitantsParsingContextGenerator getContextGenerator() {
        return this.ipcGen;
    }

    public static void main(String[] args) throws Exception {
        File targetInhabitantFile = InhabitantsGenerator.getInhabitantFile("inhabitants.target.file", false);
        ClassPath inhabitantsSourceFiles = InhabitantsGenerator.getScopedInhabitantCodeSources();
        ClassPath inhabitantsClassPath = InhabitantsGenerator.getFullInhabitantsClassPath();
        boolean sort = Boolean.getBoolean("inhabitants.sorted");
        if (inhabitantsSourceFiles.getEntries().isEmpty()) {
            System.err.println("WARNING: nothing to do!");
            return;
        }
        InhabitantsDescriptor descriptor = null;
        InhabitantsGenerator generator = new InhabitantsGenerator(descriptor, inhabitantsSourceFiles, inhabitantsClassPath);
        generator.generate(targetInhabitantFile, sort);
    }

    static ClassPath getFullInhabitantsClassPath() {
        ClassPath inhabitantsClassPath = null;
        String arg = System.getProperty("inhabitants.classpath");
        if (null == arg || arg.isEmpty()) {
            inhabitantsClassPath = ClassPath.create(null, (boolean)false);
            System.err.println("WARNING: sysprop inhabitants.classpath is missing; defaulting to system classpath; this may result in an invalid inhabitants file being created.");
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "classpath={0}", inhabitantsClassPath.getFileEntries());
            }
        } else {
            inhabitantsClassPath = ClassPath.create(null, (String)arg);
        }
        return inhabitantsClassPath;
    }

    static ClassPath getScopedInhabitantCodeSources() {
        String[] sourceFileNames;
        String arg = System.getProperty("inhabitants.source.files");
        if (null == arg || arg.isEmpty()) {
            System.err.println("ERROR: sysprop inhabitants.source.files is expected");
            System.exit(-1);
        }
        ArrayList<File> sourceFiles = new ArrayList<File>();
        for (String sourceFile : sourceFileNames = arg.split(File.pathSeparator)) {
            File source = new File(sourceFile);
            if (source.exists()) {
                sourceFiles.add(source);
                continue;
            }
            System.err.println("WARNING: can't find " + sourceFile);
        }
        ClassPath inhabitantsSourceFiles = ClassPath.create(null, sourceFiles);
        return inhabitantsSourceFiles;
    }

    static File getInhabitantFile(String key, boolean mustExist) {
        String arg = System.getProperty(key);
        if (null == arg || arg.isEmpty()) {
            System.err.println("ERROR: sysprop " + key + " is expected");
            System.exit(-1);
        }
        File targetInhabitantFile = new File(arg);
        if (mustExist && !targetInhabitantFile.exists()) {
            System.err.println("ERROR: " + targetInhabitantFile + " does not exist");
            System.exit(-1);
        }
        return targetInhabitantFile;
    }

    static {
        IGNORE.add("rt.jar");
        IGNORE.add("tools.jar");
    }

    private class InhabitantsParserDescriptorWriter
    extends InhabitantsParser {
        private Inhabitant<?> pendingInhabitant;
        private List<String> pendingUnamedContracts;

        private InhabitantsParserDescriptorWriter() {
            super(null);
        }

        public void flush() {
            if (null != this.pendingInhabitant) {
                logger.log(Level.INFO, "adding inhabitant {0} with contracts {1}", new Object[]{this.pendingInhabitant, this.pendingUnamedContracts});
                InhabitantsGenerator.this.descriptor.putAll(this.pendingInhabitant.typeName(), null, this.pendingUnamedContracts, null, this.pendingInhabitant.metadata());
                this.pendingUnamedContracts = null;
                this.pendingInhabitant = null;
            }
        }

        protected boolean isFilteredInhabitant(String typeName) {
            if (null == InhabitantsGenerator.this.codeSourceFilter || InhabitantsGenerator.this.codeSourceFilter.matches(typeName)) {
                logger.log(Level.FINE, "accepting {0}", typeName);
                return false;
            }
            logger.log(Level.FINE, "filtering {0}", typeName);
            return true;
        }

        public void add(Inhabitant<?> i) {
            this.flush();
            this.pendingInhabitant = i;
        }

        public void addIndex(Inhabitant<?> i, String typeName, String name) {
            if (null == this.pendingUnamedContracts) {
                this.pendingUnamedContracts = new ArrayList<String>();
            }
            if (null == name) {
                this.pendingUnamedContracts.add(typeName);
            } else {
                this.pendingUnamedContracts.add(typeName + ":" + name);
            }
        }
    }
}

