/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.apt;

import com.sun.enterprise.tools.apt.ServiceFileInfo;
import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorListener;
import com.sun.mirror.apt.RoundCompleteEvent;
import com.sun.mirror.apt.RoundCompleteListener;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.MirroredTypeException;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.DeclarationVisitors;
import com.sun.mirror.util.SimpleDeclarationVisitor;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.ContractProvided;
import org.jvnet.hk2.annotations.Service;

public class ServiceAnnotationProcessor
implements AnnotationProcessor,
RoundCompleteListener {
    private final boolean debug;
    private final AnnotationProcessorEnvironment env;
    private Map<String, ServiceFileInfo> serviceFiles = new HashMap<String, ServiceFileInfo>();

    public ServiceAnnotationProcessor(AnnotationProcessorEnvironment env) {
        this.env = env;
        env.addListener((AnnotationProcessorListener)this);
        this.debug = env.getOptions().containsKey("-Adebug");
        if (this.debug) {
            env.getMessager().printNotice(env.getOptions().toString());
        }
        this.loadExistingMetaInfFiles();
    }

    protected void loadExistingMetaInfFiles() {
        String outDirectory = (String)this.env.getOptions().get("-s");
        if (outDirectory == null) {
            outDirectory = System.getProperty("user.dir");
        }
        File outDir = new File(new File(outDirectory), "META-INF/services").getAbsoluteFile();
        if (this.debug) {
            this.env.getMessager().printNotice("Output dir is " + outDir.getAbsolutePath());
        }
        if (!outDir.exists()) {
            return;
        }
        for (File file : outDir.listFiles()) {
            if (file.isDirectory()) continue;
            HashSet<String> entries = new HashSet<String>();
            try {
                FileReader reader = new FileReader(file);
                LineNumberReader lineReader = new LineNumberReader(reader);
                String line = lineReader.readLine();
                while (line != null) {
                    entries.add(line);
                    line = lineReader.readLine();
                }
            }
            catch (IOException e) {
                this.env.getMessager().printError(e.getMessage());
            }
            ServiceFileInfo info = new ServiceFileInfo(file.getName(), entries);
            this.serviceFiles.put(file.getName(), info);
        }
    }

    public void process() {
        DeclarationVisitor scanner = DeclarationVisitors.getDeclarationScanner((DeclarationVisitor)new ListClassVisitor(), (DeclarationVisitor)DeclarationVisitors.NO_OP);
        for (TypeDeclaration typeDecl : this.env.getSpecifiedTypeDeclarations()) {
            typeDecl.accept(scanner);
        }
    }

    private void createContractImplementation(String contractName, ClassDeclaration impl) {
        ServiceFileInfo info;
        if (!this.serviceFiles.containsKey(contractName)) {
            info = new ServiceFileInfo(contractName, new HashSet<String>());
            this.serviceFiles.put(contractName, info);
        } else {
            info = this.serviceFiles.get(contractName);
        }
        if (info.getImplementors().add(impl.getQualifiedName())) {
            try {
                info.createFile(this.env);
            }
            catch (IOException ioe) {
                this.env.getMessager().printError(ioe.getMessage());
            }
        }
    }

    public void roundComplete(RoundCompleteEvent e) {
        for (ServiceFileInfo info : this.serviceFiles.values()) {
            if (!info.isDirty()) continue;
            if (this.debug) {
                this.env.getMessager().printNotice("Creating META-INF/services " + info.getServiceName() + " file");
            }
            PrintWriter writer = info.getWriter();
            for (String implementor : info.getImplementors()) {
                if (this.debug) {
                    this.env.getMessager().printNotice(" Implementor " + implementor);
                }
                writer.println(implementor);
            }
            writer.close();
        }
    }

    private class ListClassVisitor
    extends SimpleDeclarationVisitor {
        private ListClassVisitor() {
        }

        public void visitClassDeclaration(ClassDeclaration d) {
            if (ServiceAnnotationProcessor.this.debug) {
                ServiceAnnotationProcessor.this.env.getMessager().printNotice("Visiting " + d.getQualifiedName());
            }
            Service service = (Service)d.getAnnotation(Service.class);
            if (ServiceAnnotationProcessor.this.debug) {
                ServiceAnnotationProcessor.this.env.getMessager().printNotice("Service annotation = " + service);
            }
            if (service != null) {
                this.checkContractProvided(d);
                for (InterfaceType intf : d.getSuperinterfaces()) {
                    this.checkContract((TypeDeclaration)intf.getDeclaration(), d);
                }
                ClassDeclaration sd = d;
                while (sd.getSuperclass() != null) {
                    sd = sd.getSuperclass().getDeclaration();
                    this.checkContract((TypeDeclaration)sd, d);
                }
            } else {
                for (ServiceFileInfo info : ServiceAnnotationProcessor.this.serviceFiles.values()) {
                    if (ServiceAnnotationProcessor.this.debug) {
                        ServiceAnnotationProcessor.this.env.getMessager().printNotice("Checking against " + info.getServiceName());
                    }
                    for (String implementor : info.getImplementors()) {
                        if (!implementor.equals(d.getQualifiedName())) continue;
                        if (ServiceAnnotationProcessor.this.debug) {
                            ServiceAnnotationProcessor.this.env.getMessager().printNotice("Need to remove " + implementor);
                        }
                        info.getImplementors().remove(implementor);
                        try {
                            info.createFile(ServiceAnnotationProcessor.this.env);
                        }
                        catch (IOException ioe) {
                            ServiceAnnotationProcessor.this.env.getMessager().printError(ioe.getMessage());
                        }
                        return;
                    }
                }
            }
            for (AnnotationMirror a : d.getAnnotationMirrors()) {
                AnnotationTypeDeclaration atd = a.getAnnotationType().getDeclaration();
                Contract c = (Contract)atd.getAnnotation(Contract.class);
                if (c == null) continue;
                ServiceAnnotationProcessor.this.createContractImplementation(atd.getQualifiedName(), d);
            }
        }

        private void checkContractProvided(ClassDeclaration impl) {
            ContractProvided provided = (ContractProvided)impl.getAnnotation(ContractProvided.class);
            String intfName = null;
            if (provided != null) {
                try {
                    provided.value();
                }
                catch (MirroredTypeException e) {
                    intfName = e.getQualifiedName();
                }
                if (ServiceAnnotationProcessor.this.debug) {
                    System.out.println("Provided is " + intfName);
                }
                ServiceAnnotationProcessor.this.createContractImplementation(intfName, impl);
            }
        }

        private void checkContract(TypeDeclaration type, ClassDeclaration impl) {
            Contract contract = (Contract)type.getAnnotation(Contract.class);
            if (contract != null) {
                ServiceAnnotationProcessor.this.createContractImplementation(type.getQualifiedName(), impl);
            }
        }
    }
}

